/*
 * Decompiled with CFR 0.152.
 */
package mob_grinding_utils.inventory.client;

import java.util.ArrayList;
import javax.annotation.Nonnull;
import mob_grinding_utils.inventory.client.GuiMGUButton;
import mob_grinding_utils.inventory.client.MGUScreen;
import mob_grinding_utils.inventory.client.TankGauge;
import mob_grinding_utils.inventory.server.ContainerXPSolidifier;
import mob_grinding_utils.network.BEGuiClick;
import mob_grinding_utils.tile.TileEntityXPSolidifier;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.neoforged.neoforge.network.PacketDistributor;

public class GuiXPSolidifier
extends MGUScreen<ContainerXPSolidifier> {
    protected final ContainerXPSolidifier container;
    private final TileEntityXPSolidifier tile;
    private TankGauge tankGauge;

    public GuiXPSolidifier(ContainerXPSolidifier screenContainer, Inventory inv, Component titleIn) {
        super(screenContainer, inv, titleIn, new ResourceLocation("mob_grinding_utils:textures/gui/solidifier_gui.png"));
        this.container = screenContainer;
        this.tile = this.container.tile;
        this.imageHeight = 186;
        this.imageWidth = 176;
    }

    protected void init() {
        super.init();
        this.tankGauge = new TankGauge(this.leftPos + 8, this.topPos + 18, 12, 70, this.tile.tank);
        this.addRenderableWidget((GuiEventListener)this.tankGauge);
        this.addRenderableWidget((GuiEventListener)new GuiMGUButton(this.leftPos + 62, this.topPos + 72, GuiMGUButton.Size.SOLIDIFIER, 0, (Component)Component.literal((String)"Push"), button -> PacketDistributor.SERVER.noArg().send(new CustomPacketPayload[]{new BEGuiClick(this.tile.getBlockPos(), 0)})));
        this.addRenderableWidget((GuiEventListener)new GuiMGUButton(this.leftPos + 148, this.topPos + 8, GuiMGUButton.Size.SOLIDIFIER_ON, 0, (Component)Component.literal((String)""), button -> PacketDistributor.SERVER.noArg().send(new CustomPacketPayload[]{new BEGuiClick(this.tile.getBlockPos(), 1)})));
    }

    @Override
    protected void renderLabels(@Nonnull GuiGraphics gg, int x, int y) {
        gg.drawString(this.font, (Component)Component.translatable((String)"block.mob_grinding_utils.xpsolidifier"), 7, 6, 0x404040, false);
        gg.drawString(this.font, (Component)Component.translatable((String)"container.inventory"), 8, this.imageHeight - 96 + 2, 0x404040, false);
        gg.drawString(this.font, this.tile.isOn ? "On" : "Off", 158.0f - (float)this.font.width(this.tile.isOn ? "On" : "Off") / 2.0f, 12.0f, 0xE0E0E0, true);
    }

    @Override
    protected void renderBg(@Nonnull GuiGraphics gg, float partialTicks, int mouseX, int mouseY) {
        boolean zLevel = false;
        gg.blit(this.TEX, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
        gg.drawString(this.font, this.tile.outputDirection.getSerializedName(), (float)(this.leftPos + 124) - (float)this.font.width(this.tile.outputDirection.getSerializedName()) / 2.0f, (float)(this.topPos + 76), 5285857, false);
        gg.blit(this.TEX, this.leftPos + 7, this.topPos + 17, 178, 0, 6, 71);
        gg.blit(this.TEX, this.leftPos + 91, this.topPos + 36, 178, 73, this.tile.getProgressScaled(24), 17);
    }

    protected void renderTooltip(@Nonnull GuiGraphics gg, int x, int y) {
        super.renderTooltip(gg, x, y);
        if (this.tankGauge.isHovered()) {
            ArrayList<Object> tooltip = new ArrayList<Object>();
            tooltip.add(this.tile.tank.getFluid().getDisplayName());
            tooltip.add(Component.literal((String)(this.tile.tank.getFluidAmount() + "/" + this.tile.tank.getCapacity())));
            gg.renderComponentTooltip(this.font, tooltip, x, y);
        }
    }
}

