/*
 * Decompiled with CFR 0.152.
 */
package mob_grinding_utils.inventory.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;

public class TankGauge
extends AbstractWidget {
    private final FluidTank tank;
    private Fluid oldFluid;
    private TextureAtlasSprite sprite;

    public TankGauge(int pX, int pY, int pWidth, int pHeight, FluidTank tankIn) {
        super(pX, pY, pWidth, pHeight, (Component)Component.empty());
        this.tank = tankIn;
    }

    protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        float fluidLevel = this.getFluidLevel();
        if (this.tank == null) {
            return;
        }
        FluidStack stack = this.tank.getFluid();
        if (fluidLevel > 0.0f) {
            IClientFluidTypeExtensions fluidTypeExtension = IClientFluidTypeExtensions.of((Fluid)stack.getFluid());
            int color = fluidTypeExtension.getTintColor(stack);
            float red = (float)((double)FastColor.ARGB32.red((int)color) / 255.0);
            float green = (float)((double)FastColor.ARGB32.green((int)color) / 255.0);
            float blue = (float)((double)FastColor.ARGB32.blue((int)color) / 255.0);
            float alpha = (float)((double)FastColor.ARGB32.alpha((int)color) / 255.0);
            ResourceLocation stillTexture = fluidTypeExtension.getStillTexture();
            if (this.sprite == null || this.oldFluid != stack.getFluid()) {
                TextureAtlasSprite sprite;
                this.oldFluid = stack.getFluid();
                AbstractTexture texture = Minecraft.getInstance().getTextureManager().getTexture(InventoryMenu.BLOCK_ATLAS);
                if (texture instanceof TextureAtlas && (sprite = ((TextureAtlas)texture).getSprite(stillTexture)) != null) {
                    this.sprite = sprite;
                }
            }
            if (this.sprite != null) {
                float minU = this.sprite.getU0();
                float maxU = this.sprite.getU1();
                float minV = this.sprite.getV0();
                float maxV = this.sprite.getV1();
                float deltaV = maxV - minV;
                double tankLevel = fluidLevel * (float)this.height;
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)InventoryMenu.BLOCK_ATLAS);
                RenderSystem.setShaderColor((float)red, (float)green, (float)blue, (float)alpha);
                RenderSystem.enableBlend();
                int count = 1 + (int)Math.ceil(tankLevel) / 16;
                for (int i = 0; i < count; ++i) {
                    double subHeight = Math.min(16.0, tankLevel - 16.0 * (double)i);
                    double offsetY = (double)this.height - 16.0 * (double)i - subHeight;
                    this.drawQuad(this.getX(), (double)this.getY() + offsetY, this.width, subHeight, minU, (float)((double)maxV - (double)deltaV * (subHeight / 16.0)), maxU, maxV);
                }
                RenderSystem.disableBlend();
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
        }
    }

    private void drawQuad(double x, double y, double width, double height, float minU, float minV, float maxU, float maxV) {
        Tesselator tesselator = Tesselator.getInstance();
        BufferBuilder buffer = tesselator.getBuilder();
        buffer.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        buffer.vertex(x, y + height, 0.0).uv(minU, maxV).endVertex();
        buffer.vertex(x + width, y + height, 0.0).uv(maxU, maxV).endVertex();
        buffer.vertex(x + width, y, 0.0).uv(maxU, minV).endVertex();
        buffer.vertex(x, y, 0.0).uv(minU, minV).endVertex();
        tesselator.end();
    }

    public float getFluidLevel() {
        return this.tank != null ? (float)this.tank.getFluid().getAmount() / (float)this.tank.getCapacity() : 0.0f;
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
    }
}

