/*
 * Decompiled with CFR 0.152.
 */
package mob_grinding_utils.inventory.server;

import javax.annotation.Nonnull;
import mob_grinding_utils.ModContainers;
import mob_grinding_utils.ModItems;
import mob_grinding_utils.config.ServerConfig;
import mob_grinding_utils.inventory.server.SlotRestriction;
import mob_grinding_utils.tile.TileEntitySaw;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;

public class ContainerSaw
extends AbstractContainerMenu {
    private final int numRows = 2;
    public TileEntitySaw saw;

    public ContainerSaw(int windowId, Inventory playerInventory, FriendlyByteBuf extra) {
        super((MenuType)ModContainers.SAW.get(), windowId);
        int j;
        BlockPos tilePos = extra.readBlockPos();
        BlockEntity tile = playerInventory.player.getCommandSenderWorld().getBlockEntity(tilePos);
        if (!(tile instanceof TileEntitySaw)) {
            return;
        }
        this.saw = (TileEntitySaw)tile;
        int i = -36;
        this.addSlot(new SlotRestriction((Container)tile, 0, 18, 18, new ItemStack((ItemLike)ModItems.SAW_UPGRADE_SHARPNESS.get(), 1), (Integer)ServerConfig.MASHER_MAX_UPGRADES.get()));
        this.addSlot(new SlotRestriction((Container)tile, 1, 43, 18, new ItemStack((ItemLike)ModItems.SAW_UPGRADE_LOOTING.get(), 1), (Integer)ServerConfig.MASHER_MAX_UPGRADES.get()));
        this.addSlot(new SlotRestriction((Container)tile, 2, 68, 18, new ItemStack((ItemLike)ModItems.SAW_UPGRADE_FIRE.get(), 1), (Integer)ServerConfig.MASHER_MAX_UPGRADES.get()));
        this.addSlot(new SlotRestriction((Container)tile, 3, 93, 18, new ItemStack((ItemLike)ModItems.SAW_UPGRADE_SMITE.get(), 1), (Integer)ServerConfig.MASHER_MAX_UPGRADES.get()));
        this.addSlot(new SlotRestriction((Container)tile, 4, 118, 18, new ItemStack((ItemLike)ModItems.SAW_UPGRADE_ARTHROPOD.get(), 1), (Integer)ServerConfig.MASHER_MAX_UPGRADES.get()));
        this.addSlot(new SlotRestriction((Container)tile, 5, 143, 18, new ItemStack((ItemLike)ModItems.SAW_UPGRADE_BEHEADING.get(), 1), (Integer)ServerConfig.MASHER_MAX_UPGRADES.get()));
        for (j = 0; j < 3; ++j) {
            for (int k = 0; k < 9; ++k) {
                this.addSlot(new Slot((Container)playerInventory, k + j * 9 + 9, 8 + k * 18, 86 + j * 18 + i));
            }
        }
        for (j = 0; j < 9; ++j) {
            this.addSlot(new Slot((Container)playerInventory, j, 8 + j * 18, 144 + i));
        }
    }

    public boolean stillValid(@Nonnull Player player) {
        return true;
    }

    @Nonnull
    public ItemStack quickMoveStack(@Nonnull Player player, int slotIndex) {
        ItemStack stack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(slotIndex);
        if (slot != null && slot.hasItem()) {
            ItemStack stack1 = slot.getItem();
            stack = stack1.copy();
            if (slotIndex > 5) {
                if (stack1.getItem() == ModItems.SAW_UPGRADE_SHARPNESS.get() && !this.moveItemStackTo(stack1, 0, 1, false)) {
                    return ItemStack.EMPTY;
                }
                if (stack1.getItem() == ModItems.SAW_UPGRADE_LOOTING.get() && !this.moveItemStackTo(stack1, 1, 2, false)) {
                    return ItemStack.EMPTY;
                }
                if (stack1.getItem() == ModItems.SAW_UPGRADE_FIRE.get() && !this.moveItemStackTo(stack1, 2, 3, false)) {
                    return ItemStack.EMPTY;
                }
                if (stack1.getItem() == ModItems.SAW_UPGRADE_SMITE.get() && !this.moveItemStackTo(stack1, 3, 4, false)) {
                    return ItemStack.EMPTY;
                }
                if (stack1.getItem() == ModItems.SAW_UPGRADE_ARTHROPOD.get() && !this.moveItemStackTo(stack1, 4, 5, false)) {
                    return ItemStack.EMPTY;
                }
                if (stack1.getItem() == ModItems.SAW_UPGRADE_BEHEADING.get() && !this.moveItemStackTo(stack1, 5, 6, false)) {
                    return ItemStack.EMPTY;
                }
            } else if (!this.moveItemStackTo(stack1, 6, this.slots.size(), false)) {
                return ItemStack.EMPTY;
            }
            if (stack1.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (stack1.getCount() != stack.getCount()) {
                slot.onTake(player, stack1);
            } else {
                return ItemStack.EMPTY;
            }
        }
        return stack;
    }

    protected boolean moveItemStackTo(@Nonnull ItemStack stack, int startIndex, int endIndex, boolean reverseDirection) {
        ItemStack slotstack;
        Slot slot;
        boolean merged = false;
        int slotIndex = startIndex;
        if (reverseDirection) {
            slotIndex = endIndex - 1;
        }
        if (stack.isStackable()) {
            while (stack.getCount() > 0 && (!reverseDirection && slotIndex < endIndex || reverseDirection && slotIndex >= startIndex)) {
                slot = (Slot)this.slots.get(slotIndex);
                slotstack = slot.getItem();
                if (!slotstack.isEmpty() && slotstack.getItem() == stack.getItem() && stack.getDamageValue() == slotstack.getDamageValue() && ItemStack.isSameItemSameTags((ItemStack)stack, (ItemStack)slotstack) && slotstack.getCount() < slot.getMaxStackSize()) {
                    int mergedStackSize = stack.getCount() + Math.min(slotstack.getCount(), slot.getMaxStackSize());
                    if (mergedStackSize <= stack.getMaxStackSize() && mergedStackSize <= slot.getMaxStackSize()) {
                        stack.setCount(0);
                        slotstack.setCount(mergedStackSize);
                        slot.setChanged();
                        merged = true;
                    } else if (slotstack.getCount() < stack.getMaxStackSize() && slotstack.getCount() < slot.getMaxStackSize()) {
                        if (slot.getMaxStackSize() >= stack.getMaxStackSize()) {
                            stack.shrink(stack.getMaxStackSize() - slotstack.getCount());
                            slotstack.setCount(stack.getMaxStackSize());
                            slot.setChanged();
                            merged = true;
                        } else if (slot.getMaxStackSize() < stack.getMaxStackSize()) {
                            stack.shrink(slot.getMaxStackSize() - slotstack.getCount());
                            slotstack.setCount(slot.getMaxStackSize());
                            slot.setChanged();
                            merged = true;
                        }
                    }
                }
                if (reverseDirection) {
                    --slotIndex;
                    continue;
                }
                ++slotIndex;
            }
        }
        if (stack.getCount() > 0) {
            slotIndex = reverseDirection ? endIndex - 1 : startIndex;
            while (!reverseDirection && slotIndex < endIndex || reverseDirection && slotIndex >= startIndex) {
                slot = (Slot)this.slots.get(slotIndex);
                slotstack = slot.getItem();
                if (slotstack.isEmpty() && slot.mayPlace(stack) && slot.getMaxStackSize() < stack.getCount()) {
                    ItemStack copy = stack.copy();
                    copy.setCount(slot.getMaxStackSize());
                    stack.shrink(slot.getMaxStackSize());
                    slot.set(copy);
                    slot.setChanged();
                    merged = true;
                    break;
                }
                if (slotstack.isEmpty() && slot.mayPlace(stack)) {
                    slot.set(stack.copy());
                    slot.setChanged();
                    stack.setCount(0);
                    merged = true;
                    break;
                }
                if (reverseDirection) {
                    --slotIndex;
                    continue;
                }
                ++slotIndex;
            }
        }
        return merged;
    }
}

