/*
 * Decompiled with CFR 0.152.
 */
package mob_grinding_utils.inventory.server;

import javax.annotation.Nonnull;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemHandlerHelper;

public class InventoryWrapperAH
implements IItemHandlerModifiable {
    private final Container inv;

    public InventoryWrapperAH(Container inv) {
        this.inv = inv;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InventoryWrapperAH that = (InventoryWrapperAH)o;
        return this.getInv().equals(that.getInv());
    }

    public int hashCode() {
        return this.getInv().hashCode();
    }

    public int getSlots() {
        return this.getInv().getContainerSize();
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        return this.getInv().getItem(slot);
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        if (stack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        ItemStack stackInSlot = this.getInv().getItem(slot);
        if (!stackInSlot.isEmpty()) {
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)stackInSlot)) {
                return stack;
            }
            if (!this.getInv().canPlaceItem(slot, stack)) {
                return stack;
            }
            int m = Math.min(stack.getMaxStackSize(), this.getSlotLimit(slot)) - stackInSlot.getCount();
            if (stack.getCount() <= m) {
                if (!simulate) {
                    ItemStack copy = stack.copy();
                    copy.grow(stackInSlot.getCount());
                    this.getInv().setItem(slot, copy);
                    this.getInv().setChanged();
                }
                return ItemStack.EMPTY;
            }
            stack = stack.copy();
            if (!simulate) {
                ItemStack copy = stack.split(m);
                copy.grow(stackInSlot.getCount());
                this.getInv().setItem(slot, copy);
                this.getInv().setChanged();
            } else {
                stack.shrink(m);
            }
            return stack;
        }
        if (!this.getInv().canPlaceItem(slot, stack)) {
            return stack;
        }
        int m = Math.min(stack.getMaxStackSize(), this.getSlotLimit(slot));
        if (m < stack.getCount()) {
            stack = stack.copy();
            if (!simulate) {
                this.getInv().setItem(slot, stack.split(m));
                this.getInv().setChanged();
            } else {
                stack.shrink(m);
            }
            return stack;
        }
        if (!simulate) {
            this.getInv().setItem(slot, stack);
            this.getInv().setChanged();
        }
        return ItemStack.EMPTY;
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (amount == 0) {
            return ItemStack.EMPTY;
        }
        ItemStack stackInSlot = this.getInv().getItem(slot);
        if (stackInSlot.isEmpty()) {
            return ItemStack.EMPTY;
        }
        if (slot == 0) {
            return ItemStack.EMPTY;
        }
        if (simulate) {
            if (stackInSlot.getCount() < amount) {
                return stackInSlot.copy();
            }
            ItemStack copy = stackInSlot.copy();
            copy.setCount(amount);
            return copy;
        }
        int m = Math.min(stackInSlot.getCount(), amount);
        ItemStack decrStackSize = this.getInv().removeItem(slot, m);
        this.getInv().setChanged();
        return decrStackSize;
    }

    public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
        this.getInv().setItem(slot, stack);
    }

    public int getSlotLimit(int slot) {
        return this.getInv().getMaxStackSize();
    }

    public Container getInv() {
        return this.inv;
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        return slot != 0;
    }
}

