/*
 * Decompiled with CFR 0.152.
 */
package mob_grinding_utils.items;

import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mob_grinding_utils.ModItems;
import mob_grinding_utils.ModTags;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SpawnerBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class ItemMobSwab
extends Item {
    public boolean used;

    public ItemMobSwab(Item.Properties properties, boolean used) {
        super(properties);
        this.used = used;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(@Nonnull ItemStack stack, @Nullable Level world, @Nonnull List<Component> list, @Nonnull TooltipFlag flag) {
        if (!this.used) {
            list.add((Component)Component.translatable((String)"tooltip.mobswab_1").withStyle(ChatFormatting.YELLOW));
        } else if (stack.hasTag() && Objects.requireNonNull(stack.getTag()).contains("mguMobName")) {
            list.add((Component)Component.translatable((String)"tooltip.mobswab_2").withStyle(ChatFormatting.YELLOW));
            list.add((Component)Component.translatable((String)"tooltip.mobswab_3").withStyle(ChatFormatting.GREEN).append(" " + Objects.requireNonNull(stack.getTag().get("mguMobName")).getAsString() + " 'DNA'."));
        }
    }

    @Nonnull
    public InteractionResult interactLivingEntity(@Nonnull ItemStack stack, @Nonnull Player player, @Nonnull LivingEntity target, @Nonnull InteractionHand hand) {
        if (!(target instanceof Player || this.used || target.getType().is(ModTags.Entities.NO_SWAB))) {
            String mobName = Objects.requireNonNull(BuiltInRegistries.ENTITY_TYPE.getKey((Object)target.getType())).toString();
            ItemStack stack2 = new ItemStack((ItemLike)ModItems.MOB_SWAB_USED.get(), 1);
            if (!stack2.getOrCreateTag().contains("mguMobName")) {
                stack2.getTag().putString("mguMobName", mobName);
            }
            player.setItemInHand(hand, stack2);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public InteractionResult useOn(UseOnContext pContext) {
        SpawnerBlockEntity spawnerBlockEntity;
        Entity entity;
        BlockEntity blockEntity;
        BlockPos blockPos;
        if (this.used || pContext.getPlayer() == null) {
            return InteractionResult.PASS;
        }
        Level level = pContext.getLevel();
        BlockState block = level.getBlockState(blockPos = pContext.getClickedPos());
        if (block.getBlock() instanceof SpawnerBlock && (blockEntity = level.getBlockEntity(blockPos)) instanceof SpawnerBlockEntity && (entity = (spawnerBlockEntity = (SpawnerBlockEntity)blockEntity).getSpawner().getOrCreateDisplayEntity(level, blockPos)) != null && !entity.getType().is(ModTags.Entities.NO_SWAB)) {
            String mobName = Objects.requireNonNull(BuiltInRegistries.ENTITY_TYPE.getKey((Object)entity.getType())).toString();
            ItemStack stack2 = new ItemStack((ItemLike)ModItems.MOB_SWAB_USED.get(), 1);
            if (!stack2.getOrCreateTag().contains("mguMobName")) {
                stack2.getTag().putString("mguMobName", mobName);
            }
            pContext.getPlayer().setItemInHand(pContext.getHand(), stack2);
            return InteractionResult.SUCCESS;
        }
        return super.useOn(pContext);
    }
}

