/*
 * Decompiled with CFR 0.152.
 */
package mob_grinding_utils.items;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mob_grinding_utils.tile.TileEntitySinkTank;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class ItemSolidXP
extends Item {
    public int xpValue;

    public ItemSolidXP(Item.Properties properties, int value) {
        super(properties);
        this.xpValue = value;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, @Nullable Level world, List<Component> list, @Nonnull TooltipFlag flag) {
        list.add((Component)Component.translatable((String)"tooltip.solid_xp").append(Integer.toString(this.xpValue)).withStyle(ChatFormatting.YELLOW));
        if (stack.getCount() > 1) {
            list.add((Component)Component.translatable((String)"tooltip.solid_xp2").append(Integer.toString(this.xpValue * stack.getCount())).withStyle(ChatFormatting.YELLOW));
        }
    }

    @Nonnull
    public ItemStack finishUsingItem(@Nonnull ItemStack stack, @Nonnull Level world, @Nonnull LivingEntity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (this.xpValue > 0 && !world.isClientSide) {
                if (stack.getCount() > 1 && entity.isShiftKeyDown()) {
                    TileEntitySinkTank.addPlayerXP(player, this.xpValue * stack.getCount());
                    stack.shrink(stack.getCount() - 1);
                } else {
                    TileEntitySinkTank.addPlayerXP(player, this.xpValue);
                }
                world.playSound(null, player.blockPosition(), SoundEvents.EXPERIENCE_ORB_PICKUP, SoundSource.PLAYERS, 0.5f, 0.8f + world.random.nextFloat() * 0.4f);
            }
        }
        return super.finishUsingItem(stack, world, entity);
    }
}

