/*
 * Decompiled with CFR 0.152.
 */
package mob_grinding_utils.recipe;

import com.google.gson.JsonParseException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import javax.annotation.Nonnull;
import mob_grinding_utils.MobGrindingUtils;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public class BeheadingRecipe
implements Recipe<Container> {
    public static final String NAME = "beheading";
    private final EntityType<?> entityType;
    private final ItemStack result;

    public BeheadingRecipe(EntityType<?> type, ItemStack output) {
        this.entityType = type;
        this.result = output;
    }

    public boolean matches(@Nonnull Container container, @Nonnull Level level) {
        return false;
    }

    public boolean matches(EntityType<?> typeIn) {
        return typeIn == this.entityType;
    }

    @Nonnull
    public ItemStack assemble(@Nonnull Container container, RegistryAccess pointless) {
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int p_43999_, int p_44000_) {
        return false;
    }

    @Nonnull
    public ItemStack getResultItem(RegistryAccess pointless) {
        return this.result.copy();
    }

    @Nonnull
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)MobGrindingUtils.BEHEADING_RECIPE.get();
    }

    @Nonnull
    public RecipeType<?> getType() {
        return (RecipeType)MobGrindingUtils.BEHEADING_TYPE.get();
    }

    public static class Serializer
    implements RecipeSerializer<BeheadingRecipe> {
        public static final Codec<BeheadingRecipe> CODEC = RecordCodecBuilder.create(p_300958_ -> p_300958_.group((App)BuiltInRegistries.ENTITY_TYPE.byNameCodec().fieldOf("entity").forGetter(p_300960_ -> p_300960_.entityType), (App)ItemStack.CODEC.fieldOf("result").forGetter(p_300962_ -> p_300962_.result)).apply((Applicative)p_300958_, BeheadingRecipe::new));

        @Nonnull
        public BeheadingRecipe fromNetwork(FriendlyByteBuf buf) {
            ResourceLocation entityRes = new ResourceLocation(buf.readUtf());
            Optional type = BuiltInRegistries.ENTITY_TYPE.getOptional(entityRes);
            if (type.isEmpty()) {
                throw new JsonParseException("unknown entity type");
            }
            ItemStack result = buf.readItem();
            return new BeheadingRecipe((EntityType)type.get(), result);
        }

        public Codec<BeheadingRecipe> codec() {
            return CODEC;
        }

        public void toNetwork(FriendlyByteBuf buf, BeheadingRecipe recipe) {
            buf.writeUtf(BuiltInRegistries.ENTITY_TYPE.getKey(recipe.entityType).toString());
            buf.writeItem(recipe.result);
        }
    }
}

