/*
 * Decompiled with CFR 0.152.
 */
package mob_grinding_utils.recipe;

import com.mojang.serialization.Codec;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mob_grinding_utils.MobGrindingUtils;
import mob_grinding_utils.ModItems;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapelessRecipe;

public class ChickenFeedRecipe
extends ShapelessRecipe {
    public static final String NAME = "chicken_feed";

    public ChickenFeedRecipe(ShapelessRecipe recipe) {
        super(recipe.getGroup(), recipe.category(), recipe.getResultItem((RegistryAccess)RegistryAccess.EMPTY), recipe.getIngredients());
    }

    @Nonnull
    public ItemStack assemble(@Nonnull CraftingContainer inv, RegistryAccess lol) {
        ItemStack result = super.assemble(inv, lol);
        ItemStack swabItem = ItemStack.EMPTY;
        for (int i = 0; i < inv.getContainerSize(); ++i) {
            ItemStack stack = inv.getItem(i);
            if (stack.isEmpty() || stack.getItem() != ModItems.MOB_SWAB_USED.get()) continue;
            swabItem = stack;
        }
        if (!swabItem.hasTag() || !swabItem.getTag().contains("mguMobName")) {
            return ItemStack.EMPTY;
        }
        result.getOrCreateTag().putString("mguMobName", swabItem.getTag().getString("mguMobName"));
        return result;
    }

    @Nonnull
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)MobGrindingUtils.CHICKEN_FEED.get();
    }

    public static class Serializer
    implements RecipeSerializer<ChickenFeedRecipe> {
        public static final Codec<ChickenFeedRecipe> CODEC = ShapelessRecipe.Serializer.CODEC.xmap(ChickenFeedRecipe::new, recipe -> recipe);

        @Nonnull
        public Codec<ChickenFeedRecipe> codec() {
            return CODEC;
        }

        @Nullable
        public ChickenFeedRecipe fromNetwork(@Nonnull FriendlyByteBuf buffer) {
            return new ChickenFeedRecipe((ShapelessRecipe)RecipeSerializer.SHAPELESS_RECIPE.fromNetwork(buffer));
        }

        public void toNetwork(@Nonnull FriendlyByteBuf buffer, @Nonnull ChickenFeedRecipe recipe) {
            try {
                RecipeSerializer.SHAPELESS_RECIPE.toNetwork(buffer, (Recipe)recipe);
            }
            catch (Exception exception) {
                MobGrindingUtils.LOGGER.info("Error writing chicken_feed Recipe to packet: ", (Throwable)exception);
                throw exception;
            }
        }
    }
}

