/*
 * Decompiled with CFR 0.152.
 */
package mob_grinding_utils.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import javax.annotation.Nonnull;
import mob_grinding_utils.MobGrindingUtils;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public record SolidifyRecipe(Ingredient mould, ItemStack result, int fluidAmount) implements Recipe<Container>
{
    private final ItemStack result;
    public static final String NAME = "solidify";

    public boolean matches(Container inv, Level worldIn) {
        return false;
    }

    public boolean matches(ItemStack input) {
        return this.mould.test(input);
    }

    @Nonnull
    public ItemStack assemble(Container inv, RegistryAccess pointless) {
        return this.result.copy();
    }

    public ItemStack result() {
        return this.result.copy();
    }

    public boolean canCraftInDimensions(int width, int height) {
        return false;
    }

    @Nonnull
    public ItemStack getResultItem(RegistryAccess pointless) {
        return this.result;
    }

    @Nonnull
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)MobGrindingUtils.SOLIDIFIER_RECIPE.get();
    }

    @Nonnull
    public RecipeType<?> getType() {
        return (RecipeType)MobGrindingUtils.SOLIDIFIER_TYPE.get();
    }

    public static class Serializer
    implements RecipeSerializer<SolidifyRecipe> {
        public static final Codec<SolidifyRecipe> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Ingredient.CODEC.fieldOf("ingredient").forGetter(recipe -> recipe.mould), (App)ItemStack.CODEC.fieldOf("result").forGetter(recipe -> recipe.result), (App)Codec.INT.fieldOf("fluidAmount").forGetter(recipe -> recipe.fluidAmount)).apply((Applicative)instance, SolidifyRecipe::new));

        @Nonnull
        public Codec<SolidifyRecipe> codec() {
            return CODEC;
        }

        @Nonnull
        public SolidifyRecipe fromNetwork(@Nonnull FriendlyByteBuf buffer) {
            Ingredient mould = Ingredient.fromNetwork((FriendlyByteBuf)buffer);
            ItemStack result = buffer.readItem();
            int fluidAmount = buffer.readInt();
            return new SolidifyRecipe(mould, result, fluidAmount);
        }

        public void toNetwork(@Nonnull FriendlyByteBuf buffer, SolidifyRecipe recipe) {
            recipe.mould.toNetwork(buffer);
            buffer.writeItem(recipe.result);
            buffer.writeInt(recipe.fluidAmount);
        }
    }
}

