/*
 * Decompiled with CFR 0.152.
 */
package mob_grinding_utils.tile;

import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Collections;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mob_grinding_utils.ModBlocks;
import mob_grinding_utils.ModItems;
import mob_grinding_utils.ModTags;
import mob_grinding_utils.inventory.server.ContainerMGUSpawner;
import mob_grinding_utils.tile.BEGuiClickable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.util.Mth;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;

public class TileEntityMGUSpawner
extends BlockEntity
implements MenuProvider,
BEGuiClickable {
    public int spawning_progress = 0;
    public int MAX_SPAWNING_TIME = 100;
    public boolean isOn = false;
    public ItemStackHandler inputSlots = new ItemStackHandler(4);
    public ItemStackHandler fuelSlot = new ItemStackHandler(1){

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return stack.getItem() == ModItems.SOLID_XP_BABY.get();
        }
    };
    public int animationTicks;
    public int prevAnimationTicks;
    public boolean showRenderBox;
    public int offsetX;
    public int offsetY;
    public int offsetZ;

    public TileEntityMGUSpawner(BlockPos pos, BlockState state) {
        super(ModBlocks.ENTITY_SPAWNER.getTileEntityType(), pos, state);
    }

    public IItemHandler getFuelSlot(@Nullable Direction side) {
        return this.fuelSlot;
    }

    public void toggleOnOff() {
        this.isOn = !this.isOn;
    }

    public static <T extends BlockEntity> void serverTick(Level level, BlockPos blockPos, BlockState blockState, T t) {
        if (t instanceof TileEntityMGUSpawner) {
            TileEntityMGUSpawner tile = (TileEntityMGUSpawner)t;
            if (tile.isOn) {
                if (tile.canOperate()) {
                    tile.setProgress(tile.getProgress() + 1 + tile.getSpeedModifierAmount());
                    if (tile.getProgress() >= tile.MAX_SPAWNING_TIME) {
                        if (tile.spawnMobInArea()) {
                            tile.fuelSlot.getStackInSlot(0).shrink(1);
                        }
                        tile.setProgress(0);
                    }
                } else if (tile.getProgress() > 0) {
                    tile.setProgress(0);
                }
            } else if (tile.getProgress() > 0) {
                tile.setProgress(0);
            }
        }
    }

    public static <T extends BlockEntity> void clientTick(Level level, BlockPos blockPos, BlockState blockState, T t) {
        if (t instanceof TileEntityMGUSpawner) {
            TileEntityMGUSpawner tile = (TileEntityMGUSpawner)t;
            if (tile.isOn) {
                tile.prevAnimationTicks = tile.animationTicks;
                if (tile.animationTicks < 360) {
                    tile.animationTicks += 9;
                }
                if (tile.animationTicks >= 360) {
                    tile.animationTicks -= 360;
                    tile.prevAnimationTicks -= 360;
                }
            } else {
                tile.animationTicks = 0;
                tile.prevAnimationTicks = 0;
            }
        }
    }

    private boolean spawnMobInArea() {
        EntityType type = null;
        ItemStack eggStack = this.inputSlots.getStackInSlot(0);
        SpawnEggItem eggItem = (SpawnEggItem)eggStack.getItem();
        type = eggItem.getType(null);
        if (type != null && !type.is(ModTags.Entities.NO_SPAWN)) {
            AABB axisalignedbb = this.getAABBWithModifiers();
            int minX = Mth.floor((double)axisalignedbb.minX);
            int maxX = Mth.floor((double)axisalignedbb.maxX);
            int minY = Mth.floor((double)axisalignedbb.minY);
            int maxY = Mth.floor((double)axisalignedbb.maxY);
            int minZ = Mth.floor((double)axisalignedbb.minZ);
            int maxZ = Mth.floor((double)axisalignedbb.maxZ);
            BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
            Mob entity = (Mob)type.create(this.getLevel());
            ArrayList<BlockPos> posArrayList = new ArrayList<BlockPos>();
            if (entity != null) {
                for (int x = minX; x < maxX; ++x) {
                    for (int y = minY; y < maxY; ++y) {
                        for (int z = minZ; z < maxZ; ++z) {
                            mutablePos.set(x, y, z);
                            entity.setPos((double)mutablePos.getX() + 0.5, (double)mutablePos.getY(), (double)mutablePos.getZ() + 0.5);
                            if (!this.isValidSpawnLocation(this.getLevel(), type, (Entity)entity, (BlockPos)mutablePos)) continue;
                            posArrayList.add(new BlockPos((Vec3i)mutablePos));
                        }
                    }
                }
                if (!posArrayList.isEmpty()) {
                    Collections.shuffle(posArrayList);
                    entity.setPos((double)((BlockPos)posArrayList.get(0)).getX() + 0.5, (double)((BlockPos)posArrayList.get(0)).getY(), (double)((BlockPos)posArrayList.get(0)).getZ() + 0.5);
                    entity.finalizeSpawn((ServerLevelAccessor)this.getLevel(), this.getLevel().getCurrentDifficultyAt((BlockPos)posArrayList.get(0)), MobSpawnType.SPAWNER, null, null);
                    this.getLevel().addFreshEntity((Entity)entity);
                    return true;
                }
            }
        }
        return false;
    }

    public boolean isValidSpawnLocation(Level world, EntityType<?> type, Entity entity, BlockPos pos) {
        return NaturalSpawner.isSpawnPositionOk((SpawnPlacements.Type)SpawnPlacements.getPlacementType(type), (LevelReader)world, (BlockPos)pos, type) && world.getEntities((EntityTypeTest)entity.getType(), entity.getBoundingBox(), EntitySelector.ENTITY_STILL_ALIVE).isEmpty() && this.getLevel().noCollision(entity);
    }

    public void toggleRenderBox() {
        this.showRenderBox = !this.showRenderBox;
        this.setChanged();
    }

    public void toggleOffset(int direction) {
        switch (direction) {
            case 1: {
                if (this.getoffsetY() < -1 - this.getHeightModifierAmount()) break;
                this.offsetY = this.getoffsetY() - 1;
                break;
            }
            case 2: {
                if (this.getoffsetY() > 1 + this.getHeightModifierAmount()) break;
                this.offsetY = this.getoffsetY() + 1;
                break;
            }
            case 3: {
                if (this.getoffsetZ() < -1 - this.getWidthModifierAmount()) break;
                this.offsetZ = this.getoffsetZ() - 1;
                break;
            }
            case 4: {
                if (this.getoffsetZ() > 1 + this.getWidthModifierAmount()) break;
                this.offsetZ = this.getoffsetZ() + 1;
                break;
            }
            case 5: {
                if (this.getoffsetX() < -1 - this.getWidthModifierAmount()) break;
                this.offsetX = this.getoffsetX() - 1;
                break;
            }
            case 6: {
                if (this.getoffsetX() > 1 + this.getWidthModifierAmount()) break;
                this.offsetX = this.getoffsetX() + 1;
            }
        }
        this.setChanged();
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getProgressScaled(int count) {
        return this.getProgress() * count / this.MAX_SPAWNING_TIME;
    }

    private boolean canOperate() {
        return this.hasSpawnEggItem() && this.hasFuel();
    }

    public boolean hasSpawnEggItem() {
        return !this.inputSlots.getStackInSlot(0).isEmpty() && this.inputSlots.getStackInSlot(0).getItem() instanceof SpawnEggItem;
    }

    private boolean hasFuel() {
        return !this.fuelSlot.getStackInSlot(0).isEmpty() && this.fuelSlot.getStackInSlot(0).getItem() == ModItems.SOLID_XP_BABY.get();
    }

    private boolean hasWidthUpgrade() {
        return !this.inputSlots.getStackInSlot(1).isEmpty() && this.inputSlots.getStackInSlot(1).getItem() == ModItems.SPAWNER_UPGRADE_WIDTH.get();
    }

    public int getWidthModifierAmount() {
        return this.hasWidthUpgrade() ? this.inputSlots.getStackInSlot(1).getCount() : 0;
    }

    private boolean hasHeightUpgrade() {
        return !this.inputSlots.getStackInSlot(2).isEmpty() && this.inputSlots.getStackInSlot(2).getItem() == ModItems.SPAWNER_UPGRADE_HEIGHT.get();
    }

    public int getHeightModifierAmount() {
        return this.hasHeightUpgrade() ? this.inputSlots.getStackInSlot(2).getCount() : 0;
    }

    private boolean hasSpeedUpgrade() {
        return !this.inputSlots.getStackInSlot(3).isEmpty() && this.inputSlots.getStackInSlot(3).getItem() == ModItems.XP_SOLIDIFIER_UPGRADE.get();
    }

    public int getSpeedModifierAmount() {
        return this.hasSpeedUpgrade() ? this.inputSlots.getStackInSlot(3).getCount() : 0;
    }

    public AABB getAABBWithModifiers() {
        double x = (double)this.getBlockPos().getX() + 0.5;
        double y = (double)this.getBlockPos().getY() + 0.5;
        double z = (double)this.getBlockPos().getZ() + 0.5;
        return new AABB(x - 1.5 - (double)this.getWidthModifierAmount(), y - 0.5 - (double)this.getHeightModifierAmount(), z - 1.5 - (double)this.getWidthModifierAmount(), x + 1.5 + (double)this.getWidthModifierAmount(), y + 0.5 + (double)this.getHeightModifierAmount(), z + 1.5 + (double)this.getWidthModifierAmount()).move((double)this.getoffsetX(), (double)this.getoffsetY(), (double)this.getoffsetZ());
    }

    @OnlyIn(value=Dist.CLIENT)
    public AABB getAABBForRender() {
        return new AABB(-1.0 - (double)this.getWidthModifierAmount(), -0.0 - (double)this.getHeightModifierAmount(), -1.0 - (double)this.getWidthModifierAmount(), 2.0 + (double)this.getWidthModifierAmount(), 1.0 + (double)this.getHeightModifierAmount(), 2.0 + (double)this.getWidthModifierAmount()).move((double)this.getoffsetX(), (double)this.getoffsetY(), (double)this.getoffsetZ());
    }

    public int getoffsetX() {
        return Math.max(-2 - this.getWidthModifierAmount(), Math.min(this.offsetX, 2 + this.getWidthModifierAmount()));
    }

    public int getoffsetY() {
        return Math.max(-1 - this.getHeightModifierAmount(), Math.min(this.offsetY, 1 + this.getHeightModifierAmount()));
    }

    public int getoffsetZ() {
        return Math.max(-2 - this.getWidthModifierAmount(), Math.min(this.offsetZ, 2 + this.getWidthModifierAmount()));
    }

    private void setProgress(int counter) {
        this.spawning_progress = counter;
        this.updateBlock();
    }

    public int getProgress() {
        return this.spawning_progress;
    }

    public void load(CompoundTag nbt) {
        super.load(nbt);
        this.inputSlots.deserializeNBT(nbt.getCompound("inputSlots"));
        this.fuelSlot.deserializeNBT(nbt.getCompound("fuelSlot"));
        this.isOn = nbt.getBoolean("isOn");
        this.showRenderBox = nbt.getBoolean("showRenderBox");
        this.offsetX = nbt.getInt("offsetX");
        this.offsetY = nbt.getInt("offsetY");
        this.offsetZ = nbt.getInt("offsetZ");
        this.spawning_progress = nbt.getInt("spawning_progress");
    }

    public void saveAdditional(CompoundTag nbt) {
        super.saveAdditional(nbt);
        nbt.put("inputSlots", (Tag)this.inputSlots.serializeNBT());
        nbt.put("fuelSlot", (Tag)this.fuelSlot.serializeNBT());
        nbt.putBoolean("isOn", this.isOn);
        nbt.putBoolean("showRenderBox", this.showRenderBox);
        nbt.putInt("offsetX", this.offsetX);
        nbt.putInt("offsetY", this.offsetY);
        nbt.putInt("offsetZ", this.offsetZ);
        nbt.putInt("spawning_progress", this.spawning_progress);
    }

    public CompoundTag getUpdateTag() {
        CompoundTag nbt = new CompoundTag();
        this.saveAdditional(nbt);
        return nbt;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        CompoundTag nbt = new CompoundTag();
        this.saveAdditional(nbt);
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket packet) {
        super.onDataPacket(net, packet);
        this.load(packet.getTag());
    }

    public void updateBlock() {
        this.getLevel().sendBlockUpdated(this.worldPosition, this.getLevel().getBlockState(this.worldPosition), this.getLevel().getBlockState(this.worldPosition), 3);
    }

    public Component getDisplayName() {
        return Component.translatable((String)"block.mob_grinding_utils.entity_spawner");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int windowID, Inventory playerInventory, Player player) {
        return new ContainerMGUSpawner(windowID, playerInventory, new FriendlyByteBuf(Unpooled.buffer()).writeBlockPos(this.worldPosition));
    }

    @OnlyIn(value=Dist.CLIENT)
    public Entity getEntityToRender() {
        Entity entity = null;
        if (this.hasSpawnEggItem()) {
            ItemStack eggStack = this.inputSlots.getStackInSlot(0);
            SpawnEggItem eggItem = (SpawnEggItem)eggStack.getItem();
            entity = eggItem.getType(null).create(this.getLevel());
        }
        return entity;
    }

    @Override
    public void buttonClicked(int buttonID) {
        switch (buttonID) {
            case 0: {
                this.toggleRenderBox();
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                this.toggleOffset(buttonID);
            }
        }
        this.updateBlock();
    }
}

