/*
 * Decompiled with CFR 0.152.
 */
package mob_grinding_utils.tile;

import javax.annotation.Nullable;
import mob_grinding_utils.ModBlocks;
import mob_grinding_utils.tile.TileEntityJumboTank;
import mob_grinding_utils.tile.TileEntitySinkTank;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;

public class TileEntityTank
extends BlockEntity {
    public FluidTank tank = new FluidTank(32000);
    public int prevTankAmount;

    public TileEntityTank(BlockPos pos, BlockState state) {
        super(ModBlocks.TANK.getTileEntityType(), pos, state);
    }

    public TileEntityTank(BlockEntityType<TileEntitySinkTank> TANK_SINK_TILE, BlockPos pos, BlockState state) {
        super(TANK_SINK_TILE, pos, state);
    }

    public TileEntityTank(BlockEntityType<TileEntityJumboTank> JUMBO_TANK_TILE, FluidTank tankIn, BlockPos pos, BlockState state) {
        super(JUMBO_TANK_TILE, pos, state);
        this.tank = tankIn;
    }

    public static <T extends BlockEntity> void serverTick(Level world, BlockPos worldPosition, BlockState blockState, T t) {
        if (t instanceof TileEntityTank) {
            TileEntityTank tile = (TileEntityTank)t;
            if (tile.prevTankAmount != tile.tank.getFluidAmount()) {
                tile.updateBlock();
                tile.setChanged();
            }
            tile.prevTankAmount = tile.tank.getFluidAmount();
        }
    }

    public void updateBlock() {
        this.getLevel().sendBlockUpdated(this.worldPosition, this.getLevel().getBlockState(this.worldPosition), this.getLevel().getBlockState(this.worldPosition), 3);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket packet) {
        super.onDataPacket(net, packet);
        this.load(packet.getTag());
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        CompoundTag nbt = new CompoundTag();
        this.saveAdditional(nbt);
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag() {
        CompoundTag nbt = new CompoundTag();
        this.saveAdditional(nbt);
        return nbt;
    }

    public void load(CompoundTag nbt) {
        super.load(nbt);
        this.tank.readFromNBT(nbt);
    }

    public void saveAdditional(CompoundTag nbt) {
        super.saveAdditional(nbt);
        this.tank.writeToNBT(nbt);
    }

    public FluidTank getTank() {
        return this.tank;
    }

    public FluidTank getTank(@Nullable Direction direction) {
        return this.tank;
    }

    public int getScaledFluid(int scale) {
        return this.tank.getFluid() != null ? (int)((float)this.tank.getFluidAmount() / (float)this.tank.getCapacity() * (float)scale) : 0;
    }
}

