/*
 * Decompiled with CFR 0.152.
 */
package mob_grinding_utils.tile;

import java.util.Optional;
import mob_grinding_utils.ModBlocks;
import mob_grinding_utils.ModTags;
import mob_grinding_utils.blocks.BlockXPTap;
import mob_grinding_utils.entity.EntityXPOrbFalling;
import mob_grinding_utils.network.TapParticlePacket;
import mob_grinding_utils.util.CapHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.network.PacketDistributor;

public class TileEntityXPTap
extends BlockEntity {
    public boolean active;

    public TileEntityXPTap(BlockPos pos, BlockState state) {
        super(ModBlocks.XP_TAP.getTileEntityType(), pos, state);
    }

    public static <T extends BlockEntity> void serverTick(Level world, BlockPos worldPosition, BlockState blockState, T t) {
        if (t instanceof TileEntityXPTap) {
            BlockPos blockPos;
            BlockEntity tileentity;
            TileEntityXPTap tileEntityXPTap = (TileEntityXPTap)t;
            if (tileEntityXPTap.active && (tileentity = world.getBlockEntity(blockPos = worldPosition.relative(((Direction)world.getBlockState(worldPosition).getValue((Property)BlockXPTap.FACING)).getOpposite()))) != null) {
                Optional<IFluidHandler> fluidHandler = CapHelper.getFluidHandler(world, blockPos, (Direction)world.getBlockState(worldPosition).getValue((Property)BlockXPTap.FACING));
                fluidHandler.ifPresent(handler -> {
                    int xpAmount;
                    if (handler.getTanks() > 0 && handler.getFluidInTank(0).getAmount() >= 20 && handler.getFluidInTank(0).getFluid().is(ModTags.Fluids.EXPERIENCE) && world.getGameTime() % 3L == 0L && !handler.drain((xpAmount = EntityXPOrbFalling.getExperienceValue((int)Math.min(20, handler.getFluidInTank(0).getAmount() / 20))) * 20, IFluidHandler.FluidAction.EXECUTE).isEmpty()) {
                        tileEntityXPTap.spawnXP(world, worldPosition, xpAmount, tileentity);
                        PacketDistributor.TargetPoint particleTarget = new PacketDistributor.TargetPoint((double)t.getBlockPos().getX(), (double)t.getBlockPos().getY(), (double)t.getBlockPos().getZ(), 30.0, t.getLevel().dimension());
                        PacketDistributor.NEAR.with((Object)particleTarget).send(new CustomPacketPayload[]{new TapParticlePacket(worldPosition)});
                    }
                });
            }
        }
    }

    public void spawnXP(Level world, BlockPos pos, int xp, BlockEntity tankTile) {
        tankTile.setChanged();
        EntityXPOrbFalling orb = new EntityXPOrbFalling(world, (double)pos.getX() + 0.5, (double)pos.getY() - 0.125, (double)pos.getZ() + 0.5, xp);
        world.addFreshEntity((Entity)orb);
    }

    public void setActive(boolean isActive) {
        this.active = isActive;
        this.getLevel().sendBlockUpdated(this.worldPosition, this.getLevel().getBlockState(this.worldPosition), this.getLevel().getBlockState(this.worldPosition), 3);
    }

    public void saveAdditional(CompoundTag nbt) {
        super.saveAdditional(nbt);
        nbt.putBoolean("active", this.active);
    }

    public void load(CompoundTag nbt) {
        super.load(nbt);
        this.active = nbt.getBoolean("active");
    }

    public CompoundTag getUpdateTag() {
        CompoundTag nbt = new CompoundTag();
        this.saveAdditional(nbt);
        return nbt;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        CompoundTag nbt = new CompoundTag();
        this.saveAdditional(nbt);
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket packet) {
        if (packet.getTag() != null) {
            this.load(packet.getTag());
        }
    }
}

