/*
 * Decompiled with CFR 0.152.
 */
package mob_grinding_utils;

import mob_grinding_utils.ModBlocks;
import mob_grinding_utils.ModContainers;
import mob_grinding_utils.blocks.BlockSpikes;
import mob_grinding_utils.client.render.TileEntityAbsorptionRenderer;
import mob_grinding_utils.client.render.TileEntityFanRenderer;
import mob_grinding_utils.client.render.TileEntitySawRenderer;
import mob_grinding_utils.client.render.TileEntityTankRenderer;
import mob_grinding_utils.datagen.Generator;
import mob_grinding_utils.events.BossBarHidingEvent;
import mob_grinding_utils.events.ChickenFuseEvent;
import mob_grinding_utils.events.ChickenInteractionEvent;
import mob_grinding_utils.events.EntityHeadDropEvent;
import mob_grinding_utils.events.FillXPBottleEvent;
import mob_grinding_utils.events.FluidTextureStitchEvent;
import mob_grinding_utils.events.GlobalDragonSoundEvent;
import mob_grinding_utils.events.GlobalWitherSoundEvent;
import mob_grinding_utils.events.LocalDragonSoundEvent;
import mob_grinding_utils.events.LocalWitherSoundEvent;
import mob_grinding_utils.events.MGUEndermanInhibitEvent;
import mob_grinding_utils.events.MGUZombieReinforcementEvent;
import mob_grinding_utils.events.RenderChickenSwell;
import mob_grinding_utils.inventory.client.GuiAbsorptionHopper;
import mob_grinding_utils.inventory.client.GuiFan;
import mob_grinding_utils.inventory.client.GuiSaw;
import mob_grinding_utils.network.MGUNetProxyClient;
import mob_grinding_utils.network.MGUNetProxyCommon;
import mob_grinding_utils.network.MGUNetwork;
import mob_grinding_utils.network.MessageFlagSync;
import mob_grinding_utils.recipe.RecipeChickenFeed;
import net.minecraft.block.Block;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.SpecialRecipeSerializer;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.particles.ParticleType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

@Mod(value="mob_grinding_utils")
public class MobGrindingUtils {
    public static SimpleChannel NETWORK_WRAPPER;
    public static DamageSource SPIKE_DAMAGE;
    public static final DeferredRegister<ContainerType<?>> CONTAINERS;
    public static final DeferredRegister<ParticleType<?>> PARTICLES;
    public static final DeferredRegister<IRecipeSerializer<?>> RECIPES;
    public static final RegistryObject<BasicParticleType> PARTICLE_FLUID_XP;
    public static final RegistryObject<IRecipeSerializer<RecipeChickenFeed>> RECIPE_CHICKEN_FEED;
    public static final ItemGroup TAB;
    public static MGUNetProxyCommon NETPROXY;

    public MobGrindingUtils() {
        ModContainers modContainers = new ModContainers();
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        CONTAINERS.register(modBus);
        PARTICLES.register(modBus);
        RECIPES.register(modBus);
        modBus.addListener(this::setup);
        modBus.addListener(this::doClientStuff);
        modBus.addListener(Generator::gatherData);
        NETPROXY = (MGUNetProxyCommon)DistExecutor.safeRunForDist(() -> MGUNetProxyClient::new, () -> MGUNetProxyCommon::new);
    }

    public void setup(FMLCommonSetupEvent event) {
        SPIKE_DAMAGE = new DamageSource("spikes").func_76348_h();
        NETWORK_WRAPPER = MGUNetwork.getNetworkChannel();
        MinecraftForge.EVENT_BUS.addListener(BlockSpikes::dropXP);
        MinecraftForge.EVENT_BUS.register((Object)new ChickenInteractionEvent());
        MinecraftForge.EVENT_BUS.register((Object)new ChickenFuseEvent());
        MinecraftForge.EVENT_BUS.register((Object)new LocalWitherSoundEvent());
        MinecraftForge.EVENT_BUS.register((Object)new LocalDragonSoundEvent());
        MinecraftForge.EVENT_BUS.register((Object)new EntityHeadDropEvent());
        MinecraftForge.EVENT_BUS.register((Object)new MGUZombieReinforcementEvent());
        MinecraftForge.EVENT_BUS.register((Object)new FillXPBottleEvent());
        MinecraftForge.EVENT_BUS.register((Object)new MGUEndermanInhibitEvent());
        MinecraftForge.EVENT_BUS.addListener(this::playerConnected);
    }

    private void doClientStuff(FMLClientSetupEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new FluidTextureStitchEvent());
        MinecraftForge.EVENT_BUS.register((Object)new RenderChickenSwell());
        MinecraftForge.EVENT_BUS.register((Object)new GlobalWitherSoundEvent());
        MinecraftForge.EVENT_BUS.register((Object)new GlobalDragonSoundEvent());
        MinecraftForge.EVENT_BUS.register((Object)new BossBarHidingEvent());
        ClientRegistry.bindTileEntityRenderer(ModBlocks.FAN_TILE, TileEntityFanRenderer::new);
        ClientRegistry.bindTileEntityRenderer(ModBlocks.SAW_TILE, TileEntitySawRenderer::new);
        ClientRegistry.bindTileEntityRenderer(ModBlocks.ABSORPTION_HOPPER_TILE, TileEntityAbsorptionRenderer::new);
        ClientRegistry.bindTileEntityRenderer(ModBlocks.TANK_TILE, TileEntityTankRenderer::new);
        ClientRegistry.bindTileEntityRenderer(ModBlocks.TANK_SINK_TILE, TileEntityTankRenderer::new);
        ScreenManager.func_216911_a((ContainerType)((ContainerType)ModContainers.ABSORPTION_HOPPER.get()), GuiAbsorptionHopper::new);
        ScreenManager.func_216911_a((ContainerType)((ContainerType)ModContainers.FAN.get()), GuiFan::new);
        ScreenManager.func_216911_a((ContainerType)((ContainerType)ModContainers.SAW.get()), GuiSaw::new);
        RenderTypeLookup.setRenderLayer((Block)ModBlocks.TANK, (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)ModBlocks.TANK_SINK, (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)ModBlocks.XP_TAP, (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)ModBlocks.ENDER_INHIBITOR_ON, (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)ModBlocks.ENDER_INHIBITOR_OFF, (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)ModBlocks.SAW, (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)ModBlocks.SPIKES, (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)ModBlocks.ABSORPTION_HOPPER, (RenderType)RenderType.func_228643_e_());
    }

    private void playerConnected(PlayerEvent.PlayerLoggedInEvent event) {
        ServerPlayerEntity player;
        CompoundNBT nbt;
        if (event.getPlayer() instanceof ServerPlayerEntity && ((nbt = (player = (ServerPlayerEntity)event.getPlayer()).getPersistentData()).func_74764_b("MGU_WitherMuffle") || nbt.func_74764_b("MGU_DragonMuffle"))) {
            NETWORK_WRAPPER.send(PacketDistributor.PLAYER.with(() -> player), (Object)new MessageFlagSync(nbt.func_74767_n("MGU_WitherMuffle"), nbt.func_74767_n("MGU_DragonMuffle")));
        }
    }

    static {
        CONTAINERS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.CONTAINERS, (String)"mob_grinding_utils");
        PARTICLES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.PARTICLE_TYPES, (String)"mob_grinding_utils");
        RECIPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.RECIPE_SERIALIZERS, (String)"mob_grinding_utils");
        PARTICLE_FLUID_XP = PARTICLES.register("fluid_xp_particles", () -> new BasicParticleType(true));
        RECIPE_CHICKEN_FEED = RECIPES.register("chicken_feed_recipe", () -> new SpecialRecipeSerializer(RecipeChickenFeed::new));
        TAB = new ItemGroup("mob_grinding_utils"){

            public ItemStack func_78016_d() {
                return new ItemStack((IItemProvider)ModBlocks.SPIKES_ITEM);
            }
        };
    }
}

