/*
 * Decompiled with CFR 0.152.
 */
package mob_grinding_utils;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import mob_grinding_utils.MobGrindingUtils;
import mob_grinding_utils.ModItems;
import mob_grinding_utils.blocks.BlockAbsorptionHopper;
import mob_grinding_utils.blocks.BlockDarkOakStone;
import mob_grinding_utils.blocks.BlockDragonMuffler;
import mob_grinding_utils.blocks.BlockEnderInhibitorOff;
import mob_grinding_utils.blocks.BlockEnderInhibitorOn;
import mob_grinding_utils.blocks.BlockEntityConveyor;
import mob_grinding_utils.blocks.BlockFan;
import mob_grinding_utils.blocks.BlockSaw;
import mob_grinding_utils.blocks.BlockSpikes;
import mob_grinding_utils.blocks.BlockTank;
import mob_grinding_utils.blocks.BlockTankSink;
import mob_grinding_utils.blocks.BlockWitherMuffler;
import mob_grinding_utils.blocks.BlockXPTap;
import mob_grinding_utils.client.render.TileSawStackItemRenderer;
import mob_grinding_utils.tile.TileEntityAbsorptionHopper;
import mob_grinding_utils.tile.TileEntityFan;
import mob_grinding_utils.tile.TileEntitySaw;
import mob_grinding_utils.tile.TileEntitySinkTank;
import mob_grinding_utils.tile.TileEntityTank;
import mob_grinding_utils.tile.TileEntityXPTap;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ModBlocks {
    public static List<Block> BLOCKS = new LinkedList<Block>();
    public static List<BlockItem> ITEM_BLOCKS = new ArrayList<BlockItem>();
    public static List<TileEntityType<?>> TILE_ENTITIES = new LinkedList();
    public static Block FAN;
    public static BlockItem FAN_ITEM;
    public static TileEntityType<TileEntityFan> FAN_TILE;
    public static Block SAW;
    public static BlockItem SAW_ITEM;
    public static TileEntityType<TileEntitySaw> SAW_TILE;
    public static Block ABSORPTION_HOPPER;
    public static BlockItem ABSORPTION_HOPPER_ITEM;
    public static TileEntityType<TileEntityAbsorptionHopper> ABSORPTION_HOPPER_TILE;
    public static Block SPIKES;
    public static BlockItem SPIKES_ITEM;
    public static Block TANK;
    public static BlockItem TANK_ITEM;
    public static TileEntityType<TileEntityTank> TANK_TILE;
    public static Block TANK_SINK;
    public static BlockItem TANK_SINK_ITEM;
    public static TileEntityType<TileEntitySinkTank> TANK_SINK_TILE;
    public static Block XP_TAP;
    public static BlockItem XP_TAP_ITEM;
    public static TileEntityType<TileEntityXPTap> XP_TAP_TILE;
    public static Block WITHER_MUFFLER;
    public static BlockItem WITHER_MUFFLER_ITEM;
    public static Block DRAGON_MUFFLER;
    public static BlockItem DRAGON_MUFFLER_ITEM;
    public static Block DARK_OAK_STONE;
    public static BlockItem DARK_OAK_STONE_ITEM;
    public static Block ENTITY_CONVEYOR;
    public static BlockItem ENTITY_CONVEYOR_ITEM;
    public static Block ENDER_INHIBITOR_ON;
    public static BlockItem ENDER_INHIBITOR_ON_ITEM;
    public static Block ENDER_INHIBITOR_OFF;
    public static BlockItem ENDER_INHIBITOR_OFF_ITEM;
    public static Fluid FLUID_XP;

    public static void init() {
        FAN = new BlockFan(AbstractBlock.Properties.func_200949_a((Material)Material.field_151573_f, (MaterialColor)MaterialColor.field_151665_m).func_200948_a(10.0f, 2000.0f).func_200947_a(SoundType.field_185852_e));
        FAN_ITEM = new BlockItem(FAN, new Item.Properties().func_200916_a(MobGrindingUtils.TAB)){

            @OnlyIn(value=Dist.CLIENT)
            public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> list, ITooltipFlag flag) {
                list.add((ITextComponent)new TranslationTextComponent("tooltip.fan_1").func_240699_a_(TextFormatting.YELLOW));
                list.add((ITextComponent)new TranslationTextComponent("tooltip.fan_2").func_240699_a_(TextFormatting.YELLOW));
                list.add((ITextComponent)new TranslationTextComponent("tooltip.fan_3").func_240699_a_(TextFormatting.YELLOW));
            }
        };
        FAN_TILE = TileEntityType.Builder.func_223042_a(TileEntityFan::new, (Block[])new Block[]{FAN}).func_206865_a(null);
        SAW = new BlockSaw(AbstractBlock.Properties.func_200949_a((Material)Material.field_151573_f, (MaterialColor)MaterialColor.field_151665_m).func_200948_a(10.0f, 2000.0f).func_200947_a(SoundType.field_185852_e).func_226896_b_());
        SAW_ITEM = new BlockItem(SAW, new Item.Properties().func_200916_a(MobGrindingUtils.TAB).setISTER(() -> TileSawStackItemRenderer::new)){

            @OnlyIn(value=Dist.CLIENT)
            public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> list, ITooltipFlag flag) {
                list.add((ITextComponent)new TranslationTextComponent("tooltip.saw_1").func_240699_a_(TextFormatting.YELLOW));
                list.add((ITextComponent)new TranslationTextComponent("tooltip.saw_2").func_240699_a_(TextFormatting.YELLOW));
                list.add((ITextComponent)new TranslationTextComponent("tooltip.saw_3").func_240699_a_(TextFormatting.YELLOW));
            }
        };
        SAW_TILE = TileEntityType.Builder.func_223042_a(TileEntitySaw::new, (Block[])new Block[]{SAW}).func_206865_a(null);
        ABSORPTION_HOPPER = new BlockAbsorptionHopper(AbstractBlock.Properties.func_200949_a((Material)Material.field_151573_f, (MaterialColor)MaterialColor.field_151665_m).func_200948_a(10.0f, 2000.0f).func_200947_a(SoundType.field_185852_e).harvestLevel(0).harvestTool(ToolType.PICKAXE).func_226896_b_());
        ABSORPTION_HOPPER_ITEM = new BlockItem(ABSORPTION_HOPPER, new Item.Properties().func_200916_a(MobGrindingUtils.TAB)){

            @OnlyIn(value=Dist.CLIENT)
            public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> list, ITooltipFlag flag) {
                list.add((ITextComponent)new TranslationTextComponent("tooltip.hopper_1").func_240699_a_(TextFormatting.YELLOW));
                list.add((ITextComponent)new TranslationTextComponent("tooltip.hopper_2").func_240699_a_(TextFormatting.YELLOW));
                list.add((ITextComponent)new TranslationTextComponent("tooltip.hopper_3").func_240699_a_(TextFormatting.YELLOW));
                list.add((ITextComponent)new TranslationTextComponent("tooltip.hopper_4").func_240699_a_(TextFormatting.YELLOW));
                list.add((ITextComponent)new TranslationTextComponent("tooltip.hopper_5").func_240699_a_(TextFormatting.YELLOW));
                list.add((ITextComponent)new TranslationTextComponent("tooltip.hopper_6").func_240699_a_(TextFormatting.YELLOW));
            }
        };
        ABSORPTION_HOPPER_TILE = TileEntityType.Builder.func_223042_a(TileEntityAbsorptionHopper::new, (Block[])new Block[]{ABSORPTION_HOPPER}).func_206865_a(null);
        SPIKES = new BlockSpikes(AbstractBlock.Properties.func_200949_a((Material)Material.field_151573_f, (MaterialColor)MaterialColor.field_151665_m).func_200948_a(5.0f, 2000.0f).func_200947_a(SoundType.field_185852_e).func_226896_b_());
        SPIKES_ITEM = new BlockItem(SPIKES, new Item.Properties().func_200916_a(MobGrindingUtils.TAB)){

            @OnlyIn(value=Dist.CLIENT)
            public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> list, ITooltipFlag flag) {
                list.add((ITextComponent)new TranslationTextComponent("tooltip.spikes_1").func_240699_a_(TextFormatting.YELLOW));
                list.add((ITextComponent)new TranslationTextComponent("tooltip.spikes_2").func_240699_a_(TextFormatting.YELLOW));
            }
        };
        TANK = new BlockTank(AbstractBlock.Properties.func_200949_a((Material)Material.field_151592_s, (MaterialColor)MaterialColor.field_151677_p).func_200948_a(1.0f, 2000.0f).func_200947_a(SoundType.field_185853_f).func_226896_b_());
        TANK_ITEM = new BlockItem(TANK, new Item.Properties().func_200916_a(MobGrindingUtils.TAB)){

            @OnlyIn(value=Dist.CLIENT)
            public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> list, ITooltipFlag flag) {
                FluidStack fluid;
                if (stack.func_77942_o() && !stack.func_77978_p().func_74764_b("Empty") && (fluid = FluidStack.loadFluidStackFromNBT((CompoundNBT)stack.func_77978_p())) != null) {
                    list.add((ITextComponent)new TranslationTextComponent("Contains: " + fluid.getDisplayName().getString()).func_240699_a_(TextFormatting.GREEN));
                    list.add((ITextComponent)new TranslationTextComponent("" + fluid.getAmount() + "Mb/32000Mb").func_240699_a_(TextFormatting.BLUE));
                }
            }
        };
        TANK_TILE = TileEntityType.Builder.func_223042_a(TileEntityTank::new, (Block[])new Block[]{TANK}).func_206865_a(null);
        TANK_SINK = new BlockTankSink(AbstractBlock.Properties.func_200949_a((Material)Material.field_151592_s, (MaterialColor)MaterialColor.field_151677_p).func_200948_a(1.0f, 2000.0f).func_200947_a(SoundType.field_185853_f).func_226896_b_());
        TANK_SINK_ITEM = new BlockItem(TANK_SINK, new Item.Properties().func_200916_a(MobGrindingUtils.TAB)){

            @OnlyIn(value=Dist.CLIENT)
            public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> list, ITooltipFlag flag) {
                FluidStack fluid;
                if (stack.func_77942_o() && !stack.func_77978_p().func_74764_b("Empty") && (fluid = FluidStack.loadFluidStackFromNBT((CompoundNBT)stack.func_77978_p())) != null) {
                    list.add((ITextComponent)new TranslationTextComponent("Contains: " + fluid.getDisplayName().getString()).func_240699_a_(TextFormatting.GREEN));
                    list.add((ITextComponent)new TranslationTextComponent("" + fluid.getAmount() + "Mb/32000Mb").func_240699_a_(TextFormatting.BLUE));
                }
            }
        };
        TANK_SINK_TILE = TileEntityType.Builder.func_223042_a(TileEntitySinkTank::new, (Block[])new Block[]{TANK_SINK}).func_206865_a(null);
        XP_TAP = new BlockXPTap(AbstractBlock.Properties.func_200949_a((Material)Material.field_151591_t, (MaterialColor)MaterialColor.field_151665_m).func_200948_a(1.0f, 2000.0f).func_200947_a(SoundType.field_185852_e).func_226896_b_());
        XP_TAP_ITEM = new BlockItem(XP_TAP, new Item.Properties().func_200916_a(MobGrindingUtils.TAB)){

            @OnlyIn(value=Dist.CLIENT)
            public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> list, ITooltipFlag flag) {
                list.add((ITextComponent)new TranslationTextComponent("tooltip.xptap_1").func_240699_a_(TextFormatting.YELLOW));
                list.add((ITextComponent)new TranslationTextComponent("tooltip.xptap_2").func_240699_a_(TextFormatting.YELLOW));
            }
        };
        XP_TAP_TILE = TileEntityType.Builder.func_223042_a(TileEntityXPTap::new, (Block[])new Block[]{XP_TAP}).func_206865_a(null);
        WITHER_MUFFLER = new BlockWitherMuffler(AbstractBlock.Properties.func_200949_a((Material)Material.field_151580_n, (MaterialColor)MaterialColor.field_151665_m).func_200948_a(0.5f, 2000.0f).func_200947_a(SoundType.field_185854_g));
        WITHER_MUFFLER_ITEM = new BlockItem(WITHER_MUFFLER, new Item.Properties().func_200916_a(MobGrindingUtils.TAB)){

            @OnlyIn(value=Dist.CLIENT)
            public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> list, ITooltipFlag flag) {
                list.add((ITextComponent)new TranslationTextComponent("tooltip.withermuffler_1").func_240699_a_(TextFormatting.YELLOW));
                list.add((ITextComponent)new TranslationTextComponent("tooltip.withermuffler_2").func_240699_a_(TextFormatting.YELLOW));
                list.add((ITextComponent)new TranslationTextComponent("tooltip.withermuffler_3").func_240699_a_(TextFormatting.YELLOW));
            }
        };
        DRAGON_MUFFLER = new BlockDragonMuffler(AbstractBlock.Properties.func_200949_a((Material)Material.field_151580_n, (MaterialColor)MaterialColor.field_151665_m).func_200948_a(0.5f, 2000.0f).func_200947_a(SoundType.field_185854_g));
        DRAGON_MUFFLER_ITEM = new BlockItem(DRAGON_MUFFLER, new Item.Properties().func_200916_a(MobGrindingUtils.TAB)){

            @OnlyIn(value=Dist.CLIENT)
            public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> list, ITooltipFlag flag) {
                list.add((ITextComponent)new TranslationTextComponent("tooltip.dragonmuffler_1").func_240699_a_(TextFormatting.YELLOW));
                list.add((ITextComponent)new TranslationTextComponent("tooltip.dragonmuffler_2").func_240699_a_(TextFormatting.YELLOW));
                list.add((ITextComponent)new TranslationTextComponent("tooltip.dragonmuffler_3").func_240699_a_(TextFormatting.YELLOW));
            }
        };
        DARK_OAK_STONE = new BlockDarkOakStone(AbstractBlock.Properties.func_200949_a((Material)Material.field_151576_e, (MaterialColor)MaterialColor.field_151665_m).func_200948_a(1.5f, 10.0f).func_200947_a(SoundType.field_185851_d).func_235838_a_(bState -> 7));
        DARK_OAK_STONE_ITEM = new BlockItem(DARK_OAK_STONE, new Item.Properties().func_200916_a(MobGrindingUtils.TAB)){

            @OnlyIn(value=Dist.CLIENT)
            public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> list, ITooltipFlag flag) {
                list.add((ITextComponent)new TranslationTextComponent("tooltip.darkoakstone").func_240699_a_(TextFormatting.YELLOW));
            }
        };
        ENTITY_CONVEYOR = new BlockEntityConveyor(AbstractBlock.Properties.func_200949_a((Material)Material.field_151576_e, (MaterialColor)MaterialColor.field_151665_m).func_200948_a(0.5f, 2000.0f).func_200947_a(SoundType.field_185851_d));
        ENTITY_CONVEYOR_ITEM = new BlockItem(ENTITY_CONVEYOR, new Item.Properties().func_200916_a(MobGrindingUtils.TAB)){

            @OnlyIn(value=Dist.CLIENT)
            public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> list, ITooltipFlag flag) {
                list.add((ITextComponent)new TranslationTextComponent("tooltip.entityconveyor_1").func_240699_a_(TextFormatting.YELLOW));
                list.add((ITextComponent)new TranslationTextComponent("tooltip.entityconveyor_2").func_240699_a_(TextFormatting.YELLOW));
            }
        };
        ENDER_INHIBITOR_ON = new BlockEnderInhibitorOn(AbstractBlock.Properties.func_200949_a((Material)Material.field_151591_t, (MaterialColor)MaterialColor.field_151665_m).func_200948_a(0.2f, 2000.0f).func_200947_a(SoundType.field_185852_e).func_226896_b_());
        ENDER_INHIBITOR_ON_ITEM = new BlockItem(ENDER_INHIBITOR_ON, new Item.Properties().func_200916_a(MobGrindingUtils.TAB)){

            @OnlyIn(value=Dist.CLIENT)
            public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> list, ITooltipFlag flag) {
                list.add((ITextComponent)new TranslationTextComponent("tooltip.enderinhibitor_1").func_240699_a_(TextFormatting.YELLOW));
                list.add((ITextComponent)new TranslationTextComponent("tooltip.enderinhibitor_2").func_240699_a_(TextFormatting.YELLOW));
                list.add((ITextComponent)new TranslationTextComponent("tooltip.enderinhibitor_3").func_240699_a_(TextFormatting.YELLOW));
            }
        };
        ENDER_INHIBITOR_OFF = new BlockEnderInhibitorOff(AbstractBlock.Properties.func_200949_a((Material)Material.field_151591_t, (MaterialColor)MaterialColor.field_151665_m).func_200948_a(0.2f, 2000.0f).func_200947_a(SoundType.field_185852_e).func_226896_b_());
        ENDER_INHIBITOR_OFF_ITEM = new BlockItem(ENDER_INHIBITOR_OFF, new Item.Properties().func_200916_a(MobGrindingUtils.TAB)){

            @OnlyIn(value=Dist.CLIENT)
            public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> list, ITooltipFlag flag) {
                list.add((ITextComponent)new TranslationTextComponent("tooltip.enderinhibitor_1").func_240699_a_(TextFormatting.YELLOW));
                list.add((ITextComponent)new TranslationTextComponent("tooltip.enderinhibitor_2").func_240699_a_(TextFormatting.YELLOW));
                list.add((ITextComponent)new TranslationTextComponent("tooltip.enderinhibitor_3").func_240699_a_(TextFormatting.YELLOW));
            }
        };
        FLUID_XP = (Fluid)new ForgeFlowingFluid.Source(new ForgeFlowingFluid.Properties(() -> FLUID_XP, () -> FLUID_XP, FluidAttributes.builder((ResourceLocation)new ResourceLocation("mob_grinding_utils", "fluids/fluid_xp"), (ResourceLocation)new ResourceLocation("mob_grinding_utils", "fluids/fluid_xp")).luminosity(10).density(800).viscosity(1500).translationKey("mob_grinding_utils.fluid_xp").sound(SoundEvents.field_187802_ec, SoundEvents.field_187604_bf)).bucket(() -> ModItems.FLUID_XP_BUCKET)).setRegistryName("mob_grinding_utils", "fluid_xp");
    }

    public static void initReg() {
        try {
            for (Field field : ModBlocks.class.getDeclaredFields()) {
                String name;
                Object obj = field.get(null);
                if (obj instanceof Block) {
                    Block block = (Block)obj;
                    name = field.getName().toLowerCase(Locale.ENGLISH);
                    ModBlocks.registerBlock(name, block);
                }
                if (obj instanceof BlockItem) {
                    BlockItem blockItem = (BlockItem)obj;
                    name = field.getName().toLowerCase(Locale.ENGLISH);
                    ModBlocks.registerBlockItem(name, blockItem);
                }
                if (!(obj instanceof TileEntityType)) continue;
                TileEntityType tileEntity = (TileEntityType)obj;
                name = field.getName().toLowerCase(Locale.ENGLISH);
                ModBlocks.registerTileEntity(name, tileEntity);
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static void registerBlock(String name, Block block) {
        BLOCKS.add(block);
        block.setRegistryName("mob_grinding_utils", name);
    }

    public static void registerBlockItem(String name, BlockItem item) {
        String[] newName = name.split("_item");
        ITEM_BLOCKS.add(item);
        item.setRegistryName("mob_grinding_utils", newName[0]);
    }

    public static void registerTileEntity(String name, TileEntityType<?> tileEntity) {
        String[] newName = name.split("_tile");
        TILE_ENTITIES.add(tileEntity);
        tileEntity.setRegistryName("mob_grinding_utils", newName[0]);
    }

    @Mod.EventBusSubscriber(modid="mob_grinding_utils", bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class RegistrationHandlerBlocks {
        @SubscribeEvent
        public static void registerBlocks(RegistryEvent.Register<Block> event) {
            ModBlocks.init();
            ModBlocks.initReg();
            IForgeRegistry registry = event.getRegistry();
            for (Block block : BLOCKS) {
                registry.register((IForgeRegistryEntry)block);
            }
        }

        @SubscribeEvent
        public static void registerBlockItems(RegistryEvent.Register<Item> event) {
            IForgeRegistry registry = event.getRegistry();
            for (BlockItem item : ITEM_BLOCKS) {
                registry.register((IForgeRegistryEntry)item);
            }
        }

        @SubscribeEvent
        public static void registerTileEntities(RegistryEvent.Register<TileEntityType<?>> event) {
            IForgeRegistry registry = event.getRegistry();
            for (TileEntityType<?> tileEntity : TILE_ENTITIES) {
                registry.register(tileEntity);
            }
        }

        @SubscribeEvent
        public static void registerFluids(RegistryEvent.Register<Fluid> evt) {
            IForgeRegistry registry = evt.getRegistry();
            registry.register((IForgeRegistryEntry)FLUID_XP);
        }
    }
}

