/*
 * Decompiled with CFR 0.152.
 */
package mob_grinding_utils.blocks;

import java.util.Locale;
import java.util.Random;
import mob_grinding_utils.ModBlocks;
import mob_grinding_utils.blocks.BlockEnderInhibitorOff;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.BlockVoxelShape;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BlockEnderInhibitorOn
extends Block {
    public static final EnumProperty<EnumGemDirection> TYPE = EnumProperty.func_177709_a((String)"type", EnumGemDirection.class);
    public static final VoxelShape DOWN_NORTH_AABB = Block.func_208617_a((double)2.0, (double)0.0, (double)3.0, (double)14.0, (double)3.0, (double)13.0);
    public static final VoxelShape DOWN_SOUTH_AABB = Block.func_208617_a((double)2.0, (double)0.0, (double)3.0, (double)14.0, (double)3.0, (double)13.0);
    public static final VoxelShape DOWN_WEST_AABB = Block.func_208617_a((double)3.0, (double)0.0, (double)2.0, (double)13.0, (double)3.0, (double)14.0);
    public static final VoxelShape DOWN_EAST_AABB = Block.func_208617_a((double)3.0, (double)0.0, (double)2.0, (double)13.0, (double)3.0, (double)14.0);
    public static final VoxelShape UP_NORTH_AABB = Block.func_208617_a((double)2.0, (double)13.0, (double)3.0, (double)14.0, (double)16.0, (double)13.0);
    public static final VoxelShape UP_SOUTH_AABB = Block.func_208617_a((double)2.0, (double)13.0, (double)3.0, (double)14.0, (double)16.0, (double)13.0);
    public static final VoxelShape UP_WEST_AABB = Block.func_208617_a((double)3.0, (double)13.0, (double)2.0, (double)13.0, (double)16.0, (double)14.0);
    public static final VoxelShape UP_EAST_AABB = Block.func_208617_a((double)3.0, (double)13.0, (double)2.0, (double)13.0, (double)16.0, (double)14.0);
    public static final VoxelShape NORTH_AABB = Block.func_208617_a((double)2.0, (double)3.0, (double)0.0, (double)14.0, (double)13.0, (double)3.0);
    public static final VoxelShape SOUTH_AABB = Block.func_208617_a((double)2.0, (double)3.0, (double)13.0, (double)14.0, (double)13.0, (double)16.0);
    public static final VoxelShape WEST_AABB = Block.func_208617_a((double)0.0, (double)3.0, (double)2.0, (double)3.0, (double)13.0, (double)14.0);
    public static final VoxelShape EAST_AABB = Block.func_208617_a((double)13.0, (double)3.0, (double)2.0, (double)16.0, (double)13.0, (double)14.0);

    public BlockEnderInhibitorOn(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a(TYPE, (Comparable)((Object)EnumGemDirection.DOWN_NORTH)));
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState stateIn, World world, BlockPos pos, Random rand) {
        for (int i = 0; i < 4; ++i) {
            double d0 = (float)pos.func_177958_n() + rand.nextFloat();
            double d1 = (float)pos.func_177956_o() + rand.nextFloat();
            double d2 = (float)pos.func_177952_p() + rand.nextFloat();
            double d3 = ((double)rand.nextFloat() - 0.5) * 0.5;
            double d4 = ((double)rand.nextFloat() - 0.5) * 0.5;
            double d5 = ((double)rand.nextFloat() - 0.5) * 0.5;
            int j = rand.nextInt(2) * 2 - 1;
            if (world.func_180495_p(pos.func_177976_e()).func_177230_c() != this && world.func_180495_p(pos.func_177974_f()).func_177230_c() != this) {
                d0 = (double)pos.func_177958_n() + 0.5 + 0.25 * (double)j;
                d3 = rand.nextFloat() * 2.0f * (float)j;
            } else {
                d2 = (double)pos.func_177952_p() + 0.5 + 0.25 * (double)j;
                d5 = rand.nextFloat() * 2.0f * (float)j;
            }
            world.func_195594_a((IParticleData)ParticleTypes.field_197599_J, d0, d1, d2, d3, d4, d5);
        }
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        switch ((EnumGemDirection)((Object)state.func_177229_b(TYPE))) {
            case SOUTH: {
                return SOUTH_AABB;
            }
            case NORTH: {
                return NORTH_AABB;
            }
            case EAST: {
                return EAST_AABB;
            }
            case WEST: {
                return WEST_AABB;
            }
            case UP_NORTH: {
                return UP_NORTH_AABB;
            }
            case UP_EAST: {
                return UP_EAST_AABB;
            }
            case UP_SOUTH: {
                return UP_SOUTH_AABB;
            }
            case UP_WEST: {
                return UP_WEST_AABB;
            }
            case DOWN_NORTH: {
                return DOWN_NORTH_AABB;
            }
            case DOWN_EAST: {
                return DOWN_EAST_AABB;
            }
            case DOWN_SOUTH: {
                return DOWN_SOUTH_AABB;
            }
            case DOWN_WEST: {
                return DOWN_WEST_AABB;
            }
        }
        return DOWN_NORTH_AABB;
    }

    public VoxelShape func_199600_g(BlockState state, IBlockReader worldIn, BlockPos pos) {
        switch ((EnumGemDirection)((Object)state.func_177229_b(TYPE))) {
            case SOUTH: {
                return SOUTH_AABB;
            }
            case NORTH: {
                return NORTH_AABB;
            }
            case EAST: {
                return EAST_AABB;
            }
            case WEST: {
                return WEST_AABB;
            }
            case UP_NORTH: {
                return UP_NORTH_AABB;
            }
            case UP_EAST: {
                return UP_EAST_AABB;
            }
            case UP_SOUTH: {
                return UP_SOUTH_AABB;
            }
            case UP_WEST: {
                return UP_WEST_AABB;
            }
            case DOWN_NORTH: {
                return DOWN_NORTH_AABB;
            }
            case DOWN_EAST: {
                return DOWN_EAST_AABB;
            }
            case DOWN_SOUTH: {
                return DOWN_SOUTH_AABB;
            }
            case DOWN_WEST: {
                return DOWN_WEST_AABB;
            }
        }
        return DOWN_NORTH_AABB;
    }

    public void func_220069_a(BlockState state, World world, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        EnumGemDirection newFacing = (EnumGemDirection)((Object)state.func_177229_b(TYPE));
        boolean flag = false;
        if ((newFacing == EnumGemDirection.UP_NORTH || newFacing == EnumGemDirection.UP_EAST || newFacing == EnumGemDirection.UP_SOUTH || newFacing == EnumGemDirection.UP_WEST) && world.func_180495_p(pos.func_177984_a()).func_242698_a((IBlockReader)world, pos.func_177984_a(), Direction.DOWN, BlockVoxelShape.RIGID)) {
            flag = true;
        }
        if ((newFacing == EnumGemDirection.DOWN_NORTH || newFacing == EnumGemDirection.DOWN_EAST || newFacing == EnumGemDirection.DOWN_SOUTH || newFacing == EnumGemDirection.DOWN_WEST) && world.func_180495_p(pos.func_177977_b()).func_242698_a((IBlockReader)world, pos.func_177977_b(), Direction.UP, BlockVoxelShape.RIGID)) {
            flag = true;
        }
        if (newFacing == EnumGemDirection.NORTH && world.func_180495_p(pos.func_177972_a(Direction.NORTH)).func_242698_a((IBlockReader)world, pos.func_177972_a(Direction.NORTH), Direction.NORTH, BlockVoxelShape.RIGID)) {
            flag = true;
        }
        if (newFacing == EnumGemDirection.SOUTH && world.func_180495_p(pos.func_177972_a(Direction.SOUTH)).func_242698_a((IBlockReader)world, pos.func_177972_a(Direction.SOUTH), Direction.SOUTH, BlockVoxelShape.RIGID)) {
            flag = true;
        }
        if (newFacing == EnumGemDirection.WEST && world.func_180495_p(pos.func_177972_a(Direction.WEST)).func_242698_a((IBlockReader)world, pos.func_177972_a(Direction.WEST), Direction.WEST, BlockVoxelShape.RIGID)) {
            flag = true;
        }
        if (newFacing == EnumGemDirection.EAST && world.func_180495_p(pos.func_177972_a(Direction.EAST)).func_242698_a((IBlockReader)world, pos.func_177972_a(Direction.EAST), Direction.EAST, BlockVoxelShape.RIGID)) {
            flag = true;
        }
        if (!flag) {
            BlockEnderInhibitorOn.func_180635_a((World)world, (BlockPos)pos, (ItemStack)new ItemStack((IItemProvider)ModBlocks.ENDER_INHIBITOR_OFF_ITEM, 1));
            world.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
        }
        super.func_220069_a(state, world, pos, block, fromPos, isMoving);
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        if (world.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        BlockState activeState = (BlockState)ModBlocks.ENDER_INHIBITOR_OFF.func_176223_P().func_206870_a((Property)BlockEnderInhibitorOff.TYPE, state.func_177229_b(TYPE));
        world.func_180501_a(pos, activeState, 3);
        world.func_184133_a(null, pos, SoundEvents.field_187750_dc, SoundCategory.BLOCKS, 0.3f, 0.6f);
        return ActionResultType.SUCCESS;
    }

    public boolean func_196260_a(BlockState state, IWorldReader world, BlockPos pos) {
        for (Direction enumfacing : Direction.values()) {
            if (!BlockEnderInhibitorOn.func_220055_a((IWorldReader)world, (BlockPos)pos.func_177972_a(enumfacing.func_176734_d()), (Direction)enumfacing)) continue;
            return true;
        }
        return false;
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        Direction facing = context.func_196000_l();
        Direction direction = context.func_195999_j().func_174811_aO();
        EnumGemDirection newFacing = EnumGemDirection.DOWN_NORTH;
        if (facing == Direction.UP) {
            switch (direction) {
                case SOUTH: {
                    newFacing = EnumGemDirection.DOWN_SOUTH;
                    break;
                }
                case EAST: {
                    newFacing = EnumGemDirection.DOWN_WEST;
                    break;
                }
                case NORTH: {
                    newFacing = EnumGemDirection.DOWN_NORTH;
                    break;
                }
                case WEST: {
                    newFacing = EnumGemDirection.DOWN_EAST;
                }
            }
        } else if (facing == Direction.DOWN) {
            switch (direction) {
                case SOUTH: {
                    newFacing = EnumGemDirection.UP_SOUTH;
                    break;
                }
                case EAST: {
                    newFacing = EnumGemDirection.UP_WEST;
                    break;
                }
                case NORTH: {
                    newFacing = EnumGemDirection.UP_NORTH;
                    break;
                }
                case WEST: {
                    newFacing = EnumGemDirection.UP_EAST;
                }
            }
        } else {
            switch (facing) {
                case SOUTH: {
                    newFacing = EnumGemDirection.NORTH;
                    break;
                }
                case EAST: {
                    newFacing = EnumGemDirection.WEST;
                    break;
                }
                case NORTH: {
                    newFacing = EnumGemDirection.SOUTH;
                    break;
                }
                case WEST: {
                    newFacing = EnumGemDirection.EAST;
                }
            }
        }
        return (BlockState)this.func_176223_P().func_206870_a(TYPE, (Comparable)((Object)newFacing));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{TYPE});
    }

    public static enum EnumGemDirection implements IStringSerializable
    {
        DOWN_NORTH,
        DOWN_SOUTH,
        DOWN_WEST,
        DOWN_EAST,
        UP_NORTH,
        UP_SOUTH,
        UP_WEST,
        UP_EAST,
        NORTH,
        SOUTH,
        WEST,
        EAST;


        public String func_176610_l() {
            return this.name().toLowerCase(Locale.ENGLISH);
        }
    }
}

