/*
 * Decompiled with CFR 0.152.
 */
package mob_grinding_utils.blocks;

import java.lang.reflect.Method;
import mob_grinding_utils.MobGrindingUtils;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.DirectionalBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.event.entity.living.LivingDropsEvent;

public class BlockSpikes
extends DirectionalBlock {
    public static final VoxelShape SPIKES_AABB = Block.func_208617_a((double)1.0, (double)1.0, (double)1.0, (double)15.0, (double)15.0, (double)15.0);
    public static final Method xpPoints = BlockSpikes.getExperiencePoints();

    public BlockSpikes(AbstractBlock.Properties properties) {
        super(properties);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SPIKES_AABB;
    }

    public VoxelShape func_199600_g(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return VoxelShapes.func_197868_b();
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        Direction direction = context.func_196000_l();
        return (BlockState)this.func_176223_P().func_206870_a((Property)field_176387_N, (Comparable)direction);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{field_176387_N});
    }

    public void func_196262_a(BlockState state, World world, BlockPos pos, Entity entity) {
        if (!world.field_72995_K && entity instanceof LivingEntity) {
            entity.func_70097_a(MobGrindingUtils.SPIKE_DAMAGE, 5.0f);
        }
    }

    public static void dropXP(LivingDropsEvent event) {
        LivingEntity entity = event.getEntityLiving();
        World world = entity.func_130014_f_();
        if (entity != null && !world.field_72995_K && !event.isRecentlyHit() && event.getSource() == MobGrindingUtils.SPIKE_DAMAGE) {
            int xp = 0;
            try {
                xp = (Integer)xpPoints.invoke((Object)entity, FakePlayerFactory.getMinecraft((ServerWorld)((ServerWorld)world)));
            }
            catch (Exception exception) {
                // empty catch block
            }
            while (xp > 0) {
                int cap = ExperienceOrbEntity.func_70527_a((int)xp);
                xp -= cap;
                entity.func_130014_f_().func_217376_c((Entity)new ExperienceOrbEntity(entity.func_130014_f_(), entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), cap));
            }
        }
    }

    public static Method getExperiencePoints() {
        Method method = null;
        try {
            method = LivingEntity.class.getDeclaredMethod("getExperiencePoints", PlayerEntity.class);
            method.setAccessible(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            method = LivingEntity.class.getDeclaredMethod("func_70693_a", PlayerEntity.class);
            method.setAccessible(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return method;
    }
}

