/*
 * Decompiled with CFR 0.152.
 */
package mob_grinding_utils.blocks;

import mob_grinding_utils.ModSounds;
import mob_grinding_utils.blocks.BlockTank;
import mob_grinding_utils.tile.TileEntityXPTap;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.DirectionalBlock;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class BlockXPTap
extends DirectionalBlock
implements ITileEntityProvider {
    public static final VoxelShape XP_TAP_WEST_AABB = Block.func_208617_a((double)7.0, (double)6.0, (double)4.0, (double)16.0, (double)16.0, (double)12.0);
    public static final VoxelShape XP_TAP_EAST_AABB = Block.func_208617_a((double)0.0, (double)6.0, (double)4.0, (double)9.0, (double)16.0, (double)12.0);
    public static final VoxelShape XP_TAP_SOUTH_AABB = Block.func_208617_a((double)4.0, (double)6.0, (double)0.0, (double)12.0, (double)16.0, (double)9.0);
    public static final VoxelShape XP_TAP_NORTH_AABB = Block.func_208617_a((double)4.0, (double)6.0, (double)7.0, (double)12.0, (double)16.0, (double)16.0);
    public static final BooleanProperty POWERED = BooleanProperty.func_177716_a((String)"powered");

    public BlockXPTap(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        switch ((Direction)state.func_177229_b((Property)field_176387_N)) {
            default: {
                return XP_TAP_EAST_AABB;
            }
            case WEST: {
                return XP_TAP_WEST_AABB;
            }
            case SOUTH: {
                return XP_TAP_SOUTH_AABB;
            }
            case NORTH: 
        }
        return XP_TAP_NORTH_AABB;
    }

    public VoxelShape func_199600_g(BlockState state, IBlockReader worldIn, BlockPos pos) {
        switch ((Direction)state.func_177229_b((Property)field_176387_N)) {
            default: {
                return XP_TAP_EAST_AABB;
            }
            case WEST: {
                return XP_TAP_WEST_AABB;
            }
            case SOUTH: {
                return XP_TAP_SOUTH_AABB;
            }
            case NORTH: 
        }
        return XP_TAP_NORTH_AABB;
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        Direction direction = context.func_196000_l();
        return (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)field_176387_N, (Comparable)direction)).func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(false));
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        if (world.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        boolean swap = (Boolean)state.func_177229_b((Property)POWERED);
        world.func_180501_a(pos, (BlockState)state.func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(!swap)), 3);
        float f = (Boolean)state.func_177229_b((Property)POWERED) != false ? 0.6f : 0.5f;
        world.func_184133_a(null, pos, ModSounds.TAP_SQUEAK, SoundCategory.BLOCKS, 0.3f, f);
        TileEntityXPTap tileentity = (TileEntityXPTap)world.func_175625_s(pos);
        tileentity.setActive(!swap);
        return ActionResultType.SUCCESS;
    }

    public boolean func_196260_a(BlockState state, IWorldReader world, BlockPos pos) {
        for (Direction enumfacing : field_176387_N.func_177700_c()) {
            if (!this.canPlaceAt(world, pos, enumfacing)) continue;
            return true;
        }
        return false;
    }

    private boolean canPlaceAt(IWorldReader world, BlockPos pos, Direction facing) {
        BlockPos blockpos = pos.func_177972_a(facing);
        boolean isSide = facing.func_176740_k().func_176722_c();
        return isSide && world.func_180495_p(blockpos).func_177230_c() instanceof BlockTank;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{field_176387_N, POWERED});
    }

    public TileEntity func_196283_a_(IBlockReader world) {
        return new TileEntityXPTap();
    }
}

