/*
 * Decompiled with CFR 0.152.
 */
package mob_grinding_utils.datagen;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import mob_grinding_utils.ModBlocks;
import net.minecraft.block.Block;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.LootTableProvider;
import net.minecraft.data.loot.BlockLootTables;
import net.minecraft.loot.LootParameterSet;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.LootTableManager;
import net.minecraft.loot.ValidationTracker;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;

public class LootTables
extends LootTableProvider {
    public LootTables(DataGenerator dataGeneratorIn) {
        super(dataGeneratorIn);
    }

    @Nonnull
    protected List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootParameterSet>> getTables() {
        return ImmutableList.of((Object)Pair.of(() -> new Blocks(), (Object)LootParameterSets.field_216267_h));
    }

    protected void validate(Map<ResourceLocation, LootTable> map, @Nonnull ValidationTracker validationtracker) {
        map.forEach((name, table) -> LootTableManager.func_227508_a_((ValidationTracker)validationtracker, (ResourceLocation)name, (LootTable)table));
    }

    private static class Blocks
    extends BlockLootTables {
        private Blocks() {
        }

        protected void addTables() {
            this.func_218492_c(ModBlocks.ABSORPTION_HOPPER);
            this.func_218492_c(ModBlocks.DARK_OAK_STONE);
            this.func_218492_c(ModBlocks.DRAGON_MUFFLER);
            this.func_218492_c(ModBlocks.WITHER_MUFFLER);
            this.func_218492_c(ModBlocks.ENTITY_CONVEYOR);
            this.func_218492_c(ModBlocks.FAN);
            this.func_218492_c(ModBlocks.SAW);
            this.func_218492_c(ModBlocks.SPIKES);
            this.func_218492_c(ModBlocks.XP_TAP);
            this.func_218492_c(ModBlocks.ENDER_INHIBITOR_ON);
            this.func_218493_a(ModBlocks.ENDER_INHIBITOR_OFF, (IItemProvider)ModBlocks.ENDER_INHIBITOR_ON_ITEM);
        }

        @Nonnull
        protected Iterable<Block> getKnownBlocks() {
            return ForgeRegistries.BLOCKS.getValues().stream().filter(b -> b.getRegistryName().func_110624_b().equals("mob_grinding_utils")).filter(b -> !b.getRegistryName().func_110623_a().equals("tank")).filter(b -> !b.getRegistryName().func_110623_a().equals("tank_sink")).collect(Collectors.toList());
        }
    }
}

