/*
 * Decompiled with CFR 0.152.
 */
package mob_grinding_utils.recipe;

import mob_grinding_utils.MobGrindingUtils;
import mob_grinding_utils.ModBlocks;
import mob_grinding_utils.ModItems;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.SpecialRecipe;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class RecipeChickenFeed
extends SpecialRecipe {
    public RecipeChickenFeed(ResourceLocation idIn) {
        super(idIn);
    }

    public boolean matches(CraftingInventory craftMatrix, World world) {
        int size = craftMatrix.func_70302_i_();
        ItemStack mobSwab = ItemStack.field_190927_a;
        boolean hasSeeds = false;
        boolean hasBucket = false;
        int cnt = 0;
        for (int a = 0; a < size; ++a) {
            ItemStack is = craftMatrix.func_70301_a(a);
            if (is.func_190926_b()) continue;
            ++cnt;
            if (is.func_77973_b() == ModItems.FLUID_XP_BUCKET) {
                LazyOptional bucketHandler = is.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
                bucketHandler.ifPresent(receptacle -> {
                    if (!is.func_190926_b() && receptacle.getFluidInTank(1).getAmount() > 0 && receptacle.getFluidInTank(1).containsFluid(new FluidStack(ModBlocks.FLUID_XP, 1))) {
                        receptacle.drain(1000, IFluidHandler.FluidAction.EXECUTE);
                    }
                });
                hasBucket = true;
                continue;
            }
            if (is.func_77973_b() == Items.field_151014_N) {
                hasSeeds = true;
                continue;
            }
            if (is.func_77973_b() != ModItems.MOB_SWAB_USED) continue;
            mobSwab = is;
        }
        if (cnt == 3 && hasSeeds && hasBucket && !mobSwab.func_190926_b()) {
            return mobSwab.func_77978_p().func_74764_b("mguMobName");
        }
        return false;
    }

    public ItemStack getCraftingResult(CraftingInventory craftMatrix) {
        ItemStack is = ItemStack.field_190927_a;
        for (int a = 0; a < craftMatrix.func_70302_i_(); ++a) {
            ItemStack is2 = craftMatrix.func_70301_a(a);
            if (is2.func_190926_b() || is2.func_77973_b() != ModItems.MOB_SWAB_USED) continue;
            is = is2;
        }
        if (is.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        ItemStack chickenFeed = new ItemStack((IItemProvider)ModItems.GM_CHICKEN_FEED, 1);
        if (!chickenFeed.func_77942_o()) {
            chickenFeed.func_77982_d(new CompoundNBT());
        }
        if (!is.func_77942_o()) {
            is.func_77982_d(new CompoundNBT());
        }
        if (is.func_77978_p().func_74764_b("mguMobName")) {
            chickenFeed.func_77978_p().func_74778_a("mguMobName", is.func_77978_p().func_74779_i("mguMobName"));
        }
        return chickenFeed;
    }

    public ItemStack func_77571_b() {
        return new ItemStack((IItemProvider)ModItems.GM_CHICKEN_FEED, 1);
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInventory inv) {
        NonNullList aitemstack = NonNullList.func_191197_a((int)inv.func_70302_i_(), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < aitemstack.size(); ++i) {
            ItemStack itemstack = inv.func_70301_a(i);
            aitemstack.set(i, (Object)ForgeHooks.getContainerItem((ItemStack)itemstack));
        }
        return aitemstack;
    }

    public boolean func_194133_a(int width, int height) {
        return width * height >= 2;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)MobGrindingUtils.RECIPE_CHICKEN_FEED.get();
    }
}

