/*
 * Decompiled with CFR 0.152.
 */
package mob_grinding_utils.tile;

import io.netty.buffer.Unpooled;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mob_grinding_utils.ModBlocks;
import mob_grinding_utils.ModItems;
import mob_grinding_utils.inventory.server.ContainerAbsorptionHopper;
import mob_grinding_utils.inventory.server.InventoryWrapperAH;
import mob_grinding_utils.tile.TileEntityInventoryHelper;
import net.minecraft.block.BlockState;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class TileEntityAbsorptionHopper
extends TileEntityInventoryHelper
implements ITickableTileEntity,
INamedContainerProvider {
    public FluidTank tank = new FluidTank(16000);
    private final LazyOptional<IFluidHandler> tank_holder = LazyOptional.of(() -> this.tank);
    private IItemHandler itemHandler;
    private LazyOptional<IItemHandler> itemholder = LazyOptional.empty();
    private static final int[] SLOTS = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16};
    public int prevTankAmount;
    public EnumStatus[] status = new EnumStatus[]{EnumStatus.STATUS_NONE, EnumStatus.STATUS_NONE, EnumStatus.STATUS_NONE, EnumStatus.STATUS_NONE, EnumStatus.STATUS_NONE, EnumStatus.STATUS_NONE};
    public boolean showRenderBox;
    public int offsetX;
    public int offsetY;
    public int offsetZ;

    public TileEntityAbsorptionHopper() {
        super(ModBlocks.ABSORPTION_HOPPER_TILE, 17);
        this.itemHandler = this.createUnSidedHandler();
        this.itemholder = LazyOptional.of(() -> this.itemHandler);
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket packet) {
        EnumStatus[] old = new EnumStatus[]{this.status[0], this.status[1], this.status[2], this.status[3], this.status[4], this.status[5]};
        super.onDataPacket(net, packet);
        this.func_230337_a_(this.func_195044_w(), packet.func_148857_g());
        for (Direction facing : Direction.values()) {
            if (old[facing.ordinal()] == this.status[facing.ordinal()]) continue;
            this.func_145831_w().func_225319_b(this.func_174877_v(), this.func_145831_w().func_180495_p(this.func_174877_v()), this.func_145831_w().func_180495_p(this.func_174877_v()));
            return;
        }
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        CompoundNBT nbt = new CompoundNBT();
        this.func_189515_b(nbt);
        return new SUpdateTileEntityPacket(this.func_174877_v(), 0, nbt);
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT nbt = new CompoundNBT();
        return this.func_189515_b(nbt);
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT tagCompound) {
        super.func_230337_a_(state, tagCompound);
        this.status[0] = EnumStatus.values()[tagCompound.func_74771_c("down")];
        this.status[1] = EnumStatus.values()[tagCompound.func_74771_c("up")];
        this.status[2] = EnumStatus.values()[tagCompound.func_74771_c("north")];
        this.status[3] = EnumStatus.values()[tagCompound.func_74771_c("south")];
        this.status[4] = EnumStatus.values()[tagCompound.func_74771_c("west")];
        this.status[5] = EnumStatus.values()[tagCompound.func_74771_c("east")];
        this.showRenderBox = tagCompound.func_74767_n("showRenderBox");
        this.offsetX = tagCompound.func_74762_e("offsetX");
        this.offsetY = tagCompound.func_74762_e("offsetY");
        this.offsetZ = tagCompound.func_74762_e("offsetZ");
        this.tank.readFromNBT(tagCompound);
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tagCompound) {
        super.func_189515_b(tagCompound);
        tagCompound.func_74774_a("down", (byte)this.status[0].ordinal());
        tagCompound.func_74774_a("up", (byte)this.status[1].ordinal());
        tagCompound.func_74774_a("north", (byte)this.status[2].ordinal());
        tagCompound.func_74774_a("south", (byte)this.status[3].ordinal());
        tagCompound.func_74774_a("west", (byte)this.status[4].ordinal());
        tagCompound.func_74774_a("east", (byte)this.status[5].ordinal());
        tagCompound.func_74757_a("showRenderBox", this.showRenderBox);
        tagCompound.func_74768_a("offsetX", this.offsetX);
        tagCompound.func_74768_a("offsetY", this.offsetY);
        tagCompound.func_74768_a("offsetZ", this.offsetZ);
        this.tank.writeToNBT(tagCompound);
        return tagCompound;
    }

    public EnumStatus getSideStatus(Direction side) {
        return this.status[side.ordinal()];
    }

    public void toggleMode(Direction side) {
        switch (this.status[side.ordinal()]) {
            case STATUS_NONE: {
                this.status[side.ordinal()] = EnumStatus.STATUS_OUTPUT_ITEM;
                break;
            }
            case STATUS_OUTPUT_ITEM: {
                this.status[side.ordinal()] = EnumStatus.STATUS_OUTPUT_FLUID;
                break;
            }
            case STATUS_OUTPUT_FLUID: {
                this.status[side.ordinal()] = EnumStatus.STATUS_NONE;
            }
        }
        this.func_70296_d();
    }

    public void toggleRenderBox() {
        this.showRenderBox = !this.showRenderBox;
        this.func_70296_d();
    }

    public void toggleOffset(int direction) {
        switch (direction) {
            case 7: {
                if (this.getoffsetY() < -3 - this.getModifierAmount()) break;
                this.offsetY = this.getoffsetY() - 1;
                break;
            }
            case 8: {
                if (this.getoffsetY() > 3 + this.getModifierAmount()) break;
                this.offsetY = this.getoffsetY() + 1;
                break;
            }
            case 9: {
                if (this.getoffsetZ() < -3 - this.getModifierAmount()) break;
                this.offsetZ = this.getoffsetZ() - 1;
                break;
            }
            case 10: {
                if (this.getoffsetZ() > 3 + this.getModifierAmount()) break;
                this.offsetZ = this.getoffsetZ() + 1;
                break;
            }
            case 11: {
                if (this.getoffsetX() < -3 - this.getModifierAmount()) break;
                this.offsetX = this.getoffsetX() - 1;
                break;
            }
            case 12: {
                if (this.getoffsetX() > 3 + this.getModifierAmount()) break;
                this.offsetX = this.getoffsetX() + 1;
            }
        }
        this.func_70296_d();
    }

    public void updateBlock() {
        this.func_145831_w().func_184138_a(this.field_174879_c, this.func_145831_w().func_180495_p(this.field_174879_c), this.func_145831_w().func_180495_p(this.field_174879_c), 3);
    }

    public void func_73660_a() {
        if (this.func_145831_w().field_72995_K) {
            return;
        }
        this.prevTankAmount = this.tank.getFluidAmount();
        for (Direction facing : Direction.values()) {
            LazyOptional tileOptional;
            TileEntity tile;
            if (this.status[facing.ordinal()] == EnumStatus.STATUS_OUTPUT_ITEM) {
                tile = this.func_145831_w().func_175625_s(this.field_174879_c.func_177972_a(facing));
                if (tile != null && tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing.func_176734_d()).isPresent()) {
                    tileOptional = tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing.func_176734_d());
                    tileOptional.ifPresent(handler -> {
                        if (this.func_145831_w().func_82737_E() % 8L == 0L) {
                            for (int i = 0; i < this.func_70302_i_(); ++i) {
                                if (this.func_70301_a(i).func_190926_b() || i == 0) continue;
                                ItemStack stack = this.func_70301_a(i).func_77946_l();
                                stack.func_190920_e(1);
                                ItemStack stack1 = ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)stack, (boolean)true);
                                if (!stack1.func_190926_b()) continue;
                                ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)this.func_70298_a(i, 1), (boolean)false);
                                this.func_70296_d();
                            }
                        }
                    });
                } else if (tile != null && tile instanceof IInventory) {
                    IInventory iinventory = (IInventory)tile;
                    if (this.isInventoryFull(iinventory, facing)) break;
                    if (this.func_145831_w().func_82737_E() % 8L == 0L) {
                        for (int i = 0; i < this.func_70302_i_(); ++i) {
                            if (this.func_70301_a(i).func_190926_b() || i == 0) continue;
                            ItemStack stack = this.func_70301_a(i).func_77946_l();
                            ItemStack stack1 = TileEntityAbsorptionHopper.putStackInInventoryAllSlots(iinventory, this.func_70298_a(i, 1), facing.func_176734_d());
                            if (stack1.func_190926_b() || stack1.func_190916_E() == 0) {
                                iinventory.func_70296_d();
                                continue;
                            }
                            this.func_70299_a(i, stack);
                        }
                    }
                }
            }
            if (this.status[facing.ordinal()] != EnumStatus.STATUS_OUTPUT_FLUID || (tile = this.func_145831_w().func_175625_s(this.field_174879_c.func_177972_a(facing))) == null) continue;
            tileOptional = tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, facing.func_176734_d());
            tileOptional.ifPresent(receptacle -> {
                int tanks = receptacle.getTanks();
                for (int x = 0; x < tanks; ++x) {
                    if (receptacle.getTankCapacity(x) <= 0) continue;
                    FluidStack contents = receptacle.getFluidInTank(x);
                    if (this.tank.getFluid().isEmpty() || !contents.isEmpty() && (contents.getAmount() > receptacle.getTankCapacity(x) - 100 || !contents.containsFluid(new FluidStack(this.tank.getFluid(), 1)))) continue;
                    receptacle.fill(this.tank.drain(new FluidStack(this.tank.getFluid(), 100), IFluidHandler.FluidAction.EXECUTE), IFluidHandler.FluidAction.EXECUTE);
                    this.func_70296_d();
                }
            });
        }
        if (this.func_145831_w().func_82737_E() % 3L == 0L) {
            if (!this.isInventoryFull((IInventory)this, null)) {
                this.captureDroppedItems();
            }
            if (this.tank.getFluid().isEmpty() || this.tank.getFluid().containsFluid(new FluidStack(ModBlocks.FLUID_XP, 1))) {
                this.captureDroppedXP();
            }
        }
        if (this.prevTankAmount != this.tank.getFluidAmount()) {
            this.updateBlock();
        }
    }

    @Override
    @Nullable
    public ItemStack func_70298_a(int index, int count) {
        return ItemStackHelper.func_188382_a(this.getItems(), (int)index, (int)count);
    }

    public boolean captureDroppedItems() {
        for (ItemEntity entityitem : this.getCaptureItems()) {
            if (!TileEntityAbsorptionHopper.putDropInInventoryAllSlots((IInventory)this, entityitem)) continue;
            return true;
        }
        return false;
    }

    public List<ItemEntity> getCaptureItems() {
        return this.func_145831_w().func_175647_a(ItemEntity.class, this.getAABBWithModifiers(), EntityPredicates.field_94557_a);
    }

    public boolean captureDroppedXP() {
        Iterator<ExperienceOrbEntity> iterator = this.getCaptureXP().iterator();
        if (iterator.hasNext()) {
            ExperienceOrbEntity entity = iterator.next();
            int xpAmount = entity.func_70526_d();
            if (this.tank.getFluidAmount() < this.tank.getCapacity() - xpAmount * 20) {
                this.tank.fill(new FluidStack(ModBlocks.FLUID_XP, xpAmount * 20), IFluidHandler.FluidAction.EXECUTE);
                entity.func_70106_y();
            }
            return true;
        }
        return false;
    }

    public List<ExperienceOrbEntity> getCaptureXP() {
        return this.func_145831_w().func_175647_a(ExperienceOrbEntity.class, this.getAABBWithModifiers(), EntityPredicates.field_94557_a);
    }

    public AxisAlignedBB getAABBWithModifiers() {
        double x = (double)this.func_174877_v().func_177958_n() + 0.5;
        double y = (double)this.func_174877_v().func_177956_o() + 0.5;
        double z = (double)this.func_174877_v().func_177952_p() + 0.5;
        return new AxisAlignedBB(x - 3.5 - (double)this.getModifierAmount(), y - 3.5 - (double)this.getModifierAmount(), z - 3.5 - (double)this.getModifierAmount(), x + 3.5 + (double)this.getModifierAmount(), y + 3.5 + (double)this.getModifierAmount(), z + 3.5 + (double)this.getModifierAmount()).func_72317_d((double)this.getoffsetX(), (double)this.getoffsetY(), (double)this.getoffsetZ());
    }

    @OnlyIn(value=Dist.CLIENT)
    public AxisAlignedBB getAABBForRender() {
        return new AxisAlignedBB(-3.0 - (double)this.getModifierAmount(), -3.0 - (double)this.getModifierAmount(), -3.0 - (double)this.getModifierAmount(), 4.0 + (double)this.getModifierAmount(), 4.0 + (double)this.getModifierAmount(), 4.0 + (double)this.getModifierAmount()).func_72317_d((double)this.getoffsetX(), (double)this.getoffsetY(), (double)this.getoffsetZ());
    }

    @OnlyIn(value=Dist.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return this.getAABBWithModifiers();
    }

    public int getoffsetX() {
        return Math.max(-4 - this.getModifierAmount(), Math.min(this.offsetX, 4 + this.getModifierAmount()));
    }

    public int getoffsetY() {
        return Math.max(-4 - this.getModifierAmount(), Math.min(this.offsetY, 4 + this.getModifierAmount()));
    }

    public int getoffsetZ() {
        return Math.max(-4 - this.getModifierAmount(), Math.min(this.offsetZ, 4 + this.getModifierAmount()));
    }

    private boolean hasUpgrade() {
        return !((ItemStack)this.getItems().get(0)).func_190926_b() && ((ItemStack)this.getItems().get(0)).func_77973_b() == ModItems.ABSORPTION_UPGRADE;
    }

    public int getModifierAmount() {
        return this.hasUpgrade() ? ((ItemStack)this.getItems().get(0)).func_190916_E() : 0;
    }

    @Nullable
    public ItemStack func_70304_b(int index) {
        return ItemStackHelper.func_188383_a(this.getItems(), (int)index);
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return slot != 0;
    }

    public int[] func_180463_a(Direction side) {
        return SLOTS;
    }

    public boolean func_180462_a(int slot, ItemStack stack, Direction direction) {
        return this.func_94041_b(slot, stack);
    }

    public boolean func_180461_b(int slot, ItemStack stack, Direction direction) {
        return slot != 0;
    }

    private boolean isInventoryFull(IInventory inventoryIn, Direction side) {
        if (inventoryIn instanceof ISidedInventory) {
            int[] aint;
            ISidedInventory isidedinventory = (ISidedInventory)inventoryIn;
            for (int k : aint = isidedinventory.func_180463_a(side)) {
                ItemStack itemstack1 = isidedinventory.func_70301_a(k);
                if (!itemstack1.func_190926_b() && itemstack1.func_190916_E() == itemstack1.func_77976_d()) continue;
                return false;
            }
        } else {
            int i = inventoryIn.func_70302_i_();
            for (int j = 0; j < i; ++j) {
                ItemStack itemstack = inventoryIn.func_70301_a(j);
                if (!itemstack.func_190926_b() && itemstack.func_190916_E() == itemstack.func_77976_d()) continue;
                return false;
            }
        }
        return true;
    }

    public static ItemStack putStackInInventoryAllSlots(IInventory inventory, ItemStack stack, @Nullable Direction facing) {
        if (inventory instanceof ISidedInventory && facing != null && !(inventory instanceof TileEntityAbsorptionHopper) && inventory.func_94041_b(0, stack.func_77946_l())) {
            ISidedInventory isidedinventory = (ISidedInventory)inventory;
            int[] aint = isidedinventory.func_180463_a(facing);
            for (int k = 0; k < aint.length && !stack.func_190926_b(); ++k) {
                stack = TileEntityAbsorptionHopper.insertStack(inventory, stack, aint[k], facing);
            }
        } else {
            int i = inventory.func_70302_i_();
            for (int j = 0; j < i && !stack.func_190926_b(); ++j) {
                stack = TileEntityAbsorptionHopper.insertStack(inventory, stack, j, facing);
            }
        }
        return stack;
    }

    public static boolean putDropInInventoryAllSlots(IInventory inventoryIn, ItemEntity itemIn) {
        boolean flag = false;
        if (itemIn == null || inventoryIn instanceof TileEntityAbsorptionHopper && inventoryIn.func_94041_b(0, itemIn.func_92059_d().func_77946_l())) {
            return false;
        }
        ItemStack itemstack = itemIn.func_92059_d().func_77946_l();
        ItemStack itemstack1 = TileEntityAbsorptionHopper.putStackInInventoryAllSlots(inventoryIn, itemstack, null);
        if (!itemstack1.func_190926_b()) {
            itemIn.func_92058_a(itemstack1);
        } else {
            flag = true;
            itemIn.func_70106_y();
        }
        return flag;
    }

    private static boolean canInsertItemInSlot(IInventory inventoryIn, ItemStack stack, int index, Direction side) {
        return !inventoryIn.func_94041_b(index, stack) ? false : !(inventoryIn instanceof ISidedInventory) || ((ISidedInventory)inventoryIn).func_180462_a(index, stack, side);
    }

    private static ItemStack insertStack(IInventory inventory, ItemStack stack, int index, Direction side) {
        ItemStack itemstack = inventory.func_70301_a(index);
        if (TileEntityAbsorptionHopper.canInsertItemInSlot(inventory, stack, index, side)) {
            if (itemstack.func_190926_b()) {
                inventory.func_70299_a(index, stack);
                stack = ItemStack.field_190927_a;
            } else if (TileEntityAbsorptionHopper.canCombine(itemstack, stack)) {
                int i = stack.func_77976_d() - itemstack.func_190916_E();
                int j = Math.min(stack.func_190916_E(), i);
                stack.func_190918_g(j);
                itemstack.func_190917_f(j);
            }
        }
        return stack;
    }

    private static boolean canCombine(ItemStack stack1, ItemStack stack2) {
        return stack1.func_77973_b() != stack2.func_77973_b() ? false : (stack1.func_77952_i() != stack2.func_77952_i() ? false : (stack1.func_190916_E() > stack1.func_77976_d() ? false : ItemStack.func_77970_a((ItemStack)stack1, (ItemStack)stack2)));
    }

    protected IItemHandler createUnSidedHandler() {
        return new InventoryWrapperAH((IInventory)this);
    }

    public int getScaledFluid(int scale) {
        return this.tank.getFluid() != null ? (int)((float)this.tank.getFluid().getAmount() / (float)this.tank.getCapacity() * (float)scale) : 0;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.tank_holder.cast();
        }
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.itemholder.cast();
        }
        return super.getCapability(capability, facing);
    }

    public Container createMenu(int windowID, PlayerInventory playerInventory, PlayerEntity player) {
        return new ContainerAbsorptionHopper(windowID, playerInventory, new PacketBuffer(Unpooled.buffer()).func_179255_a(this.field_174879_c));
    }

    public ITextComponent func_145748_c_() {
        return new StringTextComponent("Absorption Hopper");
    }

    public static enum EnumStatus implements IStringSerializable
    {
        STATUS_NONE("none"),
        STATUS_OUTPUT_ITEM("item"),
        STATUS_OUTPUT_FLUID("fluid");

        private final String name;

        private EnumStatus(String name) {
            this.name = name;
        }

        public String func_176610_l() {
            return this.name;
        }
    }
}

