/*
 * Decompiled with CFR 0.152.
 */
package mob_grinding_utils.tile;

import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.NonNullList;

public abstract class TileEntityInventoryHelper
extends TileEntity
implements ISidedInventory {
    private NonNullList<ItemStack> inventory;

    public TileEntityInventoryHelper(TileEntityType<?> tileEntityTypeIn, int invtSize) {
        super(tileEntityTypeIn);
        this.inventory = NonNullList.func_191197_a((int)invtSize, (Object)ItemStack.field_190927_a);
    }

    public int func_70302_i_() {
        return this.inventory.size();
    }

    public ItemStack func_70301_a(int slot) {
        return (ItemStack)this.inventory.get(slot);
    }

    protected NonNullList<ItemStack> getItems() {
        return this.inventory;
    }

    public ItemStack func_70298_a(int index, int count) {
        ItemStack itemstack = ItemStackHelper.func_188382_a(this.inventory, (int)index, (int)count);
        if (!itemstack.func_190926_b()) {
            this.func_70296_d();
        }
        return itemstack;
    }

    public void func_70299_a(int index, @Nullable ItemStack stack) {
        this.inventory.set(index, (Object)stack);
        if (stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        this.func_70296_d();
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(PlayerEntity player) {
        return true;
    }

    public boolean func_191420_l() {
        for (ItemStack itemstack : this.inventory) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        this.loadFromNbt(compound);
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        return this.saveToNbt(compound);
    }

    public void loadFromNbt(CompoundNBT compound) {
        this.inventory = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        if (compound.func_150297_b("Items", 9)) {
            ItemStackHelper.func_191283_b((CompoundNBT)compound, this.inventory);
        }
    }

    public CompoundNBT saveToNbt(CompoundNBT compound) {
        ItemStackHelper.func_191281_a((CompoundNBT)compound, this.inventory, (boolean)false);
        return compound;
    }

    public void func_174889_b(PlayerEntity playerIn) {
    }

    public void func_174886_c(PlayerEntity playerIn) {
    }

    public void func_174888_l() {
        this.inventory.clear();
    }

    public boolean canInsertItem() {
        return false;
    }
}

