/*
 * Decompiled with CFR 0.152.
 */
package mob_grinding_utils.tile;

import java.util.Iterator;
import java.util.List;
import mob_grinding_utils.MobGrindingUtils;
import mob_grinding_utils.ModBlocks;
import mob_grinding_utils.network.MessageTapParticle;
import mob_grinding_utils.tile.TileEntityTank;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.network.PacketDistributor;

public class TileEntitySinkTank
extends TileEntityTank {
    public TileEntitySinkTank() {
        super(ModBlocks.TANK_SINK_TILE);
    }

    @Override
    public void func_73660_a() {
        if (this.func_145831_w().field_72995_K) {
            return;
        }
        if (this.tank.getFluid().isEmpty() || this.tank.getFluid().containsFluid(new FluidStack(ModBlocks.FLUID_XP, 1))) {
            this.captureDroppedXP();
        }
        super.func_73660_a();
    }

    public boolean captureDroppedXP() {
        Iterator<PlayerEntity> iterator = this.getCaptureXP(this.func_145831_w(), (double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5).iterator();
        if (iterator.hasNext()) {
            PlayerEntity player = iterator.next();
            int xpAmount = TileEntitySinkTank.getPlayerXP(player);
            if (xpAmount <= 0) {
                return false;
            }
            if (this.tank.getFluidAmount() < this.tank.getCapacity()) {
                this.tank.fill(new FluidStack(ModBlocks.FLUID_XP, 20), IFluidHandler.FluidAction.EXECUTE);
                TileEntitySinkTank.addPlayerXP(player, -1);
                this.func_145831_w().func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_187615_H, SoundCategory.NEUTRAL, 0.1f, 0.5f * ((this.func_145831_w().field_73012_v.nextFloat() - this.func_145831_w().field_73012_v.nextFloat()) * 0.7f + 1.8f));
                MobGrindingUtils.NETWORK_WRAPPER.send(PacketDistributor.ALL.noArg(), (Object)new MessageTapParticle(this.func_174877_v().func_177984_a()));
            }
            return true;
        }
        return false;
    }

    public List<PlayerEntity> getCaptureXP(World world, double x, double y, double z) {
        return world.func_175647_a(PlayerEntity.class, new AxisAlignedBB(x - 0.45, y - 0.5, z - 0.45, x + 0.45, y + 1.03, z + 0.45), EntityPredicates.field_94557_a);
    }

    public static void addPlayerXP(PlayerEntity player, int amount) {
        int experience;
        player.field_71067_cb = experience = TileEntitySinkTank.getPlayerXP(player) + amount;
        player.field_71068_ca = TileEntitySinkTank.getLevelForExperience(experience);
        int expForLevel = TileEntitySinkTank.getExperienceForLevel(player.field_71068_ca);
        player.field_71106_cc = (float)(experience - expForLevel) / (float)player.func_71050_bK();
    }

    public static int getPlayerXP(PlayerEntity player) {
        return (int)((float)TileEntitySinkTank.getExperienceForLevel(player.field_71068_ca) + player.field_71106_cc * (float)player.func_71050_bK());
    }

    public static int getLevelForExperience(int experience) {
        int i = 0;
        while (TileEntitySinkTank.getExperienceForLevel(i) <= experience) {
            ++i;
        }
        return i - 1;
    }

    public static int getExperienceForLevel(int level) {
        if (level == 0) {
            return 0;
        }
        if (level > 0 && level < 17) {
            return (int)(Math.pow(level, 2.0) + (double)(6 * level));
        }
        if (level > 16 && level < 32) {
            return (int)(2.5 * Math.pow(level, 2.0) - 40.5 * (double)level + 360.0);
        }
        return (int)(4.5 * Math.pow(level, 2.0) - 162.5 * (double)level + 2220.0);
    }
}

