/*
 * Decompiled with CFR 0.152.
 */
package mob_grinding_utils.tile;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mob_grinding_utils.ModBlocks;
import mob_grinding_utils.tile.TileEntitySinkTank;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class TileEntityTank
extends TileEntity
implements ITickableTileEntity {
    public FluidTank tank = new FluidTank(32000);
    private final LazyOptional<IFluidHandler> tank_holder = LazyOptional.of(() -> this.tank);
    public int prevTankAmount;

    public TileEntityTank() {
        super(ModBlocks.TANK_TILE);
    }

    public TileEntityTank(TileEntityType<TileEntitySinkTank> TANK_SINK_TILE) {
        super(TANK_SINK_TILE);
    }

    public void func_73660_a() {
        if (this.func_145831_w().field_72995_K) {
            return;
        }
        if (this.prevTankAmount != this.tank.getFluidAmount()) {
            this.updateBlock();
        }
        this.prevTankAmount = this.tank.getFluidAmount();
    }

    public void updateBlock() {
        this.func_145831_w().func_184138_a(this.field_174879_c, this.func_145831_w().func_180495_p(this.field_174879_c), this.func_145831_w().func_180495_p(this.field_174879_c), 3);
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket packet) {
        super.onDataPacket(net, packet);
        this.func_230337_a_(this.func_195044_w(), packet.func_148857_g());
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        CompoundNBT nbt = new CompoundNBT();
        this.func_189515_b(nbt);
        return new SUpdateTileEntityPacket(this.func_174877_v(), 0, nbt);
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT nbt = new CompoundNBT();
        return this.func_189515_b(nbt);
    }

    public void func_230337_a_(BlockState state, CompoundNBT tagCompound) {
        super.func_230337_a_(state, tagCompound);
        this.tank.readFromNBT(tagCompound);
    }

    public CompoundNBT func_189515_b(CompoundNBT tagCompound) {
        super.func_189515_b(tagCompound);
        this.tank.writeToNBT(tagCompound);
        return tagCompound;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.tank_holder.cast();
        }
        return super.getCapability(capability, facing);
    }

    public FluidTank getTank() {
        return this.tank;
    }

    public int getScaledFluid(int scale) {
        return this.tank.getFluid() != null ? (int)((float)this.tank.getFluidAmount() / (float)this.tank.getCapacity() * (float)scale) : 0;
    }
}

