/*
 * Decompiled with CFR 0.152.
 */
package mob_grinding_utils.blocks;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mob_grinding_utils.tile.TileEntityXPSolidifier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.network.NetworkHooks;

public class BlockXPSolidifier
extends BaseEntityBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;

    public BlockXPSolidifier(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Nullable
    public BlockEntity m_142194_(@Nonnull BlockPos pos, @Nonnull BlockState state) {
        return new TileEntityXPSolidifier(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        return TileEntityXPSolidifier::tick;
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Direction direction = context.m_8125_().m_122424_();
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)direction);
    }

    public void m_5707_(Level world, BlockPos pos, BlockState state, Player player) {
        TileEntityXPSolidifier tile;
        if (!world.f_46443_ && !player.m_150110_().f_35937_ && (tile = (TileEntityXPSolidifier)world.m_7702_(pos)) != null) {
            CompoundTag nbt = new CompoundTag();
            tile.m_183515_(nbt);
            ItemStack stack = new ItemStack((ItemLike)Item.m_41439_((Block)this), 1);
            if (tile.tank.getFluidAmount() > 0) {
                stack.m_41751_(nbt);
            }
            Containers.m_18992_((Level)world, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)stack);
            if (!tile.inputSlots.getStackInSlot(0).m_41619_()) {
                Containers.m_18992_((Level)world, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)tile.inputSlots.getStackInSlot(0));
            }
            if (!tile.inputSlots.getStackInSlot(1).m_41619_()) {
                Containers.m_18992_((Level)world, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)tile.inputSlots.getStackInSlot(1));
            }
            if (!tile.outputSlot.getStackInSlot(0).m_41619_()) {
                Containers.m_18992_((Level)world, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)tile.outputSlot.getStackInSlot(0));
            }
            world.m_46747_(pos);
        }
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        BlockEntity tileentity;
        super.m_6402_(world, pos, state, placer, stack);
        if (!world.f_46443_ && stack.m_41782_() && (tileentity = world.m_7702_(pos)) instanceof TileEntityXPSolidifier && !stack.m_41783_().m_128441_("Empty")) {
            FluidStack fluid = FluidStack.loadFluidStackFromNBT((CompoundTag)stack.m_41783_());
            ((TileEntityXPSolidifier)tileentity).tank.fill(fluid, IFluidHandler.FluidAction.EXECUTE);
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (world.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity tileentity = world.m_7702_(pos);
        if (tileentity instanceof TileEntityXPSolidifier) {
            if (!player.m_21120_(hand).m_41619_() && player.m_21120_(hand).m_41720_() instanceof BucketItem) {
                LazyOptional fluidHandler = tileentity.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, hit.m_82434_());
                fluidHandler.ifPresent(handler -> {
                    if (player.m_21120_(hand).m_41619_() && !handler.getFluidInTank(0).isEmpty()) {
                        player.m_5661_((Component)new TranslatableComponent(handler.getFluidInTank(0).getDisplayName().getString() + ": " + handler.getFluidInTank(0).getAmount() + "/" + handler.getTankCapacity(0)), true);
                    } else {
                        FluidUtil.interactWithFluidHandler((Player)player, (InteractionHand)hand, (Level)world, (BlockPos)pos, (Direction)hit.m_82434_());
                    }
                });
                return InteractionResult.SUCCESS;
            }
            NetworkHooks.openGui((ServerPlayer)((ServerPlayer)player), (MenuProvider)((TileEntityXPSolidifier)tileentity), (BlockPos)pos);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }
}

