/*
 * Decompiled with CFR 0.152.
 */
package mob_grinding_utils.client.render;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import mob_grinding_utils.client.ModelLayers;
import mob_grinding_utils.models.ModelXPSolidifier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;

@OnlyIn(value=Dist.CLIENT)
public class TileXPSolidifierStackItemRenderer
extends BlockEntityWithoutLevelRenderer {
    private static final ResourceLocation TEXTURE = new ResourceLocation("mob_grinding_utils:textures/tiles/xp_solidifier_no_push.png");
    private final ModelXPSolidifier xp_solidifier_model;
    private FluidStack fluidStack;

    public TileXPSolidifierStackItemRenderer(BlockEntityRenderDispatcher renderer, EntityModelSet modelSet) {
        super(renderer, modelSet);
        EntityModelSet EntityModelSetThatIsntNULL = Minecraft.m_91087_().m_167973_();
        this.xp_solidifier_model = new ModelXPSolidifier(EntityModelSetThatIsntNULL.m_171103_(ModelLayers.XPSOLIDIFIER));
    }

    public void m_108829_(ItemStack stack, ItemTransforms.TransformType transformType, PoseStack matrixStack, MultiBufferSource bufferIn, int combinedLight, int combinedOverlayIn) {
        matrixStack.m_85836_();
        matrixStack.m_85837_(0.5, 1.5, 0.5);
        matrixStack.m_85841_(-0.9999f, -0.9999f, 0.9999f);
        RenderSystem.m_69478_();
        RenderSystem.m_69416_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        this.xp_solidifier_model.m_7695_(matrixStack, bufferIn.m_6299_(RenderType.m_110476_((ResourceLocation)TEXTURE)), combinedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        this.xp_solidifier_model.renderExport(matrixStack, bufferIn.m_6299_(RenderType.m_110476_((ResourceLocation)TEXTURE)), combinedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        this.xp_solidifier_model.renderRack(matrixStack, bufferIn.m_6299_(RenderType.m_110476_((ResourceLocation)TEXTURE)), combinedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        RenderSystem.m_69461_();
        RenderSystem.m_69453_();
        matrixStack.m_85849_();
        if (!stack.m_41782_() || stack.m_41783_().m_128441_("Empty")) {
            return;
        }
        this.fluidStack = FluidStack.loadFluidStackFromNBT((CompoundTag)stack.m_41783_());
        float fluidLevel = this.fluidStack.getAmount();
        if (fluidLevel < 1.0f) {
            return;
        }
        float tankMax = 16000.0f;
        float height = 0.46875f / tankMax * fluidLevel;
        TextureAtlasSprite fluidStillSprite = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(this.fluidStack.getFluid().getAttributes().getStillTexture());
        VertexConsumer buffer = bufferIn.m_6299_(RenderType.m_110466_());
        int fluidColor = this.fluidStack.getFluid().getAttributes().getColor();
        matrixStack.m_85836_();
        matrixStack.m_85837_(0.0, 0.0, 0.0);
        float yMin = 0.0f;
        float xMax = 1.984375f;
        float zMax = 1.984375f;
        float xMin = 0.015625f;
        float zMin = 0.015625f;
        yMin = 0.015625f;
        float alpha = 1.0f;
        float red = (float)(fluidColor >> 16 & 0xFF) / 255.0f;
        float green = (float)(fluidColor >> 8 & 0xFF) / 255.0f;
        float blue = (float)(fluidColor & 0xFF) / 255.0f;
        this.renderCuboid(buffer, matrixStack, xMax, xMin, yMin, height, zMin, zMax, fluidStillSprite, red, green, blue, alpha, combinedLight);
        matrixStack.m_85849_();
    }

    private void renderCuboid(VertexConsumer buffer, PoseStack matrixStack, float xMax, float xMin, float yMin, float height, float zMin, float zMax, TextureAtlasSprite textureAtlasSprite, float red, float green, float blue, float alpha, int combinedLight) {
        float uMin = textureAtlasSprite.m_118409_();
        float uMax = textureAtlasSprite.m_118410_();
        float vMin = textureAtlasSprite.m_118411_();
        float vMax = textureAtlasSprite.m_118412_();
        float vHeight = vMax - vMin;
        this.addVertexWithUV(buffer, matrixStack, xMax, height, zMax, uMax, vMin, red, green, blue, alpha, combinedLight);
        this.addVertexWithUV(buffer, matrixStack, xMax, height, zMin, uMin, vMin, red, green, blue, alpha, combinedLight);
        this.addVertexWithUV(buffer, matrixStack, xMin, height, zMin, uMin, vMax, red, green, blue, alpha, combinedLight);
        this.addVertexWithUV(buffer, matrixStack, xMin, height, zMax, uMax, vMax, red, green, blue, alpha, combinedLight);
        this.addVertexWithUV(buffer, matrixStack, xMax, yMin, zMin, uMax, vMin, red, green, blue, alpha, combinedLight);
        this.addVertexWithUV(buffer, matrixStack, xMin, yMin, zMin, uMin, vMin, red, green, blue, alpha, combinedLight);
        this.addVertexWithUV(buffer, matrixStack, xMin, height, zMin, uMin, vMin + vHeight * height, red, green, blue, alpha, combinedLight);
        this.addVertexWithUV(buffer, matrixStack, xMax, height, zMin, uMax, vMin + vHeight * height, red, green, blue, alpha, combinedLight);
        this.addVertexWithUV(buffer, matrixStack, xMax, yMin, zMax, uMin, vMin, red, green, blue, alpha, combinedLight);
        this.addVertexWithUV(buffer, matrixStack, xMax, height, zMax, uMin, vMin + vHeight * height, red, green, blue, alpha, combinedLight);
        this.addVertexWithUV(buffer, matrixStack, xMin, height, zMax, uMax, vMin + vHeight * height, red, green, blue, alpha, combinedLight);
        this.addVertexWithUV(buffer, matrixStack, xMin, yMin, zMax, uMax, vMin, red, green, blue, alpha, combinedLight);
        this.addVertexWithUV(buffer, matrixStack, xMax, yMin, zMin, uMin, vMin, red, green, blue, alpha, combinedLight);
        this.addVertexWithUV(buffer, matrixStack, xMax, height, zMin, uMin, vMin + vHeight * height, red, green, blue, alpha, combinedLight);
        this.addVertexWithUV(buffer, matrixStack, xMax, height, zMax, uMax, vMin + vHeight * height, red, green, blue, alpha, combinedLight);
        this.addVertexWithUV(buffer, matrixStack, xMax, yMin, zMax, uMax, vMin, red, green, blue, alpha, combinedLight);
        this.addVertexWithUV(buffer, matrixStack, xMin, yMin, zMax, uMin, vMin, red, green, blue, alpha, combinedLight);
        this.addVertexWithUV(buffer, matrixStack, xMin, height, zMax, uMin, vMin + vHeight * height, red, green, blue, alpha, combinedLight);
        this.addVertexWithUV(buffer, matrixStack, xMin, height, zMin, uMax, vMin + vHeight * height, red, green, blue, alpha, combinedLight);
        this.addVertexWithUV(buffer, matrixStack, xMin, yMin, zMin, uMax, vMin, red, green, blue, alpha, combinedLight);
        this.addVertexWithUV(buffer, matrixStack, xMax, yMin, zMin, uMax, vMin, red, green, blue, alpha, combinedLight);
        this.addVertexWithUV(buffer, matrixStack, xMax, yMin, zMax, uMin, vMin, red, green, blue, alpha, combinedLight);
        this.addVertexWithUV(buffer, matrixStack, xMin, yMin, zMax, uMin, vMax, red, green, blue, alpha, combinedLight);
        this.addVertexWithUV(buffer, matrixStack, xMin, yMin, zMin, uMax, vMax, red, green, blue, alpha, combinedLight);
    }

    private void addVertexWithUV(VertexConsumer buffer, PoseStack matrixStack, float x, float y, float z, float u, float v, float red, float green, float blue, float alpha, int combinedLight) {
        buffer.m_85982_(matrixStack.m_85850_().m_85861_(), x / 2.0f, y, z / 2.0f).m_85950_(red, green, blue, alpha).m_7421_(u, v).m_7120_(combinedLight, 240).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
    }
}

