/*
 * Decompiled with CFR 0.152.
 */
package mob_grinding_utils.events;

import com.mojang.authlib.GameProfile;
import java.util.Collection;
import java.util.Optional;
import mob_grinding_utils.items.ItemImaginaryInvisibleNotReallyThereSword;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.WitherSkeleton;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;

public class EntityHeadDropEvent {
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void dropEvent(LivingDropsEvent event) {
        FakePlayer fakePlayer;
        if (event.getEntityLiving().m_20193_().f_46443_) {
            return;
        }
        if (event.getEntityLiving().m_21223_() > 0.0f) {
            return;
        }
        int beheadingLevel = 0;
        if (event.getSource().m_7639_() instanceof FakePlayer && (fakePlayer = (FakePlayer)event.getSource().m_7639_()).m_5446_().getString().matches(new TranslatableComponent("fakeplayer.mob_masher").getString()) && fakePlayer.m_21205_().m_41720_() instanceof ItemImaginaryInvisibleNotReallyThereSword) {
            ItemStack stack;
            int dropChance;
            ItemStack tempSword = fakePlayer.m_21205_();
            if (tempSword.m_41782_() && tempSword.m_41783_().m_128441_("beheadingValue")) {
                beheadingLevel = tempSword.m_41783_().m_128451_("beheadingValue");
            }
            if ((dropChance = event.getEntityLiving().m_20193_().f_46441_.nextInt(10)) < beheadingLevel && !(stack = EntityHeadDropEvent.getHeadfromEntity(event.getEntityLiving())).m_41619_()) {
                this.addDrop(stack, event.getEntityLiving(), event.getDrops());
            }
        }
    }

    public static ItemStack getHeadfromEntity(LivingEntity target) {
        if (target.m_6162_()) {
            return ItemStack.f_41583_;
        }
        if (target instanceof Mob && ModList.get().isLoaded("player_mobs") && EntityHeadDropEvent.isPlayerMob((Entity)target)) {
            return EntityHeadDropEvent.createHeadFor(EntityHeadDropEvent.getPlayerByUsername(target.m_7755_().getString()));
        }
        if (target instanceof Creeper) {
            return new ItemStack((ItemLike)Items.f_42682_, 1);
        }
        if (target instanceof Skeleton) {
            return new ItemStack((ItemLike)Items.f_42678_, 1);
        }
        if (target instanceof WitherSkeleton) {
            return new ItemStack((ItemLike)Items.f_42679_, 1);
        }
        if (target instanceof Zombie) {
            return new ItemStack((ItemLike)Items.f_42681_, 1);
        }
        if (target instanceof Player) {
            return EntityHeadDropEvent.createHeadFor((Player)target);
        }
        if (target instanceof EnderDragon) {
            return new ItemStack((ItemLike)Items.f_42683_, 1);
        }
        return ItemStack.f_41583_;
    }

    public static boolean isPlayerMob(Entity entity) {
        Optional entityMob = EntityType.m_20632_((String)"player_mobs:player_mob");
        return entityMob.isPresent() && ((EntityType)entityMob.get()).equals(entity.m_6095_());
    }

    public static GameProfile getPlayerByUsername(String name) {
        return new GameProfile(null, name);
    }

    public static ItemStack createHeadFor(Player player) {
        return EntityHeadDropEvent.createHeadFor(player.m_36316_());
    }

    public static ItemStack createHeadFor(GameProfile profile) {
        ItemStack stack = new ItemStack((ItemLike)Items.f_42680_, 1);
        stack.m_41751_(new CompoundTag());
        CompoundTag profileData = new CompoundTag();
        NbtUtils.m_129230_((CompoundTag)profileData, (GameProfile)profile);
        stack.m_41783_().m_128365_("SkullOwner", (Tag)profileData);
        return stack;
    }

    private void addDrop(ItemStack stack, LivingEntity entity, Collection<ItemEntity> collection) {
        if (stack.m_41613_() <= 0) {
            return;
        }
        ItemEntity entityItem = new ItemEntity(entity.m_20193_(), entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), stack);
        entityItem.m_32060_();
        collection.add(entityItem);
    }
}

