/*
 * Decompiled with CFR 0.152.
 */
package mob_grinding_utils.inventory.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.ArrayList;
import java.util.Optional;
import javax.annotation.Nonnull;
import mob_grinding_utils.MobGrindingUtils;
import mob_grinding_utils.inventory.client.GuiMGUButton;
import mob_grinding_utils.inventory.server.ContainerXPSolidifier;
import mob_grinding_utils.network.MessageSolidifier;
import mob_grinding_utils.tile.TileEntityXPSolidifier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.InventoryMenu;

public class GuiXPSolidifier
extends AbstractContainerScreen<ContainerXPSolidifier> {
    private static final ResourceLocation GUI_TEX = new ResourceLocation("mob_grinding_utils:textures/gui/solidifier_gui.png");
    protected final ContainerXPSolidifier container;
    private final TileEntityXPSolidifier tile;

    public GuiXPSolidifier(ContainerXPSolidifier screenContainer, Inventory inv, Component titleIn) {
        super((AbstractContainerMenu)screenContainer, inv, titleIn);
        this.container = screenContainer;
        this.tile = this.container.tile;
        this.f_97727_ = 186;
        this.f_97726_ = 176;
    }

    protected void m_7856_() {
        super.m_7856_();
        int xOffSet = (this.f_96543_ - this.f_97726_) / 2;
        int yOffSet = (this.f_96544_ - this.f_97727_) / 2;
        this.m_142416_((GuiEventListener)new GuiMGUButton(xOffSet + 62, yOffSet + 72, GuiMGUButton.Size.SOLIDIFIER, 0, (Component)new TextComponent("Push"), button -> MobGrindingUtils.NETWORK_WRAPPER.sendToServer((Object)new MessageSolidifier(0, this.tile.m_58899_()))));
        this.m_142416_((GuiEventListener)new GuiMGUButton(xOffSet + 148, yOffSet + 8, GuiMGUButton.Size.SOLIDIFIER_ON, 0, (Component)new TextComponent(""), button -> MobGrindingUtils.NETWORK_WRAPPER.sendToServer((Object)new MessageSolidifier(1, this.tile.m_58899_()))));
    }

    protected void m_7027_(@Nonnull PoseStack matrixStack, int x, int y) {
        this.f_96547_.m_92883_(matrixStack, I18n.m_118938_((String)"block.mob_grinding_utils.xpsolidifier", (Object[])new Object[0]), 7.0f, 6.0f, 0x404040);
        this.f_96547_.m_92883_(matrixStack, I18n.m_118938_((String)"container.inventory", (Object[])new Object[0]), 8.0f, (float)(this.f_97727_ - 96 + 2), 0x404040);
        this.f_96547_.m_92750_(matrixStack, this.tile.isOn ? "On" : "Off", 158.0f - (float)this.f_96547_.m_92895_(this.tile.isOn ? "On" : "Off") / 2.0f, 12.0f, 0xE0E0E0);
    }

    protected void m_7286_(@Nonnull PoseStack stack, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)GUI_TEX);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int xOffSet = (this.f_96543_ - this.f_97726_) / 2;
        int yOffSet = (this.f_96544_ - this.f_97727_) / 2;
        boolean zLevel = false;
        this.m_93228_(stack, xOffSet, yOffSet, 0, 0, this.f_97726_, this.f_97727_);
        this.f_96547_.m_92883_(stack, this.tile.outputDirection.m_7912_(), (float)(xOffSet + 124) - (float)this.f_96547_.m_92895_(this.tile.outputDirection.m_7912_()) / 2.0f, (float)(yOffSet + 76), 5285857);
        int fluid = this.tile.getScaledFluid(70);
        if (fluid >= 1) {
            TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(this.tile.tank.getFluid().getFluid().getAttributes().getStillTexture());
            Tesselator tessellator = Tesselator.m_85913_();
            BufferBuilder buffer = tessellator.m_85915_();
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            RenderSystem.m_157456_((int)0, (ResourceLocation)InventoryMenu.f_39692_);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
            buffer.m_5483_((double)(xOffSet + 8), (double)(yOffSet + 88), (double)zLevel).m_7421_(sprite.m_118409_(), sprite.m_118411_()).m_5752_();
            buffer.m_5483_((double)(xOffSet + 20), (double)(yOffSet + 88), (double)zLevel).m_7421_(sprite.m_118410_(), sprite.m_118411_()).m_5752_();
            buffer.m_5483_((double)(xOffSet + 20), (double)(yOffSet + 88 - fluid), (double)zLevel).m_7421_(sprite.m_118410_(), sprite.m_118412_()).m_5752_();
            buffer.m_5483_((double)(xOffSet + 8), (double)(yOffSet + 88 - fluid), (double)zLevel).m_7421_(sprite.m_118409_(), sprite.m_118412_()).m_5752_();
            tessellator.m_85914_();
        }
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)GUI_TEX);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.m_93228_(stack, xOffSet + 7, yOffSet + 17, 178, 0, 6, 71);
        this.m_93228_(stack, xOffSet + 91, yOffSet + 36, 178, 73, this.tile.getProgressScaled(24), 17);
    }

    public void m_6305_(@Nonnull PoseStack stack, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(stack);
        super.m_6305_(stack, mouseX, mouseY, partialTicks);
        this.m_7025_(stack, mouseX, mouseY);
    }

    protected void m_7025_(@Nonnull PoseStack matrixStack, int x, int y) {
        super.m_7025_(matrixStack, x, y);
        int xOffSet = (this.f_96543_ - this.f_97726_) / 2;
        int yOffSet = (this.f_96544_ - this.f_97727_) / 2;
        if (x > xOffSet + 8 && x < xOffSet + 20 && y > yOffSet + 20 && y < yOffSet + 88) {
            ArrayList<Object> tooltip = new ArrayList<Object>();
            tooltip.add(this.tile.tank.getFluid().getDisplayName());
            tooltip.add(new TextComponent(this.tile.tank.getFluidAmount() + "/" + this.tile.tank.getCapacity()));
            this.renderTooltip(matrixStack, tooltip, Optional.empty(), x, y, this.f_96547_);
        }
    }
}

