/*
 * Decompiled with CFR 0.152.
 */
package mob_grinding_utils.tile;

import java.util.Iterator;
import java.util.List;
import mob_grinding_utils.MobGrindingUtils;
import mob_grinding_utils.ModBlocks;
import mob_grinding_utils.network.MessageTapParticle;
import mob_grinding_utils.tile.TileEntityTank;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.network.PacketDistributor;

public class TileEntitySinkTank
extends TileEntityTank {
    public TileEntitySinkTank(BlockPos pos, BlockState state) {
        super(ModBlocks.TANK_SINK.getTileEntityType(), pos, state);
    }

    public static <T extends BlockEntity> void serverTick(Level world, BlockPos worldPosition, BlockState blockState, T t) {
        if (t instanceof TileEntitySinkTank) {
            TileEntitySinkTank tile = (TileEntitySinkTank)t;
            if (tile.tank.getFluid().isEmpty() || tile.tank.getFluid().containsFluid(new FluidStack((Fluid)ModBlocks.FLUID_XP.get(), 1))) {
                tile.captureDroppedXP();
            }
            TileEntityTank.serverTick(world, worldPosition, blockState, t);
        }
    }

    public boolean captureDroppedXP() {
        Iterator<Player> iterator = this.getCaptureXP(this.f_58857_, (double)this.m_58899_().m_123341_() + 0.5, (double)this.m_58899_().m_123342_() + 0.5, (double)this.m_58899_().m_123343_() + 0.5).iterator();
        if (iterator.hasNext()) {
            Player player = iterator.next();
            int xpAmount = TileEntitySinkTank.getPlayerXP(player);
            if (xpAmount <= 0) {
                return false;
            }
            if (this.tank.getFluidAmount() < this.tank.getCapacity()) {
                this.tank.fill(new FluidStack((Fluid)ModBlocks.FLUID_XP.get(), 20), IFluidHandler.FluidAction.EXECUTE);
                TileEntitySinkTank.addPlayerXP(player, -1);
                this.f_58857_.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11770_, SoundSource.NEUTRAL, 0.1f, 0.5f * ((this.m_58904_().f_46441_.nextFloat() - this.m_58904_().f_46441_.nextFloat()) * 0.7f + 1.8f));
                MobGrindingUtils.NETWORK_WRAPPER.send(PacketDistributor.ALL.noArg(), (Object)new MessageTapParticle(this.m_58899_().m_7494_()));
            }
            return true;
        }
        return false;
    }

    public List<Player> getCaptureXP(Level world, double x, double y, double z) {
        return world.m_6443_(Player.class, new AABB(x - 0.45, y - 0.5, z - 0.45, x + 0.45, y + 1.03, z + 0.45), EntitySelector.f_20402_);
    }

    public static void addPlayerXP(Player player, int amount) {
        int experience;
        player.f_36079_ = experience = TileEntitySinkTank.getPlayerXP(player) + amount;
        player.f_36078_ = TileEntitySinkTank.getLevelForExperience(experience);
        int expForLevel = TileEntitySinkTank.getExperienceForLevel(player.f_36078_);
        player.f_36080_ = (float)(experience - expForLevel) / (float)player.m_36323_();
    }

    public static int getPlayerXP(Player player) {
        return TileEntitySinkTank.getExperienceForLevel(player.f_36078_) + (int)(player.f_36080_ * (float)player.m_36323_());
    }

    public static int getLevelForExperience(int experience) {
        int i = 0;
        while (TileEntitySinkTank.getExperienceForLevel(i) <= experience) {
            ++i;
        }
        return i - 1;
    }

    public static int getExperienceForLevel(int level) {
        if (level == 0) {
            return 0;
        }
        if (level > 0 && level < 17) {
            return (int)(Math.pow(level, 2.0) + (double)(6 * level));
        }
        if (level > 16 && level < 32) {
            return (int)(2.5 * Math.pow(level, 2.0) - 40.5 * (double)level + 360.0);
        }
        return (int)(4.5 * Math.pow(level, 2.0) - 162.5 * (double)level + 2220.0);
    }
}

