/*
 * Decompiled with CFR 0.152.
 */
package mob_grinding_utils.tile;

import io.netty.buffer.Unpooled;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mob_grinding_utils.MobGrindingUtils;
import mob_grinding_utils.ModBlocks;
import mob_grinding_utils.ModItems;
import mob_grinding_utils.inventory.server.ContainerXPSolidifier;
import mob_grinding_utils.recipe.SolidifyRecipe;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;

public class TileEntityXPSolidifier
extends BlockEntity
implements MenuProvider {
    public FluidTank tank = new FluidTank(16000);
    private final LazyOptional<IFluidHandler> tank_holder = LazyOptional.of(() -> this.tank);
    private int prevFluidLevel = 0;
    public int moulding_progress = 0;
    public int MAX_MOULDING_TIME = 100;
    public boolean isOn = false;
    private SolidifyRecipe currentRecipe = null;
    public ItemStackHandler inputSlots = new ItemStackHandler(2);
    public ItemStackHandler outputSlot = new ItemStackHandler(1);
    private final LazyOptional<IItemHandler> outputCap = LazyOptional.of(() -> this.outputSlot);
    public boolean active;
    public int animationTicks;
    public int prevAnimationTicks;
    public OutputDirection outputDirection = OutputDirection.NONE;

    public TileEntityXPSolidifier(BlockPos pos, BlockState state) {
        super(ModBlocks.XPSOLIDIFIER.getTileEntityType(), pos, state);
    }

    public OutputDirection toggleOutput() {
        switch (this.outputDirection) {
            case WEST: {
                this.outputDirection = OutputDirection.NONE;
                break;
            }
            case SOUTH: {
                this.outputDirection = OutputDirection.WEST;
                break;
            }
            case EAST: {
                this.outputDirection = OutputDirection.SOUTH;
                break;
            }
            case NORTH: {
                this.outputDirection = OutputDirection.EAST;
                break;
            }
            case NONE: {
                this.outputDirection = OutputDirection.NORTH;
            }
        }
        this.m_6596_();
        return this.outputDirection;
    }

    public void toggleOnOff() {
        this.isOn = !this.isOn;
    }

    public static <T extends BlockEntity> void tick(Level level, BlockPos worldPosition, BlockState blockState, T t) {
        if (t instanceof TileEntityXPSolidifier) {
            TileEntityXPSolidifier tile = (TileEntityXPSolidifier)t;
            if (tile.isOn) {
                if (level.f_46443_ && tile.active) {
                    tile.prevAnimationTicks = tile.animationTicks;
                    if (tile.animationTicks < tile.MAX_MOULDING_TIME) {
                        tile.animationTicks += 1 + tile.getModifierAmount();
                    }
                    if (tile.animationTicks >= tile.MAX_MOULDING_TIME) {
                        tile.animationTicks -= tile.MAX_MOULDING_TIME;
                        tile.prevAnimationTicks -= tile.MAX_MOULDING_TIME;
                    }
                }
                if (level.f_46443_ && !tile.active) {
                    tile.animationTicks = 0;
                    tile.prevAnimationTicks = 0;
                }
                if (tile.currentRecipe != null) {
                    if (!tile.currentRecipe.matches(tile.inputSlots.getStackInSlot(0))) {
                        tile.currentRecipe = null;
                    }
                } else if (!tile.inputSlots.getStackInSlot(0).m_41619_()) {
                    tile.currentRecipe = TileEntityXPSolidifier.getRecipeForMould(tile.inputSlots.getStackInSlot(0));
                }
                if (tile.hasfluid() && tile.canOperate()) {
                    tile.setActive(true);
                    tile.setProgress(tile.getProgress() + 1 + tile.getModifierAmount());
                    if (tile.getProgress() >= tile.MAX_MOULDING_TIME) {
                        tile.setActive(false);
                        tile.outputSlot.setStackInSlot(0, tile.currentRecipe.getResult());
                        tile.tank.drain(tile.currentRecipe.getFluidAmount(), IFluidHandler.FluidAction.EXECUTE);
                        return;
                    }
                } else if (tile.getProgress() > 0) {
                    tile.setProgress(0);
                    tile.setActive(false);
                }
                if (tile.outputDirection != OutputDirection.NONE && tile.getOutputFacing() != null) {
                    BlockEntity otherTile = level.m_7702_(worldPosition.m_142300_(tile.getOutputFacing()));
                    if (otherTile != null && otherTile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, tile.getOutputFacing().m_122424_()).isPresent()) {
                        LazyOptional tileOptional = otherTile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, tile.getOutputFacing().m_122424_());
                        tileOptional.ifPresent(handler -> {
                            if (!tile.outputSlot.getStackInSlot(0).m_41619_()) {
                                ItemStack stack = tile.outputSlot.getStackInSlot(0).m_41777_();
                                stack.m_41764_(1);
                                ItemStack stack1 = ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)stack, (boolean)true);
                                if (stack1.m_41619_()) {
                                    ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)tile.outputSlot.extractItem(0, 1, false), (boolean)false);
                                    tile.m_6596_();
                                }
                            }
                        });
                    } else if (otherTile instanceof Container) {
                        Container iinventory = (Container)otherTile;
                        if (tile.isInventoryFull(iinventory, tile.getOutputFacing())) {
                            return;
                        }
                        if (!tile.outputSlot.getStackInSlot(0).m_41619_()) {
                            ItemStack stack = tile.outputSlot.getStackInSlot(0).m_41777_();
                            ItemStack stack1 = TileEntityXPSolidifier.putStackInInventoryAllSlots(iinventory, tile.outputSlot.extractItem(0, 1, false), tile.getOutputFacing().m_122424_());
                            if (stack1.m_41619_() || stack1.m_41613_() == 0) {
                                iinventory.m_6596_();
                            } else {
                                tile.outputSlot.setStackInSlot(0, stack);
                            }
                        }
                    }
                }
            } else {
                if (level.f_46443_) {
                    tile.animationTicks = 0;
                    tile.prevAnimationTicks = 0;
                }
                if (tile.getProgress() > 0) {
                    tile.setActive(false);
                    tile.setProgress(0);
                }
            }
            if (tile.prevFluidLevel != tile.tank.getFluidAmount()) {
                tile.updateBlock();
                tile.prevFluidLevel = tile.tank.getFluidAmount();
            }
        }
    }

    public void setActive(boolean isActive) {
        this.active = isActive;
    }

    private Direction getOutputFacing() {
        switch (this.outputDirection) {
            case WEST: {
                return Direction.WEST;
            }
            case SOUTH: {
                return Direction.SOUTH;
            }
            case EAST: {
                return Direction.EAST;
            }
            case NORTH: {
                return Direction.NORTH;
            }
        }
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public ItemStack getCachedOutPutRenderStack() {
        if (this.hasMould() && this.inputSlots.getStackInSlot(0).m_41720_() == ModItems.SOLID_XP_MOULD_BABY.get()) {
            return new ItemStack((ItemLike)ModItems.SOLID_XP_BABY.get(), 1);
        }
        return ItemStack.f_41583_;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getProgressScaled(int count) {
        return this.getProgress() * count / this.MAX_MOULDING_TIME;
    }

    private boolean hasfluid() {
        return this.currentRecipe != null && !this.tank.getFluid().isEmpty() && this.tank.getFluid().getAmount() >= this.currentRecipe.getFluidAmount() && this.tank.getFluidInTank(0).getFluid().m_76108_(MobGrindingUtils.EXPERIENCE);
    }

    private boolean canOperate() {
        return this.hasMould() && this.isOutputEmpty();
    }

    private boolean hasMould() {
        return this.currentRecipe != null && this.currentRecipe.matches(this.inputSlots.getStackInSlot(0));
    }

    @Nullable
    public static SolidifyRecipe getRecipeForMould(ItemStack stack) {
        return MobGrindingUtils.SOLIDIFIER_RECIPES.stream().filter(recipe -> recipe.matches(stack)).findFirst().orElse(null);
    }

    private boolean isOutputEmpty() {
        return this.outputSlot.getStackInSlot(0).m_41619_();
    }

    private boolean hasUpgrade() {
        return !this.inputSlots.getStackInSlot(1).m_41619_() && this.inputSlots.getStackInSlot(1).m_41720_() == ModItems.XP_SOLIDIFIER_UPGRADE.get();
    }

    public int getModifierAmount() {
        return this.hasUpgrade() ? this.inputSlots.getStackInSlot(1).m_41613_() : 0;
    }

    private void setProgress(int counter) {
        this.moulding_progress = counter;
    }

    public int getProgress() {
        return this.moulding_progress;
    }

    private boolean isInventoryFull(Container inventoryIn, Direction side) {
        if (inventoryIn instanceof WorldlyContainer) {
            int[] aint;
            WorldlyContainer isidedinventory = (WorldlyContainer)inventoryIn;
            for (int k : aint = isidedinventory.m_7071_(side)) {
                ItemStack itemstack1 = isidedinventory.m_8020_(k);
                if (!itemstack1.m_41619_() && itemstack1.m_41613_() == itemstack1.m_41741_()) continue;
                return false;
            }
        } else {
            int i = inventoryIn.m_6643_();
            for (int j = 0; j < i; ++j) {
                ItemStack itemstack = inventoryIn.m_8020_(j);
                if (!itemstack.m_41619_() && itemstack.m_41613_() == itemstack.m_41741_()) continue;
                return false;
            }
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Lifted jumps to return sites
     */
    public static ItemStack putStackInInventoryAllSlots(Container inventory, ItemStack stack, @Nullable Direction facing) {
        if (inventory instanceof WorldlyContainer) {
            WorldlyContainer isidedinventory = (WorldlyContainer)inventory;
            if (facing != null && !(inventory instanceof TileEntityXPSolidifier) && inventory.m_7013_(0, stack.m_41777_())) {
                int[] aint = isidedinventory.m_7071_(facing);
                int k = 0;
                while (k < aint.length) {
                    if (stack.m_41619_()) return stack;
                    stack = TileEntityXPSolidifier.insertStack(inventory, stack, aint[k], facing);
                    ++k;
                }
                return stack;
            }
        }
        int i = inventory.m_6643_();
        int j = 0;
        while (j < i) {
            if (stack.m_41619_()) return stack;
            stack = TileEntityXPSolidifier.insertStack(inventory, stack, j, facing);
            ++j;
        }
        return stack;
    }

    private static boolean canInsertItemInSlot(Container inventoryIn, ItemStack stack, int index, Direction side) {
        return inventoryIn.m_7013_(index, stack) && (!(inventoryIn instanceof WorldlyContainer) || ((WorldlyContainer)inventoryIn).m_7155_(index, stack, side));
    }

    private static ItemStack insertStack(Container inventory, ItemStack stack, int index, Direction side) {
        ItemStack itemstack = inventory.m_8020_(index);
        if (TileEntityXPSolidifier.canInsertItemInSlot(inventory, stack, index, side)) {
            if (itemstack.m_41619_()) {
                inventory.m_6836_(index, stack);
                stack = ItemStack.f_41583_;
            } else if (TileEntityXPSolidifier.canCombine(itemstack, stack)) {
                int i = stack.m_41741_() - itemstack.m_41613_();
                int j = Math.min(stack.m_41613_(), i);
                stack.m_41774_(j);
                itemstack.m_41769_(j);
            }
        }
        return stack;
    }

    private static boolean canCombine(ItemStack stack1, ItemStack stack2) {
        return stack1.m_41720_() != stack2.m_41720_() ? false : (stack1.m_41773_() != stack2.m_41773_() ? false : (stack1.m_41613_() > stack1.m_41741_() ? false : ItemStack.m_41658_((ItemStack)stack1, (ItemStack)stack2)));
    }

    public void m_142466_(@Nonnull CompoundTag nbt) {
        super.m_142466_(nbt);
        this.tank.readFromNBT(nbt);
        this.inputSlots.deserializeNBT(nbt.m_128469_("inputSlots"));
        this.outputSlot.deserializeNBT(nbt.m_128469_("outputSlot"));
        this.outputDirection = OutputDirection.fromString(nbt.m_128461_("outputDirection"));
        this.isOn = nbt.m_128471_("isOn");
        this.active = nbt.m_128471_("active");
        this.moulding_progress = nbt.m_128451_("moulding_progress");
        if (nbt.m_128441_("currentRecipe")) {
            ResourceLocation id = new ResourceLocation(nbt.m_128461_("currentRecipe"));
            MobGrindingUtils.SOLIDIFIER_RECIPES.stream().filter(recipe -> recipe.m_6423_().equals((Object)id)).findFirst().ifPresent(recipe -> {
                this.currentRecipe = recipe;
            });
        }
    }

    public void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        this.tank.writeToNBT(nbt);
        nbt.m_128365_("inputSlots", (Tag)this.inputSlots.serializeNBT());
        nbt.m_128365_("outputSlot", (Tag)this.outputSlot.serializeNBT());
        nbt.m_128359_("outputDirection", this.outputDirection.m_7912_());
        nbt.m_128379_("isOn", this.isOn);
        nbt.m_128379_("active", this.active);
        nbt.m_128405_("moulding_progress", this.moulding_progress);
        if (this.currentRecipe != null) {
            nbt.m_128359_("currentRecipe", this.currentRecipe.m_6423_().toString());
        }
    }

    @Nonnull
    public CompoundTag m_5995_() {
        CompoundTag nbt = new CompoundTag();
        this.m_183515_(nbt);
        return nbt;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        CompoundTag nbt = new CompoundTag();
        this.m_183515_(nbt);
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket packet) {
        super.onDataPacket(net, packet);
        this.m_142466_(packet.m_131708_());
        this.onContentsChanged();
    }

    public void updateBlock() {
        this.m_58904_().m_7260_(this.f_58858_, this.m_58904_().m_8055_(this.f_58858_), this.m_58904_().m_8055_(this.f_58858_), 3);
    }

    public void onContentsChanged() {
        if (this.f_58857_ != null && this.f_58857_.f_46443_) {
            BlockState state = this.f_58857_.m_8055_(this.m_58899_());
            this.f_58857_.m_7260_(this.m_58899_(), state, state, 8);
            this.m_6596_();
        }
    }

    public int getScaledFluid(int scale) {
        return this.tank.getFluid() != null ? (int)((float)this.tank.getFluid().getAmount() / (float)this.tank.getCapacity() * (float)scale) : 0;
    }

    @Nonnull
    public Component m_5446_() {
        return new TextComponent("block.mob_grinding_utils.xpsolidifier");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int windowID, Inventory playerInventory, Player player) {
        return new ContainerXPSolidifier(windowID, playerInventory, new FriendlyByteBuf(Unpooled.buffer()).m_130064_(this.f_58858_));
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.tank_holder.cast();
        }
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.outputCap.cast();
        }
        return super.getCapability(cap, side);
    }

    public static enum OutputDirection implements StringRepresentable
    {
        NONE("none"),
        NORTH("north"),
        EAST("east"),
        SOUTH("south"),
        WEST("west");

        final String name;

        private OutputDirection(String nameIn) {
            this.name = nameIn;
        }

        public String m_7912_() {
            return this.name;
        }

        public static OutputDirection fromString(String string) {
            for (OutputDirection direction : OutputDirection.values()) {
                if (!direction.name.equals(string)) continue;
                return direction;
            }
            return NONE;
        }
    }
}

