/*
 * Decompiled with CFR 0.152.
 */
package mob_grinding_utils.tile;

import io.netty.buffer.Unpooled;
import java.util.List;
import javax.annotation.Nonnull;
import mob_grinding_utils.ModBlocks;
import mob_grinding_utils.ModItems;
import mob_grinding_utils.blocks.BlockFan;
import mob_grinding_utils.inventory.server.ContainerFan;
import mob_grinding_utils.items.ItemFanUpgrade;
import mob_grinding_utils.tile.TileEntityInventoryHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.util.Mth;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AirBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TileEntityFan
extends TileEntityInventoryHelper
implements MenuProvider {
    private static final int[] SLOTS = new int[]{0, 1, 2};
    public boolean showRenderBox;
    float xPos;
    float yPos;
    float zPos;
    float xNeg;
    float yNeg;
    float zNeg;

    public TileEntityFan(BlockPos pos, BlockState state) {
        super(ModBlocks.FAN.getTileEntityType(), 3, pos, state);
    }

    public static <T extends BlockEntity> void tick(Level level, BlockPos pos, BlockState blockState, T t) {
        if (t instanceof TileEntityFan) {
            TileEntityFan fan = (TileEntityFan)t;
            if (level.m_46467_() % 2L == 0L && level.m_8055_(pos).m_60734_() instanceof BlockFan && ((Boolean)level.m_8055_(pos).m_61143_((Property)BlockFan.POWERED)).booleanValue()) {
                fan.activateBlock();
            }
            if (!level.f_46443_) {
                fan.setAABBWithModifiers();
            }
        }
    }

    public int getWidthModifier() {
        return this.hasWidthUpgrade() ? ((ItemStack)this.getItems().get(0)).m_41613_() : 0;
    }

    public int getHeightModifier() {
        return this.hasHeightUpgrade() ? ((ItemStack)this.getItems().get(1)).m_41613_() : 0;
    }

    public int getSpeedModifier() {
        return this.hasSpeedUpgrade() ? ((ItemStack)this.getItems().get(2)).m_41613_() : 0;
    }

    public void setAABBWithModifiers() {
        BlockState state2;
        int distance;
        BlockState state = this.m_58904_().m_8055_(this.m_58899_());
        if (!(state.m_60734_() instanceof BlockFan)) {
            return;
        }
        Direction facing = (Direction)state.m_61143_((Property)BlockFan.f_52588_);
        for (distance = 1; distance < 5 + this.getSpeedModifier() && ((state2 = this.m_58904_().m_8055_(this.m_58899_().m_5484_(facing, distance))).m_60734_() instanceof AirBlock || state2.m_60767_() == Material.f_76302_); ++distance) {
        }
        if (facing == Direction.UP) {
            this.yPos = distance;
            this.yNeg = -1.0f;
            this.xPos = this.getHeightModifier();
            this.xNeg = this.getHeightModifier();
            this.zPos = this.getWidthModifier();
            this.zNeg = this.getWidthModifier();
        }
        if (facing == Direction.DOWN) {
            this.yNeg = distance;
            this.yPos = -1.0f;
            this.xPos = this.getHeightModifier();
            this.xNeg = this.getHeightModifier();
            this.zPos = this.getWidthModifier();
            this.zNeg = this.getWidthModifier();
        }
        if (facing == Direction.WEST) {
            this.xNeg = distance;
            this.xPos = -1.0f;
            this.zPos = this.getWidthModifier();
            this.zNeg = this.getWidthModifier();
            this.yPos = this.getHeightModifier();
            this.yNeg = this.getHeightModifier();
        }
        if (facing == Direction.EAST) {
            this.xPos = distance;
            this.xNeg = -1.0f;
            this.zPos = this.getWidthModifier();
            this.zNeg = this.getWidthModifier();
            this.yPos = this.getHeightModifier();
            this.yNeg = this.getHeightModifier();
        }
        if (facing == Direction.NORTH) {
            this.zNeg = distance;
            this.zPos = -1.0f;
            this.xPos = this.getWidthModifier();
            this.xNeg = this.getWidthModifier();
            this.yPos = this.getHeightModifier();
            this.yNeg = this.getHeightModifier();
        }
        if (facing == Direction.SOUTH) {
            this.zPos = distance;
            this.zNeg = -1.0f;
            this.xPos = this.getWidthModifier();
            this.xNeg = this.getWidthModifier();
            this.yPos = this.getHeightModifier();
            this.yNeg = this.getHeightModifier();
        }
        this.m_58904_().m_7260_(this.m_58899_(), state, state, 8);
    }

    public AABB getAABBWithModifiers() {
        return new AABB((double)((float)this.m_58899_().m_123341_() - this.xNeg), (double)((float)this.m_58899_().m_123342_() - this.yNeg), (double)((float)this.m_58899_().m_123343_() - this.zNeg), (double)this.m_58899_().m_123341_() + 1.0 + (double)this.xPos, (double)this.m_58899_().m_123342_() + 1.0 + (double)this.yPos, (double)this.m_58899_().m_123343_() + 1.0 + (double)this.zPos);
    }

    @OnlyIn(value=Dist.CLIENT)
    public AABB getAABBForRender() {
        return new AABB((double)(-this.xNeg), (double)(-this.yNeg), (double)(-this.zNeg), 1.0 + (double)this.xPos, 1.0 + (double)this.yPos, 1.0 + (double)this.zPos);
    }

    @OnlyIn(value=Dist.CLIENT)
    public AABB getRenderBoundingBox() {
        return new AABB((double)((float)this.m_58899_().m_123341_() - this.xNeg), (double)((float)this.m_58899_().m_123342_() - this.yNeg), (double)((float)this.m_58899_().m_123343_() - this.zNeg), (double)this.m_58899_().m_123341_() + 1.0 + (double)this.xPos, (double)this.m_58899_().m_123342_() + 1.0 + (double)this.yPos, (double)this.m_58899_().m_123343_() + 1.0 + (double)this.zPos);
    }

    public void toggleRenderBox() {
        this.showRenderBox = !this.showRenderBox;
        this.m_6596_();
    }

    protected void activateBlock() {
        BlockState state = this.m_58904_().m_8055_(this.m_58899_());
        if (!(state.m_60734_() instanceof BlockFan)) {
            return;
        }
        Direction facing = (Direction)state.m_61143_((Property)BlockFan.f_52588_);
        List list = this.m_58904_().m_45976_(LivingEntity.class, this.getAABBWithModifiers());
        for (Entity entity : list) {
            if (entity == null || !(entity instanceof LivingEntity)) continue;
            if (facing != Direction.UP && facing != Direction.DOWN) {
                entity.m_5997_((double)Mth.m_14031_((float)(facing.m_122424_().m_122435_() * 3.141593f / 180.0f)) * 0.5, 0.0, (double)(-Mth.m_14089_((float)(facing.m_122424_().m_122435_() * 3.141593f / 180.0f))) * 0.5);
                continue;
            }
            if (facing == Direction.UP) {
                float f = 0.125f;
                Vec3 vec3d = entity.m_20184_();
                entity.m_20334_(vec3d.f_82479_, (double)f, vec3d.f_82481_);
                entity.m_5997_(0.0, 0.25, 0.0);
                entity.f_19789_ = 0.0f;
                continue;
            }
            entity.m_5997_(0.0, -0.2, 0.0);
        }
    }

    private boolean hasWidthUpgrade() {
        return !((ItemStack)this.getItems().get(0)).m_41619_() && ((ItemStack)this.getItems().get(0)).m_41720_() == ModItems.FAN_UPGRADE_WIDTH.get();
    }

    private boolean hasHeightUpgrade() {
        return !((ItemStack)this.getItems().get(1)).m_41619_() && ((ItemStack)this.getItems().get(1)).m_41720_() == ModItems.FAN_UPGRADE_HEIGHT.get();
    }

    private boolean hasSpeedUpgrade() {
        return !((ItemStack)this.getItems().get(2)).m_41619_() && ((ItemStack)this.getItems().get(2)).m_41720_() == ModItems.FAN_UPGRADE_SPEED.get();
    }

    @Override
    public void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128379_("showRenderBox", this.showRenderBox);
        nbt.m_128350_("xPos", this.xPos);
        nbt.m_128350_("yPos", this.yPos);
        nbt.m_128350_("zPos", this.zPos);
        nbt.m_128350_("xNeg", this.xNeg);
        nbt.m_128350_("yNeg", this.yNeg);
        nbt.m_128350_("zNeg", this.zNeg);
    }

    @Override
    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.showRenderBox = nbt.m_128471_("showRenderBox");
        this.xPos = nbt.m_128457_("xPos");
        this.yPos = nbt.m_128457_("yPos");
        this.zPos = nbt.m_128457_("zPos");
        this.xNeg = nbt.m_128457_("xNeg");
        this.yNeg = nbt.m_128457_("yNeg");
        this.zNeg = nbt.m_128457_("zNeg");
    }

    @Nonnull
    public CompoundTag m_5995_() {
        CompoundTag nbt = new CompoundTag();
        this.m_183515_(nbt);
        return nbt;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        CompoundTag nbt = new CompoundTag();
        this.m_183515_(nbt);
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket packet) {
        this.m_142466_(packet.m_131708_());
        this.onContentsChanged();
    }

    public void onContentsChanged() {
        if (!this.m_58904_().f_46443_) {
            BlockState state = this.m_58904_().m_8055_(this.m_58899_());
            this.setAABBWithModifiers();
            this.m_58904_().m_7260_(this.m_58899_(), state, state, 8);
            this.m_6596_();
        }
    }

    public boolean m_7013_(int slot, ItemStack stack) {
        return stack.m_41720_() instanceof ItemFanUpgrade;
    }

    @Nonnull
    public ItemStack m_8016_(int index) {
        return ContainerHelper.m_18966_(this.getItems(), (int)index);
    }

    @Override
    public int m_6893_() {
        return 64;
    }

    @Nonnull
    public int[] m_7071_(Direction side) {
        return SLOTS;
    }

    public boolean m_7155_(int index, ItemStack itemStackIn, Direction direction) {
        return false;
    }

    public boolean m_7157_(int index, ItemStack stack, Direction direction) {
        return false;
    }

    public AbstractContainerMenu m_7208_(int windowID, Inventory playerInventory, Player player) {
        return new ContainerFan(windowID, playerInventory, new FriendlyByteBuf(Unpooled.buffer()).m_130064_(this.f_58858_));
    }

    @Nonnull
    public Component m_5446_() {
        return new TranslatableComponent("block.mob_grinding_utils.fan");
    }
}

