/*
 * Decompiled with CFR 0.152.
 */
package mob_grinding_utils.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mob_grinding_utils.MobGrindingUtils;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;

public class BeheadingRecipe
implements Recipe<Container> {
    private final ResourceLocation id;
    public static final String NAME = "beheading";
    private final EntityType<?> entityType;
    private final ItemStack result;

    public BeheadingRecipe(ResourceLocation id, EntityType<?> type, ItemStack output) {
        this.id = id;
        this.entityType = type;
        this.result = output;
    }

    public boolean m_5818_(@Nonnull Container container, @Nonnull Level level) {
        return false;
    }

    public boolean matches(EntityType<?> typeIn) {
        return typeIn == this.entityType;
    }

    @Nonnull
    public ItemStack m_5874_(@Nonnull Container container) {
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int p_43999_, int p_44000_) {
        return false;
    }

    @Nonnull
    public ItemStack m_8043_() {
        return this.result.m_41777_();
    }

    @Nonnull
    public ResourceLocation m_6423_() {
        return this.id;
    }

    @Nonnull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)MobGrindingUtils.BEHEADING_RECIPE.get();
    }

    @Nonnull
    public RecipeType<?> m_6671_() {
        return (RecipeType)MobGrindingUtils.BEHEADING_TYPE.get();
    }

    public static class Serializer
    implements RecipeSerializer<BeheadingRecipe> {
        @Nonnull
        public BeheadingRecipe fromJson(@Nonnull ResourceLocation recipeID, JsonObject json) {
            ResourceLocation entityRes = new ResourceLocation(json.get("entity").getAsString());
            Optional type = BuiltInRegistries.f_256780_.m_6612_(entityRes);
            if (type.isEmpty()) {
                throw new JsonParseException("unknown entity type");
            }
            ItemStack result = new ItemStack((ItemLike)GsonHelper.m_13909_((JsonObject)json.get("result").getAsJsonObject(), (String)"item"));
            return new BeheadingRecipe(recipeID, (EntityType)type.get(), result);
        }

        @Nullable
        public BeheadingRecipe fromNetwork(ResourceLocation recipeID, FriendlyByteBuf buf) {
            ResourceLocation entityRes = new ResourceLocation(buf.m_130277_());
            Optional type = BuiltInRegistries.f_256780_.m_6612_(entityRes);
            if (type.isEmpty()) {
                throw new JsonParseException("unknown entity type");
            }
            ItemStack result = buf.m_130267_();
            return new BeheadingRecipe(recipeID, (EntityType)type.get(), result);
        }

        public void toNetwork(FriendlyByteBuf buf, BeheadingRecipe recipe) {
            buf.m_130070_(Objects.requireNonNull(ForgeRegistries.ENTITY_TYPES.getKey(recipe.entityType)).toString());
            buf.m_130055_(recipe.result);
        }
    }

    public static class DataRecipe
    implements FinishedRecipe {
        private final ResourceLocation id;
        private final ResourceLocation entityRes;
        private final ResourceLocation resultRes;

        public DataRecipe(ResourceLocation id, EntityType<?> entityType, ItemStack result) {
            this.id = id;
            this.entityRes = ForgeRegistries.ENTITY_TYPES.getKey(entityType);
            this.resultRes = ForgeRegistries.ITEMS.getKey((Object)result.m_41720_());
        }

        public DataRecipe(ResourceLocation id, ResourceLocation entityRes, ItemStack result) {
            this.id = id;
            this.entityRes = entityRes;
            this.resultRes = ForgeRegistries.ITEMS.getKey((Object)result.m_41720_());
        }

        public DataRecipe(ResourceLocation id, ResourceLocation entityRes, ResourceLocation result) {
            this.id = id;
            this.entityRes = entityRes;
            this.resultRes = result;
        }

        public DataRecipe(ResourceLocation id, EntityType<?> entityType, ResourceLocation result) {
            this.id = id;
            this.entityRes = ForgeRegistries.ENTITY_TYPES.getKey(entityType);
            this.resultRes = result;
        }

        public void m_7917_(@Nonnull JsonObject json) {
            json.addProperty("entity", this.entityRes.toString());
            JsonObject resultJson = new JsonObject();
            resultJson.addProperty("item", this.resultRes.toString());
            json.add("result", (JsonElement)resultJson);
        }

        @Nonnull
        public ResourceLocation m_6445_() {
            return this.id;
        }

        @Nonnull
        public RecipeSerializer<?> m_6637_() {
            return (RecipeSerializer)MobGrindingUtils.BEHEADING_RECIPE.get();
        }

        @Nullable
        public JsonObject m_5860_() {
            return null;
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return null;
        }
    }
}

