/*
 * Decompiled with CFR 0.152.
 */
package mob_grinding_utils.blocks;

import java.util.List;
import javax.annotation.Nullable;
import mob_grinding_utils.MobGrindingUtils;
import mob_grinding_utils.blocks.BlockTank;
import mob_grinding_utils.tile.TileEntityXPTap;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirectional;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockXPTap
extends BlockDirectional
implements ITileEntityProvider {
    protected static final AxisAlignedBB XP_TAP_WEST_AABB = new AxisAlignedBB(0.4375, 0.5, 0.25, 1.0, 1.0, 0.75);
    protected static final AxisAlignedBB XP_TAP_EAST_AABB = new AxisAlignedBB(0.0, 0.5, 0.25, 0.5625, 1.0, 0.75);
    protected static final AxisAlignedBB XP_TAP_SOUTH_AABB = new AxisAlignedBB(0.25, 0.5, 0.0, 0.75, 1.0, 0.5625);
    protected static final AxisAlignedBB XP_TAP_NORTH_AABB = new AxisAlignedBB(0.25, 0.5, 0.4375, 0.75, 1.0, 1.0);
    public static final PropertyBool POWERED = PropertyBool.func_177716_a((String)"powered");

    public BlockXPTap() {
        super(Material.field_151594_q);
        this.func_180632_j(this.func_176194_O().func_177621_b().func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false)));
        this.func_149711_c(1.0f);
        this.func_149672_a(SoundType.field_185852_e);
        this.func_149647_a(MobGrindingUtils.TAB);
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        state = state.func_185899_b(source, pos);
        switch ((EnumFacing)state.func_177229_b((IProperty)field_176387_N)) {
            default: {
                return XP_TAP_EAST_AABB;
            }
            case WEST: {
                return XP_TAP_WEST_AABB;
            }
            case SOUTH: {
                return XP_TAP_SOUTH_AABB;
            }
            case NORTH: 
        }
        return XP_TAP_NORTH_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_180640_a(IBlockState state, World world, BlockPos pos) {
        state = state.func_185899_b((IBlockAccess)world, pos);
        switch ((EnumFacing)state.func_177229_b((IProperty)field_176387_N)) {
            default: {
                return XP_TAP_EAST_AABB;
            }
            case WEST: {
                return XP_TAP_WEST_AABB;
            }
            case SOUTH: {
                return XP_TAP_SOUTH_AABB;
            }
            case NORTH: 
        }
        return XP_TAP_NORTH_AABB;
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn) {
        state = state.func_185899_b((IBlockAccess)worldIn, pos);
        switch ((EnumFacing)state.func_177229_b((IProperty)field_176387_N)) {
            default: {
                BlockXPTap.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)XP_TAP_EAST_AABB);
                break;
            }
            case WEST: {
                BlockXPTap.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)XP_TAP_WEST_AABB);
                break;
            }
            case SOUTH: {
                BlockXPTap.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)XP_TAP_SOUTH_AABB);
                break;
            }
            case NORTH: {
                BlockXPTap.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)XP_TAP_NORTH_AABB);
            }
        }
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        if (this.canPlaceAt(world, pos, facing)) {
            return this.func_176223_P().func_177226_a((IProperty)field_176387_N, (Comparable)facing).func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false));
        }
        return this.func_176223_P();
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, @Nullable ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        state = state.func_177231_a((IProperty)POWERED);
        world.func_180501_a(pos, state, 3);
        float f = (Boolean)state.func_177229_b((IProperty)POWERED) != false ? 0.6f : 0.5f;
        world.func_184133_a((EntityPlayer)null, pos, MobGrindingUtils.TAP_SQUEAK, SoundCategory.BLOCKS, 0.3f, f);
        TileEntityXPTap tileentity = (TileEntityXPTap)world.func_175625_s(pos);
        tileentity.setActive((Boolean)state.func_177229_b((IProperty)POWERED));
        return true;
    }

    public boolean func_176196_c(World world, BlockPos pos) {
        for (EnumFacing enumfacing : field_176387_N.func_177700_c()) {
            if (!this.canPlaceAt(world, pos, enumfacing)) continue;
            return true;
        }
        return false;
    }

    private boolean canPlaceAt(World world, BlockPos pos, EnumFacing facing) {
        BlockPos blockpos = pos.func_177972_a(facing.func_176734_d());
        boolean isSide = facing.func_176740_k().func_176722_c();
        return isSide && world.func_180495_p(blockpos).func_177230_c() instanceof BlockTank;
    }

    public void onNeighborChange(IBlockAccess world, BlockPos pos, BlockPos neighbor) {
        EnumFacing facing = (EnumFacing)world.func_180495_p(pos).func_177229_b((IProperty)field_176387_N);
        if (!this.canPlaceAt((World)world, pos, facing)) {
            this.func_176226_b((World)world, pos, world.func_180495_p(pos), 0);
            ((World)world).func_175698_g(pos);
        }
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing facing = EnumFacing.func_82600_a((int)meta);
        if (facing.func_176740_k() == EnumFacing.Axis.Y) {
            facing = EnumFacing.NORTH;
        }
        return this.func_176223_P().func_177226_a((IProperty)field_176387_N, (Comparable)facing).func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf((meta & 8) > 0));
    }

    public int func_176201_c(IBlockState state) {
        int meta = 0;
        meta |= ((EnumFacing)state.func_177229_b((IProperty)field_176387_N)).func_176745_a();
        if (((Boolean)state.func_177229_b((IProperty)POWERED)).booleanValue()) {
            meta |= 8;
        }
        return meta;
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)field_176387_N, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)field_176387_N)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)state.func_177229_b((IProperty)field_176387_N)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{field_176387_N, POWERED});
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityXPTap();
    }
}

