/*
 * Decompiled with CFR 0.152.
 */
package com.modularwarfare;

import com.google.common.collect.ImmutableList;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import com.google.gson.stream.JsonReader;
import com.modularwarfare.ModConfig;
import com.modularwarfare.common.CommonProxy;
import com.modularwarfare.common.MWTab;
import com.modularwarfare.common.armor.ItemMWArmor;
import com.modularwarfare.common.armor.ItemSpecialArmor;
import com.modularwarfare.common.backpacks.ItemBackpack;
import com.modularwarfare.common.entity.debug.EntityDebugDot;
import com.modularwarfare.common.entity.decals.EntityBulletHole;
import com.modularwarfare.common.entity.decals.EntityShell;
import com.modularwarfare.common.entity.item.EntityItemLoot;
import com.modularwarfare.common.extra.ItemLight;
import com.modularwarfare.common.guns.ItemAmmo;
import com.modularwarfare.common.guns.ItemAttachment;
import com.modularwarfare.common.guns.ItemBullet;
import com.modularwarfare.common.guns.ItemGun;
import com.modularwarfare.common.guns.ItemSpray;
import com.modularwarfare.common.handler.CommonEventHandler;
import com.modularwarfare.common.handler.GuiHandler;
import com.modularwarfare.common.handler.ServerTickHandler;
import com.modularwarfare.common.hitbox.playerdata.PlayerDataHandler;
import com.modularwarfare.common.network.NetworkHandler;
import com.modularwarfare.common.protector.ModularProtector;
import com.modularwarfare.common.type.BaseType;
import com.modularwarfare.common.type.ContentTypes;
import com.modularwarfare.common.type.TypeEntry;
import com.modularwarfare.utility.GSONUtils;
import com.modularwarfare.utility.MWResourcePack;
import com.modularwarfare.utility.ZipContentPack;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import net.lingala.zip4j.core.ZipFile;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.io.ZipInputStream;
import net.lingala.zip4j.model.FileHeader;
import net.minecraft.item.Item;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.FMLModContainer;
import net.minecraftforge.fml.common.MetadataCollection;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.discovery.ContainerType;
import net.minecraftforge.fml.common.discovery.ModCandidate;
import net.minecraftforge.fml.common.event.FMLConstructionEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.relauncher.CoreModManager;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.Logger;

@Mod(modid="modularwarfare", name="ModularWarfare", version="1.0.4f", dependencies="before:optifine;", acceptedMinecraftVersions="[1.12.2]")
public class ModularWarfare {
    public static Logger LOGGER;
    public static final String MOD_VERSION = "1.0.4f";
    public static LinkedHashMap<String, ItemSpecialArmor> specialArmorTypes;
    public static HashMap<String, ItemGun> gunTypes;
    public static HashMap<String, ItemBullet> bulletTypes;
    public static HashMap<String, MWTab> MODS_TABS;
    public static boolean DEV_ENV;
    public static HashMap<String, ItemAmmo> ammoTypes;
    public static List<File> contentPacks;
    public static LinkedHashMap<String, ItemMWArmor> armorTypes;
    public static HashMap<String, ItemSpray> sprayTypes;
    @SidedProxy(clientSide="com.modularwarfare.client.ClientProxy", serverSide="com.modularwarfare.common.CommonProxy")
    public static CommonProxy PROXY;
    public static PlayerDataHandler PLAYERHANDLER;
    public static File MOD_DIR;
    public static ModularProtector PROTECTOR;
    public static HashMap<String, ItemBackpack> backpackTypes;
    public static ArrayList<BaseType> baseTypes;
    public static final String MOD_NAME = "ModularWarfare";
    public static HashMap<String, ZipContentPack> zipContentsPack;
    public static HashMap<String, ItemAttachment> attachmentTypes;
    public static NetworkHandler NETWORK;
    @Mod.Instance(value="modularwarfare")
    public static ModularWarfare INSTANCE;
    public static final String MOD_ID = "modularwarfare";
    public static Gson gson;

    @SubscribeEvent
    public void registerItems(RegistryEvent.Register<Item> event) {
        Iterator<File> iterator;
        Iterator<File> iterator2 = iterator = contentPacks.iterator();
        while (iterator2.hasNext()) {
            File file = iterator.next();
            ArrayList<Item> tabOrder = new ArrayList<Item>();
            for (ItemGun itemGun : gunTypes.values()) {
                if (!itemGun.type.contentPack.equals(file.getName())) continue;
                ItemGun itemGun2 = itemGun;
                event.getRegistry().register((IForgeRegistryEntry)itemGun2);
                tabOrder.add(itemGun2);
            }
            for (ItemAmmo itemAmmo : ammoTypes.values()) {
                if (!itemAmmo.type.contentPack.equals(file.getName())) continue;
                ItemAmmo itemAmmo2 = itemAmmo;
                event.getRegistry().register((IForgeRegistryEntry)itemAmmo2);
                tabOrder.add(itemAmmo2);
            }
            for (ItemBullet itemBullet : bulletTypes.values()) {
                if (!itemBullet.type.contentPack.equals(file.getName())) continue;
                ItemBullet itemBullet2 = itemBullet;
                event.getRegistry().register((IForgeRegistryEntry)itemBullet2);
                tabOrder.add(itemBullet2);
            }
            for (ItemMWArmor itemArmor : armorTypes.values()) {
                if (!itemArmor.type.contentPack.equals(file.getName())) continue;
                ItemMWArmor itemMWArmor = itemArmor;
                event.getRegistry().register((IForgeRegistryEntry)itemMWArmor);
                tabOrder.add((Item)itemMWArmor);
            }
            for (ItemAttachment itemAttachment : attachmentTypes.values()) {
                if (!itemAttachment.type.contentPack.equals(file.getName())) continue;
                ItemAttachment itemAttachment2 = itemAttachment;
                event.getRegistry().register((IForgeRegistryEntry)itemAttachment2);
                tabOrder.add(itemAttachment2);
            }
            for (ItemSpecialArmor itemSpecialArmor : specialArmorTypes.values()) {
                if (!itemSpecialArmor.type.contentPack.equals(file.getName())) continue;
                ItemSpecialArmor itemSpecialArmor2 = itemSpecialArmor;
                event.getRegistry().register((IForgeRegistryEntry)itemSpecialArmor2);
                tabOrder.add(itemSpecialArmor2);
            }
            for (ItemSpray itemSpray : sprayTypes.values()) {
                if (!itemSpray.type.contentPack.equals(file.getName())) continue;
                ItemSpray itemSpray2 = itemSpray;
                event.getRegistry().register((IForgeRegistryEntry)itemSpray2);
                tabOrder.add(itemSpray2);
            }
            for (ItemBackpack itemBackpack : backpackTypes.values()) {
                if (!itemBackpack.type.contentPack.equals(file.getName())) continue;
                ItemBackpack itemBackpack2 = itemBackpack;
                event.getRegistry().register((IForgeRegistryEntry)itemBackpack2);
                tabOrder.add(itemBackpack2);
            }
            MODS_TABS.get(file.getName()).preInitialize(tabOrder);
            iterator2 = iterator;
        }
        event.getRegistry().register((IForgeRegistryEntry)new ItemLight("light"));
    }

    @Mod.EventHandler
    public void onServerStarting(FMLServerStartingEvent event) {
    }

    static {
        DEV_ENV = false;
        PROTECTOR = new ModularProtector();
        PLAYERHANDLER = new PlayerDataHandler();
        gson = new GsonBuilder().setPrettyPrinting().create();
        zipContentsPack = new HashMap();
        contentPacks = new ArrayList<File>();
        gunTypes = new HashMap();
        ammoTypes = new HashMap();
        attachmentTypes = new HashMap();
        armorTypes = new LinkedHashMap();
        specialArmorTypes = new LinkedHashMap();
        bulletTypes = new HashMap();
        sprayTypes = new HashMap();
        backpackTypes = new HashMap();
        baseTypes = new ArrayList();
        MODS_TABS = new HashMap();
    }

    public static void loadContentPacks(boolean reload) {
        Iterator<BaseType> iterator;
        ModularWarfare.loadContent();
        if (DEV_ENV) {
            PROXY.generateJsonModels(baseTypes);
        }
        Iterator<BaseType> iterator2 = iterator = baseTypes.iterator();
        while (iterator2.hasNext()) {
            BaseType baseType = iterator.next();
            baseType.loadExtraValues();
            ContentTypes.values.get((int)baseType.id).typeAssignFunction.accept(baseType, reload);
            iterator2 = iterator;
        }
        if (DEV_ENV) {
            if (reload) {
                return;
            }
            PROXY.generateLangFiles(baseTypes, DEV_ENV);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void loadContent() {
        ClassLoader classloader = MinecraftServer.class.getClassLoader();
        Method method = null;
        try {
            Class[] classArray = new Class[1];
            classArray[0] = URL.class;
            method = URLClassLoader.class.getDeclaredMethod("addURL", classArray);
            method.setAccessible(true);
        }
        catch (Exception e) {
            LOGGER.error("Failed to get class loader. All content loading will now fail.");
            e.printStackTrace();
        }
        Iterator<File> e = contentPacks.iterator();
        while (true) {
            void var2_3;
            if (!var2_3.hasNext()) {
                ModularWarfare.getTypeFiles(contentPacks);
                return;
            }
            File file = (File)var2_3.next();
            if (!MODS_TABS.containsKey(file.getName())) {
                MODS_TABS.put(file.getName(), new MWTab(file.getName()));
            }
            if (!file.getName().endsWith(".zip") || zipContentsPack.containsKey(file.getName())) continue;
            try {
                ZipFile zipFile = new ZipFile(file);
                if (zipFile.isEncrypted()) {
                    if (FMLCommonHandler.instance().getSide() == Side.CLIENT) {
                        PROTECTOR.applyPassword(zipFile, file.getName());
                    } else {
                        LOGGER.info("Can't use password protected content-pack on server-side.");
                    }
                }
                ZipContentPack zipContentPack = new ZipContentPack(file.getName(), zipFile.getFileHeaders(), zipFile);
                zipContentsPack.put(file.getName(), zipContentPack);
                LOGGER.info("Registered content pack");
            }
            catch (ZipException e2) {
                e2.printStackTrace();
                continue;
            }
            break;
        }
    }

    public static <T> T getRenderConfig(BaseType baseType, Class<T> typeClass) {
        if (baseType.isInDirectory) {
            try {
                File contentPackDir = new File(MOD_DIR, baseType.contentPack);
                if (contentPackDir.exists() && contentPackDir.isDirectory()) {
                    File renderConfig = new File(contentPackDir, "/" + baseType.getAssetDir() + "/render");
                    File typeRender = new File(renderConfig, baseType.internalName + ".render.json");
                    JsonReader jsonReader = new JsonReader((Reader)new FileReader(typeRender));
                    return GSONUtils.fromJson(gson, jsonReader, typeClass);
                }
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        } else if (zipContentsPack.containsKey(baseType.contentPack)) {
            String typeName = baseType.getAssetDir();
            FileHeader foundFile = ModularWarfare.zipContentsPack.get((Object)baseType.contentPack).fileHeaders.stream().filter(fileHeader -> {
                if (fileHeader.getFileName().startsWith(new StringBuilder().insert(0, typeName).append("/render/").toString()) && fileHeader.getFileName().replace(new StringBuilder().insert(0, typeName).append("/render/").toString(), "").equalsIgnoreCase(new StringBuilder().insert(0, baseType.internalName).append(".render.json").toString())) {
                    return true;
                }
                return false;
            }).findFirst().orElse(null);
            if (foundFile != null) {
                try {
                    ZipInputStream stream = zipContentsPack.get(baseType.contentPack).getZipFile().getInputStream(foundFile);
                    JsonReader jsonReader = new JsonReader((Reader)new InputStreamReader(stream));
                    return GSONUtils.fromJson(gson, jsonReader, typeClass);
                }
                catch (ZipException e) {
                    e.printStackTrace();
                }
            } else {
                LOGGER.info(new StringBuilder().insert(0, baseType.internalName).append(".render.json not found. Aborting").toString());
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ void getTypeFiles(List<File> contentPacks) {
        for (File file : contentPacks) {
            BaseType parsedType;
            JsonReader jsonReader;
            if (file.getName().contains("cache")) continue;
            if (file.isDirectory()) {
                for (TypeEntry type : ContentTypes.values) {
                    int n;
                    File subFolder = new File(file, "/" + type.name + "/");
                    if (!subFolder.exists()) continue;
                    File[] fileArray = subFolder.listFiles();
                    int n2 = fileArray.length;
                    int n3 = n = 0;
                    while (n3 < n2) {
                        File typeFile = fileArray[n];
                        try {
                            if (typeFile.isFile()) {
                                jsonReader = new JsonReader((Reader)new FileReader(typeFile));
                                BaseType baseType = (BaseType)GSONUtils.fromJson(gson, jsonReader, type.typeClass);
                                void v1 = parsedType;
                                parsedType.id = type.id;
                                v1.contentPack = file.getName();
                                v1.isInDirectory = true;
                                baseTypes.add(parsedType);
                            }
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                        n3 = ++n;
                    }
                }
                continue;
            }
            if (!zipContentsPack.containsKey(file.getName())) continue;
            for (FileHeader fileHeader : ModularWarfare.zipContentsPack.get((Object)file.getName()).fileHeaders) {
                for (TypeEntry type : ContentTypes.values) {
                    void typeName;
                    String zipName = fileHeader.getFileName();
                    String string = type.toString();
                    if (!zipName.startsWith((String)typeName + "/")) continue;
                    if (zipName.split((String)typeName + "/").length <= 1) continue;
                    if (zipName.split((String)typeName + "/")[1].length() <= 0 || zipName.contains("render")) continue;
                    ZipInputStream stream = null;
                    try {
                        stream = zipContentsPack.get(file.getName()).getZipFile().getInputStream(fileHeader);
                        jsonReader = new JsonReader((Reader)new InputStreamReader(stream));
                        try {
                            BaseType baseType = parsedType = (BaseType)GSONUtils.fromJson(gson, jsonReader, type.typeClass);
                            parsedType.id = type.id;
                            baseType.contentPack = file.getName();
                            baseType.isInDirectory = false;
                            baseTypes.add(parsedType);
                        }
                        catch (JsonSyntaxException ex) {
                            LOGGER.warn(new StringBuilder().insert(0, "Detected an error in the file ").append(zipName).toString());
                            LOGGER.warn(ex.getMessage());
                        }
                    }
                    catch (ZipException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    @Mod.EventHandler
    public void onInitialization(FMLInitializationEvent event) {
        new ServerTickHandler();
        PROXY.load();
        NETWORK = new NetworkHandler();
        NETWORK.initialise();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)INSTANCE, (IGuiHandler)new GuiHandler());
    }

    @SubscribeEvent
    public void registerEntities(RegistryEvent.Register<EntityEntry> event) {
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation(MOD_ID, "bullethole"), EntityBulletHole.class, (String)"bullethole", (int)3, (Object)this, (int)80, (int)10, (boolean)false);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation(MOD_ID, "shell"), EntityShell.class, (String)"shell", (int)4, (Object)this, (int)64, (int)1, (boolean)false);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation(MOD_ID, "debugdot"), EntityDebugDot.class, (String)"debugdot", (int)5, (Object)this, (int)64, (int)50, (boolean)false);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation(MOD_ID, "itemloot"), EntityItemLoot.class, (String)"itemloot", (int)6, (Object)this, (int)64, 1, (boolean)true);
    }

    @Mod.EventHandler
    public void onPreInitialization(FMLPreInitializationEvent event) {
        LOGGER = event.getModLog();
        PROXY.preload();
        MOD_DIR = new File(event.getModConfigurationDirectory().getParentFile(), MOD_NAME);
        if (!MOD_DIR.exists()) {
            MOD_DIR.mkdir();
            LOGGER.info("Created ModularWarfare folder, it's recommended to install content packs.");
            LOGGER.info("As the mod itself doesn't come with any content.");
        }
        new ModConfig(new File(MOD_DIR, "mod_config.json"));
        DEV_ENV = ModConfig.INSTANCE.dev_mode;
        ContentTypes.registerTypes();
        ModularWarfare.loadContentPacks(false);
        PROXY.registerEventHandlers();
        MinecraftForge.EVENT_BUS.register((Object)new CommonEventHandler());
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Mod.EventHandler
    public void onPostInitialization(FMLPostInitializationEvent event) {
        NETWORK.postInitialise();
        PROXY.init();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Mod.EventHandler
    public void constructionEvent(FMLConstructionEvent event) {
        int n;
        File file;
        int n2;
        int n3;
        File[] fileArray;
        File modFile;
        File myDir;
        block36: {
            File[] minecraftSources;
            ImmutableList knownLibraries;
            block35: {
                myDir = new File(MOD_NAME);
                modFile = null;
                if (!myDir.exists()) {
                    if (myDir.getParentFile() != null) {
                        if (!(myDir = new File(myDir.getParentFile().getParentFile(), MOD_NAME)).exists()) {
                            myDir = new File(MOD_NAME);
                            myDir.mkdirs();
                        }
                    } else {
                        myDir.mkdirs();
                    }
                }
                knownLibraries = ImmutableList.builder().addAll((Iterable)event.getModClassLoader().getDefaultLibraries()).addAll((Iterable)CoreModManager.getIgnoredMods()).addAll((Iterable)CoreModManager.getReparseableCoremods()).build();
                minecraftSources = event.getModClassLoader().getParentSources();
                if (minecraftSources.length != 1) break block35;
                if (!minecraftSources[0].isFile()) break block35;
                FMLLog.log.debug("Minecraft is a file at {}, loading", (Object)minecraftSources[0].getAbsolutePath());
                break block36;
            }
            int i = 0;
            fileArray = minecraftSources;
            n3 = minecraftSources.length;
            int n4 = n2 = 0;
            while (n4 < n3) {
                block38: {
                    File source;
                    block37: {
                        source = fileArray[n2];
                        if (!source.isFile()) break block37;
                        if (knownLibraries.contains(source.getName()) || event.getModClassLoader().isDefaultLibrary(source)) {
                            FMLLog.log.trace("Skipping known library file {}", (Object)source.getAbsolutePath());
                            break block38;
                        } else {
                            FMLLog.log.debug("Found a minecraft related file at {}, examining for mod candidates", (Object)source.getAbsolutePath());
                            if (source.getAbsolutePath().contains(MOD_ID)) {
                                modFile = source;
                            }
                        }
                        break block38;
                    }
                    if (minecraftSources[i].isDirectory()) {
                        FMLLog.log.debug("Found a minecraft related directory at {}, examining for mod candidates", (Object)source.getAbsolutePath());
                    }
                }
                ++i;
                n4 = ++n2;
            }
        }
        boolean needPrototypeExtract = true;
        fileArray = myDir.listFiles();
        n3 = fileArray.length;
        int n5 = n2 = 0;
        while (n5 < n3) {
            file = fileArray[n2];
            if (file.getName().matches("prototype-1.0.4f-contentpack.zip")) {
                needPrototypeExtract = false;
            } else if (file.getName().contains("prototype") && !file.getName().contains(MOD_VERSION) && file.getName().contains(".zip") && !file.getName().endsWith(".bak")) {
                file.renameTo(new File(new StringBuilder().insert(0, file.getAbsolutePath()).append(".bak").toString()));
            }
            n5 = ++n2;
        }
        if (needPrototypeExtract) {
            try {
                ZipFile zipFile = new ZipFile(modFile);
                if (zipFile.isValidZipFile()) {
                    List fileHeaders = zipFile.getFileHeaders();
                    for (FileHeader fileHeader : fileHeaders) {
                        if (!fileHeader.getFileName().equals("prototype-1.0.4f-contentpack.zip")) continue;
                        zipFile.extractFile(fileHeader, myDir.getAbsolutePath());
                    }
                }
            }
            catch (ZipException e) {
                e.printStackTrace();
            }
        }
        File[] e = myDir.listFiles();
        int n6 = e.length;
        int n7 = n = 0;
        while (true) {
            block34: {
                if (n7 >= n6) {
                    return;
                }
                file = fileArray[n];
                if (!(file.getName().contains("cache") || file.getName().contains("officialmw") || file.getName().contains("highres"))) {
                    if (CommonProxy.zipJar.matcher(file.getName()).matches()) {
                        try {
                            FMLModContainer container;
                            HashMap<String, Object> map;
                            ZipFile zipFile = new ZipFile(file);
                            if (zipFile.isEncrypted()) {
                                if (FMLCommonHandler.instance().getSide().isClient()) {
                                    PROTECTOR.requestPassword(file.getName());
                                    PROTECTOR.applyPassword(zipFile, file.getName());
                                    map = new HashMap<String, String>();
                                    map.put("modid", MOD_ID);
                                    map.put("name", new StringBuilder().insert(0, "ModularWarfare : ").append(file.getName()).toString());
                                    map.put("version", "1");
                                    File file2 = file;
                                    container = new MWResourcePack.Container("com.modularwarfare.ModularWarfare", new ModCandidate(file2, file2, ContainerType.JAR), map, zipFile, "ModularWarfare : " + file.getName());
                                    container.bindMetadata(MetadataCollection.from(null, (String)""));
                                    FMLClientHandler.instance().addModAsResource((ModContainer)container);
                                    contentPacks.add(file);
                                }
                                break block34;
                            }
                            if (FMLCommonHandler.instance().getSide().isClient()) {
                                try {
                                    map = new HashMap<String, Object>();
                                    map.put("modid", MOD_ID);
                                    map.put("name", new StringBuilder().insert(0, "ModularWarfare : ").append(file.getName()).toString());
                                    map.put("version", "1");
                                    File file3 = file;
                                    container = new FMLModContainer("com.modularwarfare.ModularWarfare", new ModCandidate(file3, file3, file3.isDirectory() ? ContainerType.DIR : ContainerType.JAR), map);
                                    container.bindMetadata(MetadataCollection.from(null, (String)""));
                                    FMLClientHandler.instance().addModAsResource((ModContainer)container);
                                }
                                catch (Exception e2) {
                                    e2.printStackTrace();
                                }
                            }
                            contentPacks.add(file);
                        }
                        catch (Exception e3) {
                            e3.printStackTrace();
                        }
                    } else if (file.isDirectory()) {
                        if (FMLCommonHandler.instance().getSide().isClient()) {
                            try {
                                HashMap<String, String> map = new HashMap<String, String>();
                                map.put("modid", MOD_ID);
                                map.put("name", new StringBuilder().insert(0, "ModularWarfare : ").append(file.getName()).toString());
                                map.put("version", "1");
                                File file4 = file;
                                FMLModContainer container = new FMLModContainer("com.modularwarfare.ModularWarfare", new ModCandidate(file4, file4, file4.isDirectory() ? ContainerType.DIR : ContainerType.JAR), map);
                                container.bindMetadata(MetadataCollection.from(null, (String)""));
                                FMLClientHandler.instance().addModAsResource((ModContainer)container);
                            }
                            catch (Exception e4) {
                                e4.printStackTrace();
                            }
                        }
                        contentPacks.add(file);
                    }
                }
            }
            n7 = ++n;
        }
    }
}

