/*
 * Decompiled with CFR 0.152.
 */
package com.modularwarfare.client.anim;

import com.modularwarfare.ModularWarfare;
import com.modularwarfare.api.WeaponAnimations;
import com.modularwarfare.client.anim.ReloadType;
import com.modularwarfare.client.anim.StateEntry;
import com.modularwarfare.client.anim.StateType;
import com.modularwarfare.client.input.KeyBindingDisable;
import com.modularwarfare.client.input.KeyBindingEnable;
import com.modularwarfare.client.model.ModelGun;
import com.modularwarfare.common.guns.GunType;
import com.modularwarfare.common.guns.ItemGun;
import com.modularwarfare.common.guns.WeaponSoundType;
import com.modularwarfare.common.guns.WeaponType;
import com.modularwarfare.common.network.PacketGunReloadSound;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Optional;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;

public class AnimStateMachine {
    public boolean isGunEmpty;
    public boolean hasPlayedReloadSound;
    private ArrayList<StateEntry> reloadStateEntries;
    private StateEntry currentReloadState;
    public int flashInt;
    public float gunPullback;
    public float revolverBarrelRotationPerShoot;
    private ReloadType reloadType;
    private ArrayList<StateEntry> shootStateEntries;
    public float gunRecoil;
    public int reloadAmmoCount;
    private float shootProgress;
    public boolean reloading;
    public int muzzleFlashTime;
    public float lastGunPullback;
    public float gunSlide;
    private float reloadProgress;
    public float hammerRotation;
    private float shootTime;
    public boolean shooting;
    public float revolverBarrelRotation;
    private float reloadTime;
    private StateEntry currentShootState;
    private int reloadStateIndex;
    public int timeUntilPullback;
    public boolean isFired;
    public int bulletsToRender;
    public float lastGunRecoil;
    public boolean attachmentMode;
    private int shootStateIndex;
    public boolean tiltHold;
    public boolean wasSprinting;
    public ItemStack cachedAmmoStack;
    public float lastGunSlide;

    public Optional<StateEntry> getReloadState() {
        return Optional.ofNullable(this.currentReloadState);
    }

    public void onTickUpdate() {
        AnimStateMachine animStateMachine;
        block24: {
            block23: {
                block22: {
                    AnimStateMachine animStateMachine2;
                    if (this.reloading) {
                        AnimStateMachine.disableSprinting(true);
                        Minecraft.func_71410_x().field_71439_g.func_70031_b(false);
                        if (this.currentReloadState == null) {
                            this.currentReloadState = this.reloadStateEntries.get(0);
                        }
                        if (this.currentReloadState.stateType == StateType.Tilt) {
                            this.tiltHold = true;
                        }
                        if (this.currentReloadState.stateType == StateType.Untilt) {
                            this.tiltHold = false;
                        }
                        AnimStateMachine animStateMachine3 = this;
                        if (animStateMachine3.reloadProgress >= animStateMachine3.currentReloadState.cutOffTime) {
                            if (this.reloadStateIndex + 1 < this.reloadStateEntries.size()) {
                                AnimStateMachine animStateMachine4 = this;
                                ++animStateMachine4.reloadStateIndex;
                                animStateMachine4.currentReloadState.finished = true;
                                animStateMachine4.currentReloadState = animStateMachine4.reloadStateEntries.get(this.reloadStateIndex);
                            }
                        }
                        AnimStateMachine animStateMachine5 = this;
                        animStateMachine5.reloadProgress += 1.0f / this.reloadTime;
                        if (animStateMachine5.reloadProgress >= 0.8f) {
                            AnimStateMachine.disableSprinting(false);
                            Minecraft.func_71410_x().field_71439_g.func_70031_b(this.wasSprinting);
                        }
                        if (this.reloadProgress >= 1.0f) {
                            AnimStateMachine animStateMachine6 = this;
                            AnimStateMachine animStateMachine7 = this;
                            AnimStateMachine animStateMachine8 = this;
                            this.isGunEmpty = false;
                            animStateMachine8.reloading = false;
                            animStateMachine8.reloadProgress = 0.0f;
                            animStateMachine7.reloadStateEntries = null;
                            animStateMachine7.currentReloadState = null;
                            animStateMachine6.reloadStateIndex = 0;
                            animStateMachine6.reloadType = null;
                        }
                        if (!this.hasPlayedReloadSound) {
                            ModularWarfare.NETWORK.sendToServer(new PacketGunReloadSound(WeaponSoundType.Load));
                            this.hasPlayedReloadSound = true;
                        }
                    }
                    if (this.shooting) {
                        if (this.currentShootState == null) {
                            this.currentShootState = this.shootStateEntries.get(0);
                        }
                        AnimStateMachine animStateMachine9 = this;
                        if (animStateMachine9.shootProgress >= animStateMachine9.currentShootState.cutOffTime) {
                            if (this.shootStateIndex + 1 < this.shootStateEntries.size()) {
                                AnimStateMachine animStateMachine10 = this;
                                ++animStateMachine10.shootStateIndex;
                                animStateMachine10.currentShootState.finished = true;
                                animStateMachine10.currentShootState = animStateMachine10.shootStateEntries.get(this.shootStateIndex);
                            }
                        }
                        AnimStateMachine animStateMachine11 = this;
                        animStateMachine11.shootProgress += 1.0f / this.shootTime;
                        if (animStateMachine11.shootProgress >= 1.0f) {
                            AnimStateMachine animStateMachine12 = this;
                            AnimStateMachine animStateMachine13 = this;
                            this.shooting = false;
                            animStateMachine13.shootProgress = 0.0f;
                            animStateMachine13.shootStateEntries = null;
                            animStateMachine12.currentShootState = null;
                            animStateMachine12.shootStateIndex = 0;
                        }
                    }
                    AnimStateMachine animStateMachine14 = this;
                    animStateMachine14.lastGunSlide = animStateMachine14.gunSlide;
                    if (animStateMachine14.isGunEmpty) {
                        AnimStateMachine animStateMachine15 = this;
                        animStateMachine15.gunSlide = 0.5f;
                        animStateMachine15.lastGunSlide = 0.5f;
                    }
                    if (!this.isGunEmpty && (double)this.gunSlide > 0.9) {
                        AnimStateMachine animStateMachine16 = this;
                        animStateMachine2 = animStateMachine16;
                        animStateMachine16.gunSlide -= 0.1f;
                    } else {
                        if (this.gunSlide > 0.0f && !this.isGunEmpty) {
                            this.gunSlide *= 0.5f;
                        }
                        animStateMachine2 = this;
                    }
                    animStateMachine2.lastGunRecoil = this.gunRecoil;
                    if (this.gunRecoil > 0.0f) {
                        this.gunRecoil *= 0.5f;
                    }
                    if (this.isFired) {
                        AnimStateMachine animStateMachine17 = this;
                        animStateMachine17.gunPullback += 0.5f;
                        if (animStateMachine17.gunPullback >= 0.999f) {
                            this.isFired = false;
                        }
                    }
                    if (this.timeUntilPullback <= 0) break block22;
                    AnimStateMachine animStateMachine18 = this;
                    --animStateMachine18.timeUntilPullback;
                    if (animStateMachine18.timeUntilPullback != 0) break block23;
                    AnimStateMachine animStateMachine19 = this;
                    animStateMachine19.isFired = true;
                    animStateMachine19.gunPullback = -1.0f;
                    animStateMachine19.lastGunPullback = -1.0f;
                    animStateMachine = this;
                    break block24;
                }
                this.hammerRotation *= 0.6f;
            }
            animStateMachine = this;
        }
        if (animStateMachine.muzzleFlashTime > 0) {
            --this.muzzleFlashTime;
        }
    }

    public void triggerReload(int reloadTime, int reloadCount, ModelGun model, ReloadType reloadType, boolean wasSprinting) {
        ArrayList<StateEntry> animEntries = WeaponAnimations.getAnimation(model.config.extra.reloadAnimation).getReloadStates(reloadType, reloadCount);
        this.reloadStateEntries = this.adjustTiming(animEntries);
        if (Minecraft.func_71410_x().field_71439_g.func_184582_a(EntityEquipmentSlot.MAINHAND) != null && Minecraft.func_71410_x().field_71439_g.func_184582_a(EntityEquipmentSlot.MAINHAND).func_77973_b() instanceof ItemGun) {
            ItemGun gun = (ItemGun)Minecraft.func_71410_x().field_71439_g.func_184582_a(EntityEquipmentSlot.MAINHAND).func_77973_b();
            if (gun.type.weaponType == WeaponType.Revolver && gun.type.internalAmmoStorage != null) {
                this.bulletsToRender = gun.type.internalAmmoStorage - reloadCount;
            }
        }
        this.reloadTime = reloadType != ReloadType.Full ? (float)reloadTime * 0.65f : (float)reloadTime;
        AnimStateMachine animStateMachine = this;
        AnimStateMachine animStateMachine2 = this;
        animStateMachine2.reloadType = reloadType;
        animStateMachine2.reloading = true;
        animStateMachine.hasPlayedReloadSound = false;
        animStateMachine.wasSprinting = wasSprinting;
    }

    public static void disableSprinting(boolean bool) {
        if (bool) {
            if (!(Minecraft.func_71410_x().field_71474_y.field_151444_V instanceof KeyBindingDisable)) {
                Minecraft.func_71410_x().field_71474_y.field_151444_V = new KeyBindingDisable(Minecraft.func_71410_x().field_71474_y.field_151444_V);
                return;
            }
        } else if (Minecraft.func_71410_x().field_71474_y.field_151444_V instanceof KeyBindingDisable) {
            Minecraft.func_71410_x().field_71474_y.field_151444_V = new KeyBindingEnable(Minecraft.func_71410_x().field_71474_y.field_151444_V);
        }
    }

    public boolean shouldRenderAmmo() {
        if (this.reloading) {
            switch (this.reloadType) {
                case Load: {
                    while (false) {
                    }
                    Optional<StateEntry> state = this.getState(StateType.Load);
                    if (state.isPresent()) {
                        if (state.get().currentValue < 1.0f) {
                            return true;
                        }
                        return false;
                    }
                    return false;
                }
                case Unload: {
                    Optional<StateEntry> state = this.getState(StateType.Unload);
                    if (state.isPresent()) {
                        if (state.get().currentValue < 1.0f) {
                            return true;
                        }
                        return false;
                    }
                    return false;
                }
            }
        }
        return true;
    }

    public AnimStateMachine() {
        AnimStateMachine animStateMachine = this;
        AnimStateMachine animStateMachine2 = this;
        AnimStateMachine animStateMachine3 = this;
        AnimStateMachine animStateMachine4 = this;
        AnimStateMachine animStateMachine5 = this;
        AnimStateMachine animStateMachine6 = this;
        AnimStateMachine animStateMachine7 = this;
        AnimStateMachine animStateMachine8 = this;
        AnimStateMachine animStateMachine9 = this;
        AnimStateMachine animStateMachine10 = this;
        AnimStateMachine animStateMachine11 = this;
        AnimStateMachine animStateMachine12 = this;
        AnimStateMachine animStateMachine13 = this;
        animStateMachine13.reloading = false;
        animStateMachine13.reloadProgress = 0.0f;
        animStateMachine12.reloadStateIndex = 0;
        animStateMachine12.tiltHold = false;
        animStateMachine11.attachmentMode = false;
        animStateMachine11.shooting = false;
        animStateMachine10.shootProgress = 0.0f;
        animStateMachine10.shootStateIndex = 0;
        animStateMachine9.gunRecoil = 0.0f;
        animStateMachine9.lastGunRecoil = 0.0f;
        animStateMachine8.gunSlide = 0.0f;
        animStateMachine8.lastGunSlide = 0.0f;
        animStateMachine7.hammerRotation = 0.0f;
        animStateMachine7.timeUntilPullback = 0;
        animStateMachine6.gunPullback = -1.0f;
        animStateMachine6.lastGunPullback = -1.0f;
        animStateMachine5.isFired = false;
        animStateMachine5.revolverBarrelRotationPerShoot = 0.0f;
        animStateMachine4.revolverBarrelRotation = 0.0f;
        animStateMachine4.bulletsToRender = 1;
        animStateMachine3.reloadAmmoCount = 1;
        animStateMachine3.isGunEmpty = false;
        animStateMachine2.muzzleFlashTime = 0;
        animStateMachine2.flashInt = 0;
        animStateMachine.hasPlayedReloadSound = 0;
        animStateMachine.wasSprinting = false;
    }

    private /* synthetic */ Optional<StateEntry> getState(StateType stateType) {
        StateEntry stateEntry;
        block2: {
            StateEntry stateEntry2 = null;
            if (this.reloadStateEntries == null) {
                return Optional.ofNullable(stateEntry2);
            }
            for (StateEntry entry : this.reloadStateEntries) {
                if (entry.stateType != stateType) continue;
                stateEntry = stateEntry2 = entry;
                break block2;
            }
            stateEntry = stateEntry2;
        }
        return Optional.ofNullable(stateEntry);
    }

    public Optional<StateEntry> getShootState() {
        return Optional.ofNullable(this.currentShootState);
    }

    public void onRenderTickUpdate() {
        if (this.reloading && this.currentReloadState != null) {
            AnimStateMachine animStateMachine = this;
            animStateMachine.currentReloadState.onTick(animStateMachine.reloadTime);
        }
        if (this.shooting && this.currentShootState != null) {
            AnimStateMachine animStateMachine = this;
            animStateMachine.currentShootState.onTick(animStateMachine.shootTime);
        }
    }

    public boolean isShootState(StateType stateType) {
        if (this.currentShootState != null) {
            if (this.currentShootState.stateType == stateType) {
                return true;
            }
            return false;
        }
        return false;
    }

    public void triggerShoot(ModelGun model, GunType gunType, int fireTickDelay) {
        Random r = new Random();
        AnimStateMachine animStateMachine = this;
        animStateMachine.gunRecoil = 1.0f;
        animStateMachine.lastGunRecoil = 1.0f;
        AnimStateMachine animStateMachine2 = this;
        animStateMachine2.gunSlide = 1.0f;
        animStateMachine2.lastGunSlide = 1.0f;
        this.hammerRotation = model.hammerAngle;
        if (gunType.weaponType == WeaponType.Revolver && gunType.internalAmmoStorage != null) {
            this.revolverBarrelRotationPerShoot = 360 / gunType.internalAmmoStorage;
            this.revolverBarrelRotation += this.revolverBarrelRotationPerShoot;
        }
        AnimStateMachine animStateMachine3 = this;
        animStateMachine3.timeUntilPullback = model.hammerDelay;
        animStateMachine3.muzzleFlashTime = 2;
        int Low = 1;
        this.flashInt = r.nextInt(6 - Low) + Low;
        ArrayList<StateEntry> animEntries = WeaponAnimations.getAnimation(model.config.extra.reloadAnimation).getShootStates(model, gunType);
        if (animEntries.size() > 0) {
            AnimStateMachine animStateMachine4 = this;
            this.shootStateEntries = this.adjustTiming(animEntries);
            animStateMachine4.shooting = true;
            animStateMachine4.shootTime = fireTickDelay;
        }
    }

    public boolean isReloadState(StateType stateType) {
        if (this.currentReloadState != null) {
            if (this.currentReloadState.stateType == stateType) {
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean isReloadType(ReloadType type) {
        if (this.reloadType != null && this.reloadType == type) {
            return true;
        }
        return false;
    }

    private /* synthetic */ ArrayList<StateEntry> adjustTiming(ArrayList<StateEntry> animEntries) {
        StateEntry entry;
        Iterator<StateEntry> iterator;
        float currentTiming = 0.0f;
        float dividedAmount = 0.0f;
        float cutOffTime = 0.0f;
        Iterator<StateEntry> iterator2 = iterator = animEntries.iterator();
        while (iterator2.hasNext()) {
            entry = iterator.next();
            currentTiming += entry.stateTime;
            iterator2 = iterator;
        }
        if (currentTiming < 1.0f) {
            dividedAmount = (1.0f - currentTiming) / (float)animEntries.size();
        }
        if (dividedAmount > 0.0f) {
            iterator = animEntries.iterator();
            Iterator<StateEntry> iterator3 = iterator;
            while (iterator3.hasNext()) {
                entry = iterator.next();
                iterator3 = iterator;
                entry.stateTime += dividedAmount;
            }
        }
        iterator = animEntries.iterator();
        Iterator<StateEntry> iterator4 = iterator;
        while (iterator4.hasNext()) {
            entry = iterator.next();
            iterator4 = iterator;
            entry.cutOffTime += (cutOffTime += entry.stateTime);
        }
        return animEntries;
    }
}

