/*
 * Decompiled with CFR 0.152.
 */
package com.modularwarfare.client.anim;

import com.modularwarfare.client.ClientRenderHooks;
import com.modularwarfare.client.anim.StateType;
import com.modularwarfare.common.guns.ItemGun;
import com.modularwarfare.common.guns.WeaponSoundType;
import com.modularwarfare.common.guns.WeaponType;
import com.modularwarfare.utility.NumberHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;

public class StateEntry {
    private float operationCount;
    private float incrementValue;
    public float stateTime;
    public float lastValue;
    public float cutOffTime;
    public boolean finished;
    public StateType stateType;
    private float minValue;
    public float currentValue;
    private float startingValue;
    public static float smoothing = 1.0f;
    private MathType mathType;

    public StateEntry(StateType stateType, float stateTime, float startingValue, MathType mathType) {
        this(stateType, stateTime, startingValue, mathType, 1);
    }

    public void onTick(float reloadTime) {
        StateEntry stateEntry;
        StateEntry stateEntry2 = this;
        stateEntry2.lastValue = stateEntry2.currentValue;
        if (stateEntry2.mathType == MathType.Add) {
            StateEntry stateEntry3 = this;
            stateEntry = stateEntry3;
            this.currentValue += stateEntry3.incrementValue * smoothing / (reloadTime * this.stateTime) * this.operationCount;
        } else {
            if (this.mathType == MathType.Sub) {
                this.currentValue -= this.incrementValue * smoothing / (reloadTime * this.stateTime) * this.operationCount;
            }
            stateEntry = this;
        }
        StateEntry stateEntry4 = this;
        stateEntry.currentValue = NumberHelper.clamp(stateEntry4.currentValue, stateEntry4.minValue, 0.999f);
        if ((this.currentValue == 1.0f || this.currentValue == 0.0f) && this.operationCount > 1.0f) {
            this.currentValue = this.startingValue;
            if (Minecraft.func_71410_x().field_71439_g.func_184582_a(EntityEquipmentSlot.MAINHAND) != null && Minecraft.func_71410_x().field_71439_g.func_184582_a(EntityEquipmentSlot.MAINHAND).func_77973_b() instanceof ItemGun) {
                ItemGun gun = (ItemGun)Minecraft.func_71410_x().field_71439_g.func_184582_a(EntityEquipmentSlot.MAINHAND).func_77973_b();
                if (gun.type.weaponType == WeaponType.Shotgun || gun.type.weaponType == WeaponType.Revolver) {
                    gun.type.playClientSound((EntityPlayer)Minecraft.func_71410_x().field_71439_g, WeaponSoundType.BulletLoad);
                }
            }
            ++ClientRenderHooks.getAnimMachine((EntityPlayer)Minecraft.func_71410_x().field_71439_g).bulletsToRender;
            this.operationCount -= 1.0f;
        }
    }

    public StateEntry(StateType stateType, float stateTime, float startingValue, MathType mathType, int operationCount) {
        StateEntry stateEntry = this;
        StateEntry stateEntry2 = this;
        StateEntry stateEntry3 = this;
        stateEntry3.stateTime = 0.0f;
        stateEntry3.currentValue = 0.0f;
        stateEntry2.lastValue = 0.0f;
        stateEntry2.finished = false;
        stateEntry.stateTime = stateTime;
        stateEntry.currentValue = this.lastValue = startingValue;
        this.startingValue = this.lastValue;
        StateEntry stateEntry4 = this;
        StateEntry stateEntry5 = this;
        this.mathType = mathType;
        stateEntry5.stateType = stateType;
        stateEntry5.minValue = 0.0f;
        stateEntry4.incrementValue = 1.0f;
        stateEntry4.operationCount = operationCount;
    }

    public static final class MathType
    extends Enum<MathType> {
        public static final /* enum */ MathType Sub;
        public static final /* enum */ MathType Add;
        private static final /* synthetic */ MathType[] $VALUES;

        public static MathType valueOf(String name) {
            return Enum.valueOf(MathType.class, name);
        }

        public static MathType[] values() {
            return (MathType[])$VALUES.clone();
        }

        static {
            Add = new MathType("Add", 0);
            Sub = new MathType("Sub", 1);
            MathType[] mathTypeArray = new MathType[2];
            mathTypeArray[0] = Add;
            mathTypeArray[1] = Sub;
            $VALUES = mathTypeArray;
        }

        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        private /* synthetic */ MathType() {
            void var2_-1;
            void var1_-1;
        }
    }
}

