/*
 * Decompiled with CFR 0.152.
 */
package com.modularwarfare.client.model;

import com.modularwarfare.common.vector.Vector3f;
import java.util.ArrayList;
import java.util.Iterator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class InstantBulletRenderer {
    private static TextureManager textureManager;
    private static ArrayList<InstantShotTrail> trails;

    public static void UpdateAllTrails() {
        int i;
        int n = i = trails.size() - 1;
        while (n >= 0) {
            if (trails.get(i).Update()) {
                trails.remove(i);
            }
            n = --i;
        }
    }

    public static void RenderAllTrails(float partialTicks) {
        Iterator<InstantShotTrail> iterator;
        Iterator<InstantShotTrail> iterator2 = iterator = trails.iterator();
        while (iterator2.hasNext()) {
            iterator.next().Render(partialTicks);
            iterator2 = iterator;
        }
    }

    public static void AddTrail(InstantShotTrail trail) {
        trails.add(trail);
    }

    static {
        trails = new ArrayList();
    }

    public static class InstantShotTrail {
        private int ticksExisted;
        private Vector3f origin;
        private float bulletSpeed;
        private Vector3f hitPos;
        private float length;
        private float distanceToTarget;
        private ResourceLocation texture;
        private float width;

        /*
         * WARNING - void declaration
         */
        public InstantShotTrail(Vector3f vector3f, Vector3f vector3f2, float f, boolean bl) {
            InstantShotTrail instantShotTrail;
            void v2;
            void hitPos;
            void origin;
            void bulletSpeed;
            InstantShotTrail instantShotTrail2 = this;
            InstantShotTrail instantShotTrail3 = this;
            this.ticksExisted = 0;
            instantShotTrail3.bulletSpeed = bulletSpeed;
            instantShotTrail3.origin = origin;
            instantShotTrail2.hitPos = hitPos;
            instantShotTrail2.length = 10.0f;
            if (!bl) {
                v2 = hitPos;
                InstantShotTrail instantShotTrail4 = this;
                InstantShotTrail instantShotTrail5 = this;
                instantShotTrail4.texture = new ResourceLocation("modularwarfare", "textures/skins/defaultbullettrail.png");
                instantShotTrail4.width = 0.05f;
            } else {
                this.texture = new ResourceLocation("modularwarfare", "textures/skins/punchedbullettrail.png");
                this.width = 0.1f;
                v2 = hitPos;
            }
            Vector3f dPos = Vector3f.sub((Vector3f)v2, (Vector3f)origin, null);
            this.distanceToTarget = dPos.length();
            if (Math.abs(instantShotTrail.distanceToTarget) > 300.0f) {
                this.distanceToTarget = 300.0f;
            }
        }

        public void Render(float partialTicks) {
            Entity camera;
            if (textureManager == null) {
                textureManager = Minecraft.func_71410_x().field_71446_o;
            }
            textureManager.func_110577_a(this.texture);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179094_E();
            Entity entity = camera = Minecraft.func_71410_x().func_175606_aa();
            double x = camera.field_70142_S + (entity.field_70165_t - camera.field_70142_S) * (double)partialTicks;
            double y = entity.field_70137_T + (camera.field_70163_u - camera.field_70137_T) * (double)partialTicks;
            double z = camera.field_70136_U + (camera.field_70161_v - camera.field_70136_U) * (double)partialTicks;
            GL11.glTranslatef((float)(-((float)x)), (float)(-((float)y)), (float)(-((float)z)));
            InstantShotTrail instantShotTrail = this;
            float parametric = ((float)this.ticksExisted + partialTicks) * instantShotTrail.bulletSpeed;
            Vector3f dPos = Vector3f.sub(instantShotTrail.hitPos, this.origin, null);
            dPos.normalise();
            float startParametric = parametric - this.length * 0.5f;
            Vector3f startPos = new Vector3f(this.origin.x + dPos.x * startParametric, this.origin.y + dPos.y * startParametric, this.origin.z + dPos.z * startParametric);
            float endParametric = parametric + this.length * 0.5f;
            Vector3f endPos = new Vector3f(this.origin.x + dPos.x * endParametric, this.origin.y + dPos.y * endParametric, this.origin.z + dPos.z * endParametric);
            dPos.normalise();
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            Vector3f vectorToPlayer = new Vector3f(player.field_70165_t - (double)this.hitPos.x, player.field_70163_u - (double)this.hitPos.y, player.field_70161_v - (double)this.hitPos.z);
            vectorToPlayer.normalise();
            Vector3f trailTangent = Vector3f.cross(dPos, vectorToPlayer, null);
            trailTangent.normalise();
            trailTangent.scale(-this.width * 0.5f);
            Vector3f normal = Vector3f.cross(trailTangent, dPos, null);
            normal.normalise();
            GlStateManager.func_179091_B();
            Vector3f vector3f = normal;
            GL11.glNormal3f((float)vector3f.x, (float)vector3f.y, (float)normal.z);
            Tessellator tessellator = Tessellator.func_178181_a();
            tessellator.func_178180_c().func_181668_a(7, DefaultVertexFormats.field_181707_g);
            tessellator.func_178180_c().func_181662_b((double)(startPos.x + trailTangent.x), (double)(startPos.y + trailTangent.y), (double)(startPos.z + trailTangent.z)).func_187315_a(0.0, 0.0).func_181675_d();
            tessellator.func_178180_c().func_181662_b((double)(startPos.x - trailTangent.x), (double)(startPos.y - trailTangent.y), (double)(startPos.z - trailTangent.z)).func_187315_a(0.0, 1.0).func_181675_d();
            tessellator.func_178180_c().func_181662_b((double)(endPos.x - trailTangent.x), (double)(endPos.y - trailTangent.y), (double)(endPos.z - trailTangent.z)).func_187315_a(1.0, 1.0).func_181675_d();
            tessellator.func_178180_c().func_181662_b((double)(endPos.x + trailTangent.x), (double)(endPos.y + trailTangent.y), (double)(endPos.z + trailTangent.z)).func_187315_a(1.0, 0.0).func_181675_d();
            tessellator.func_78381_a();
            GlStateManager.func_179101_C();
            GlStateManager.func_179121_F();
        }

        public boolean Update() {
            InstantShotTrail instantShotTrail = this;
            ++instantShotTrail.ticksExisted;
            InstantShotTrail instantShotTrail2 = this;
            if ((float)instantShotTrail.ticksExisted * this.bulletSpeed >= instantShotTrail2.distanceToTarget - instantShotTrail2.length) {
                return true;
            }
            return false;
        }
    }
}

