/*
 * Decompiled with CFR 0.152.
 */
package com.modularwarfare.client.model.animations;

import com.modularwarfare.api.WeaponAnimation;
import com.modularwarfare.client.anim.AnimStateMachine;
import com.modularwarfare.client.anim.ReloadType;
import com.modularwarfare.client.anim.StateEntry;
import com.modularwarfare.client.anim.StateType;
import com.modularwarfare.client.model.ModelGun;
import com.modularwarfare.common.guns.GunType;
import com.modularwarfare.common.guns.WeaponType;
import java.util.ArrayList;
import net.minecraft.util.math.MathHelper;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.Vector3f;

public class AnimationSniperTop
extends WeaponAnimation {
    @Override
    public ArrayList<StateEntry> getShootStates(ModelGun gunModel, GunType gunType) {
        ArrayList<StateEntry> states = new ArrayList<StateEntry>();
        if (gunType.weaponType == WeaponType.BoltSniper) {
            states.add(new StateEntry(StateType.MoveHands, 0.15f, 0.0f, StateEntry.MathType.Add));
            states.add(new StateEntry(StateType.Charge, 0.35f, 1.0f, StateEntry.MathType.Sub));
            states.add(new StateEntry(StateType.Uncharge, 0.35f, 0.0f, StateEntry.MathType.Add));
            states.add(new StateEntry(StateType.ReturnHands, 0.15f, 1.0f, StateEntry.MathType.Sub));
        }
        return states;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ArrayList<StateEntry> getReloadStates(ReloadType reloadType, int reloadCount) {
        void states;
        ArrayList arrayList = new ArrayList();
        states.add(new StateEntry(StateType.Tilt, 0.15f, 0.0f, StateEntry.MathType.Add));
        if (reloadType == ReloadType.Load || reloadType == ReloadType.Full) {
            states.add(new StateEntry(StateType.Load, 0.35f, 1.0f, StateEntry.MathType.Sub));
        }
        void v0 = states;
        v0.add(new StateEntry(StateType.Untilt, 0.15f, 1.0f, StateEntry.MathType.Sub));
        states.add(new StateEntry(StateType.MoveHands, 0.1f, 0.0f, StateEntry.MathType.Add));
        states.add(new StateEntry(StateType.Charge, 0.1f, 1.0f, StateEntry.MathType.Sub));
        states.add(new StateEntry(StateType.Uncharge, 0.1f, 0.0f, StateEntry.MathType.Add));
        states.add(new StateEntry(StateType.ReturnHands, 0.1f, 1.0f, StateEntry.MathType.Sub));
        return v0;
    }

    public AnimationSniperTop() {
        AnimationSniperTop animationSniperTop = this;
        animationSniperTop.ammoLoadOffset = new Vector3f(0.0f, -1.5f, 0.0f);
    }

    @Override
    public void onAmmoAnimation(ModelGun gunModel, float ammoProgress, int reloadAmmoCount, AnimStateMachine animation) {
        float multiAmmoPosition = ammoProgress * 1.0f;
        int bulletNum = MathHelper.func_76141_d((float)multiAmmoPosition);
        float bulletProgress = multiAmmoPosition - (float)bulletNum;
        float modelScale = gunModel.config.extra.modelScale;
        GL11.glRotatef((float)(bulletProgress * 55.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)(bulletProgress * 95.0f), (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glTranslatef((float)(bulletProgress * -0.1f * 1.0f / modelScale), (float)(bulletProgress * 1.0f * 1.0f / modelScale), (float)(bulletProgress * 0.5f * 1.0f / modelScale));
    }

    @Override
    public void onGunAnimation(float tiltProgress, AnimStateMachine animation) {
        GL11.glTranslatef((float)(0.0f * tiltProgress), (float)0.0f, (float)0.0f);
        GL11.glTranslatef((float)0.0f, (float)(0.0f * tiltProgress), (float)0.0f);
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)(-0.2f * tiltProgress));
        GL11.glRotatef((float)(10.0f * tiltProgress), (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)(-10.0f * tiltProgress), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)(15.0f * tiltProgress), (float)0.0f, (float)0.0f, (float)1.0f);
    }
}

