/*
 * Decompiled with CFR 0.152.
 */
package com.modularwarfare.client.model.renders;

import com.modularwarfare.api.WeaponAnimation;
import com.modularwarfare.client.anim.AnimStateMachine;
import com.modularwarfare.client.anim.ReloadType;
import com.modularwarfare.client.anim.StateEntry;
import com.modularwarfare.client.anim.StateType;
import com.modularwarfare.client.model.ModelGun;
import com.modularwarfare.client.model.renders.RenderParameters;
import com.modularwarfare.utility.NumberHelper;
import java.util.Optional;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.Vector3f;

public class RenderArms {
    private static /* synthetic */ void handleRotateRight(Vector3f reloadRot) {
        GL11.glTranslatef((float)-0.225f, (float)0.75f, (float)0.0f);
        Vector3f vector3f = reloadRot;
        GL11.glRotatef((float)vector3f.x, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)vector3f.y, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)vector3f.z, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glTranslatef((float)0.225f, (float)-0.75f, (float)0.0f);
    }

    public static void renderArmDefault(ModelGun model, AnimStateMachine anim, float smoothing, Vector3f reloadRot, Vector3f reloadPos, boolean firingHand, boolean leftHand) {
        Vector3f vector3f = reloadPos;
        GL11.glTranslatef((float)(reloadPos.x - (firingHand ? RenderParameters.triggerPullSwitch : 0.0f)), (float)vector3f.y, (float)vector3f.z);
        if (leftHand) {
            RenderArms.handleRotateLeft(reloadRot);
            return;
        }
        RenderArms.handleRotateRight(reloadRot);
    }

    /*
     * WARNING - void declaration
     */
    public static void renderStaticArmReload(ModelGun model, AnimStateMachine anim, float smoothing, float tiltProgress, Vector3f reloadRot, Vector3f reloadPos, Vector3f defaultRot, Vector3f defaultPos, boolean leftHand) {
        void offsetPosition;
        Vector3f vector3f = NumberHelper.multiplyVector(NumberHelper.subtractVector(reloadPos, defaultPos), tiltProgress);
        GL11.glTranslatef((float)(defaultPos.x + offsetPosition.x), (float)(defaultPos.y + offsetPosition.y), (float)(defaultPos.z + offsetPosition.z));
        Vector3f offsetRotation = NumberHelper.multiplyVector(NumberHelper.subtractVector(reloadRot, defaultRot), tiltProgress);
        if (leftHand) {
            GL11.glTranslatef((float)0.225f, (float)0.75f, (float)0.0f);
            Vector3f vector3f2 = defaultRot;
            GL11.glRotatef((float)(vector3f2.x + offsetRotation.x), (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)(vector3f2.y + offsetRotation.y), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)(vector3f2.z + offsetRotation.z), (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glTranslatef((float)-0.225f, (float)-0.75f, (float)0.0f);
            return;
        }
        GL11.glTranslatef((float)-0.225f, (float)0.75f, (float)0.0f);
        Vector3f vector3f3 = defaultRot;
        GL11.glRotatef((float)(vector3f3.x + offsetRotation.x), (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)(vector3f3.y + offsetRotation.y), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)(vector3f3.z + offsetRotation.z), (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glTranslatef((float)0.225f, (float)-0.75f, (float)0.0f);
    }

    /*
     * WARNING - void declaration
     */
    public static void renderArmReload(ModelGun model, AnimStateMachine anim, WeaponAnimation animation, float smoothing, float tiltProgress, Vector3f reloadRot, Vector3f reloadPos, Vector3f defaultRot, Vector3f defaultPos, boolean leftHand) {
        void ammoLoadOffset;
        Vector3f offsetPosition = NumberHelper.multiplyVector(NumberHelper.subtractVector(reloadPos, defaultPos), tiltProgress);
        AnimStateMachine animStateMachine = anim;
        Optional<StateEntry> currentState = animStateMachine.getReloadState();
        Vector3f vector3f = animStateMachine.isReloadType(ReloadType.Load) && currentState.isPresent() && currentState.get().stateType != StateType.Load && currentState.get().stateType != StateType.Untilt ? (animation.ammoLoadOffset != null ? animation.ammoLoadOffset : new Vector3f(0.0f, 0.0f, 0.0f)) : new Vector3f(0.0f, 0.0f, 0.0f);
        GL11.glTranslatef((float)(defaultPos.x + offsetPosition.x + ammoLoadOffset.x * tiltProgress), (float)0.0f, (float)0.0f);
        GL11.glTranslatef((float)0.0f, (float)(defaultPos.y + offsetPosition.y + ammoLoadOffset.y * tiltProgress), (float)0.0f);
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)(defaultPos.z + offsetPosition.z + ammoLoadOffset.z * tiltProgress));
        Vector3f offsetRotation = NumberHelper.multiplyVector(NumberHelper.subtractVector(reloadRot, defaultRot), tiltProgress);
        if (leftHand) {
            GL11.glTranslatef((float)0.225f, (float)0.75f, (float)0.0f);
            Vector3f vector3f2 = defaultRot;
            GL11.glRotatef((float)(vector3f2.x + offsetRotation.x), (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)(vector3f2.y + offsetRotation.y), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)(vector3f2.z + offsetRotation.z), (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glTranslatef((float)-0.225f, (float)-0.75f, (float)0.0f);
            return;
        }
        GL11.glTranslatef((float)-0.225f, (float)0.75f, (float)0.0f);
        Vector3f vector3f3 = defaultRot;
        GL11.glRotatef((float)(vector3f3.x + offsetRotation.x), (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)(vector3f3.y + offsetRotation.y), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)(vector3f3.z + offsetRotation.z), (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glTranslatef((float)0.225f, (float)-0.75f, (float)0.0f);
    }

    private static /* synthetic */ void handleRotateLeft(Vector3f reloadRot) {
        GL11.glTranslatef((float)0.225f, (float)0.75f, (float)0.0f);
        Vector3f vector3f = reloadRot;
        GL11.glRotatef((float)vector3f.x, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)vector3f.y, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)vector3f.z, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glTranslatef((float)-0.225f, (float)-0.75f, (float)0.0f);
    }

    /*
     * WARNING - void declaration
     */
    public static void renderArmUnload(ModelGun model, AnimStateMachine anim, WeaponAnimation animation, float smoothing, float tiltProgress, Vector3f reloadRot, Vector3f reloadPos, Vector3f defaultRot, Vector3f defaultPos, boolean leftHand) {
        void ammoLoadOffset;
        Vector3f offsetPosition = NumberHelper.multiplyVector(NumberHelper.subtractVector(reloadPos, defaultPos), tiltProgress);
        Vector3f vector3f = anim.isReloadType(ReloadType.Load) ? (animation.ammoLoadOffset != null ? animation.ammoLoadOffset : new Vector3f(0.0f, 0.0f, 0.0f)) : new Vector3f(0.0f, 0.0f, 0.0f);
        GL11.glTranslatef((float)(defaultPos.x + offsetPosition.x + ammoLoadOffset.x * tiltProgress), (float)0.0f, (float)0.0f);
        GL11.glTranslatef((float)0.0f, (float)(defaultPos.y + offsetPosition.y + ammoLoadOffset.y * tiltProgress), (float)0.0f);
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)(defaultPos.z + offsetPosition.z + ammoLoadOffset.z * tiltProgress));
        Vector3f offsetRotation = NumberHelper.multiplyVector(NumberHelper.subtractVector(reloadRot, defaultRot), tiltProgress);
        if (leftHand) {
            GL11.glTranslatef((float)0.225f, (float)0.75f, (float)0.0f);
            Vector3f vector3f2 = defaultRot;
            GL11.glRotatef((float)(vector3f2.x + offsetRotation.x), (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)(vector3f2.y + offsetRotation.y), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)(vector3f2.z + offsetRotation.z), (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glTranslatef((float)-0.225f, (float)-0.75f, (float)0.0f);
            return;
        }
        GL11.glTranslatef((float)-0.225f, (float)0.75f, (float)0.0f);
        Vector3f vector3f3 = defaultRot;
        GL11.glRotatef((float)(vector3f3.x + offsetRotation.x), (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)(vector3f3.y + offsetRotation.y), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)(vector3f3.z + offsetRotation.z), (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glTranslatef((float)0.225f, (float)-0.75f, (float)0.0f);
    }

    public static void renderArmPump(ModelGun model, AnimStateMachine anim, float smoothing, Vector3f reloadRot, Vector3f reloadPos, boolean leftHand) {
        float pumpCurrent;
        Optional<StateEntry> currentShootState = anim.getShootState();
        float f = currentShootState.isPresent() ? (currentShootState.get().stateType == StateType.PumpOut || currentShootState.get().stateType == StateType.PumpIn ? currentShootState.get().currentValue : 1.0f) : (pumpCurrent = 1.0f);
        float pumpLast = currentShootState.isPresent() ? (currentShootState.get().stateType == StateType.PumpOut || currentShootState.get().stateType == StateType.PumpIn ? currentShootState.get().lastValue : 1.0f) : 1.0f;
        ModelGun modelGun = model;
        if (leftHand) {
            float f2 = pumpLast;
            GL11.glTranslatef((float)(modelGun.config.arms.leftArm.armPos.x - (1.0f - Math.abs(f2 + (pumpCurrent - f2) * smoothing)) * model.config.bolt.pumpHandleDistance), (float)model.config.arms.leftArm.armPos.y, (float)model.config.arms.leftArm.armPos.z);
            RenderArms.handleRotateLeft(reloadRot);
            return;
        }
        float f3 = pumpLast;
        GL11.glTranslatef((float)(modelGun.config.arms.rightArm.armPos.x - (1.0f - Math.abs(f3 + (pumpCurrent - f3) * smoothing)) * model.config.bolt.pumpHandleDistance), (float)model.config.arms.rightArm.armPos.y, (float)model.config.arms.rightArm.armPos.z);
        RenderArms.handleRotateRight(reloadRot);
    }

    public static void renderArmBolt(ModelGun model, AnimStateMachine anim, float smoothing, Vector3f reloadRot, Vector3f reloadPos, boolean leftHand) {
        float pumpLast;
        float pumpCurrent;
        Optional<StateEntry> currentShootState = anim.getShootState();
        float f = currentShootState.isPresent() ? (currentShootState.get().stateType == StateType.Charge || currentShootState.get().stateType == StateType.Uncharge ? currentShootState.get().currentValue : 1.0f) : (pumpCurrent = 1.0f);
        float f2 = currentShootState.isPresent() ? (currentShootState.get().stateType == StateType.Charge || currentShootState.get().stateType == StateType.Uncharge ? currentShootState.get().lastValue : 1.0f) : (pumpLast = 1.0f);
        if (anim.isReloadState(StateType.Charge) || anim.isReloadState(StateType.Uncharge)) {
            StateEntry stateEntry = anim.getReloadState().get();
            pumpCurrent = stateEntry.currentValue;
            pumpLast = stateEntry.lastValue;
        }
        float f3 = pumpLast;
        GL11.glTranslatef((float)(reloadPos.x - (1.0f - Math.abs(f3 + (pumpCurrent - f3) * smoothing)) * model.config.bolt.chargeModifier.x), (float)0.0f, (float)0.0f);
        float f4 = pumpLast;
        GL11.glTranslatef((float)0.0f, (float)(reloadPos.y - (1.0f - Math.abs(f4 + (pumpCurrent - f4) * smoothing)) * model.config.bolt.chargeModifier.y), (float)0.0f);
        float f5 = pumpLast;
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)(reloadPos.z - (1.0f - Math.abs(f5 + (pumpCurrent - f5) * smoothing)) * model.config.bolt.chargeModifier.z));
        Vector3f vector3f = reloadRot;
        if (leftHand) {
            RenderArms.handleRotateLeft(vector3f);
            return;
        }
        RenderArms.handleRotateRight(vector3f);
    }

    /*
     * WARNING - void declaration
     */
    public static void renderToFrom(ModelGun model, AnimStateMachine anim, float smoothing, Vector3f targetRot, Vector3f targetPos, Vector3f originRot, Vector3f originPos, boolean leftHand) {
        float progress;
        float f = anim.getReloadState().isPresent() ? anim.getReloadState().get().currentValue : (progress = anim.getShootState().isPresent() ? anim.getShootState().get().currentValue : 1.0f);
        if (NumberHelper.subtractVector(targetPos, originPos) != null) {
            void cancelOut;
            Vector3f offsetPosition = NumberHelper.multiplyVector(NumberHelper.subtractVector(targetPos, originPos), progress);
            float f2 = anim.getReloadState().isPresent() ? (anim.getReloadState().get().stateType == StateType.ReturnHands ? 0.0f : 1.0f) : (anim.getShootState().isPresent() ? (anim.getShootState().get().stateType == StateType.ReturnHands ? 0.0f : 1.0f) : 1.0f);
            GL11.glTranslatef((float)(originPos.x + offsetPosition.x + cancelOut * (Math.abs(1.0f + 0.0f * smoothing) * (model.config.bolt.chargeModifier.x * model.config.extra.modelScale))), (float)0.0f, (float)0.0f);
            GL11.glTranslatef((float)0.0f, (float)(originPos.y + offsetPosition.y + cancelOut * (Math.abs(1.0f + 0.0f * smoothing) * (model.config.bolt.chargeModifier.y * model.config.extra.modelScale))), (float)0.0f);
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)(originPos.z + offsetPosition.z + cancelOut * (Math.abs(1.0f + 0.0f * smoothing) * (model.config.bolt.chargeModifier.z * model.config.extra.modelScale))));
            Vector3f offsetRotation = NumberHelper.multiplyVector(NumberHelper.subtractVector(targetRot, originRot), progress);
            if (leftHand) {
                GL11.glTranslatef((float)0.225f, (float)0.75f, (float)0.0f);
                Vector3f vector3f = originRot;
                GL11.glRotatef((float)(vector3f.x + offsetRotation.x), (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)(vector3f.y + offsetRotation.y), (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glRotatef((float)(vector3f.z + offsetRotation.z), (float)0.0f, (float)0.0f, (float)1.0f);
                GL11.glTranslatef((float)-0.225f, (float)-0.75f, (float)0.0f);
                return;
            }
            GL11.glTranslatef((float)-0.225f, (float)0.75f, (float)0.0f);
            Vector3f vector3f = originRot;
            GL11.glRotatef((float)(vector3f.x + offsetRotation.x), (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)(vector3f.y + offsetRotation.y), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)(vector3f.z + offsetRotation.z), (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glTranslatef((float)0.225f, (float)-0.75f, (float)0.0f);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void renderArmLoad(ModelGun model, AnimStateMachine anim, WeaponAnimation animation, float smoothing, float tiltProgress, Vector3f reloadRot, Vector3f reloadPos, Vector3f defaultRot, Vector3f defaultPos, boolean leftHand) {
        void ammoLoadOffset;
        Vector3f offsetPosition = NumberHelper.multiplyVector(NumberHelper.subtractVector(reloadPos, defaultPos), tiltProgress);
        AnimStateMachine animStateMachine = anim;
        Optional<StateEntry> currentState = animStateMachine.getReloadState();
        Vector3f vector3f = animStateMachine.isReloadType(ReloadType.Load) && currentState.isPresent() && currentState.get().stateType != StateType.Load ? (animation.ammoLoadOffset != null ? animation.ammoLoadOffset : new Vector3f(0.0f, 0.0f, 0.0f)) : new Vector3f(0.0f, 0.0f, 0.0f);
        GL11.glTranslatef((float)(defaultPos.x + offsetPosition.x + ammoLoadOffset.x * tiltProgress), (float)0.0f, (float)0.0f);
        GL11.glTranslatef((float)0.0f, (float)(defaultPos.y + offsetPosition.y + ammoLoadOffset.y * tiltProgress), (float)0.0f);
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)(defaultPos.z + offsetPosition.z + ammoLoadOffset.z * tiltProgress));
        Vector3f offsetRotation = NumberHelper.multiplyVector(NumberHelper.subtractVector(reloadRot, defaultRot), tiltProgress);
        if (leftHand) {
            GL11.glTranslatef((float)0.225f, (float)0.75f, (float)0.0f);
            Vector3f vector3f2 = defaultRot;
            GL11.glRotatef((float)(vector3f2.x + offsetRotation.x), (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)(vector3f2.y + offsetRotation.y), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)(vector3f2.z + offsetRotation.z), (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glTranslatef((float)-0.225f, (float)-0.75f, (float)0.0f);
            return;
        }
        GL11.glTranslatef((float)-0.225f, (float)0.75f, (float)0.0f);
        Vector3f vector3f3 = defaultRot;
        GL11.glRotatef((float)(vector3f3.x + offsetRotation.x), (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)(vector3f3.y + offsetRotation.y), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)(vector3f3.z + offsetRotation.z), (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glTranslatef((float)0.225f, (float)-0.75f, (float)0.0f);
    }

    /*
     * WARNING - void declaration
     */
    public static void renderArmCharge(ModelGun model, AnimStateMachine anim, float smoothing, Vector3f reloadRot, Vector3f reloadPos, Vector3f defaultRot, Vector3f defaultPos, boolean leftHand) {
        void chargeLast;
        float chargeCurrent;
        Vector3f offsetPosition = NumberHelper.multiplyVector(NumberHelper.subtractVector(reloadPos, defaultPos), 1.0f);
        Optional<StateEntry> currentReloadState = anim.getReloadState();
        float f = currentReloadState.isPresent() ? (currentReloadState.get().stateType == StateType.Charge || currentReloadState.get().stateType == StateType.Uncharge ? currentReloadState.get().currentValue : 1.0f) : (chargeCurrent = 1.0f);
        float f2 = currentReloadState.isPresent() ? (currentReloadState.get().stateType == StateType.Charge || currentReloadState.get().stateType == StateType.Uncharge ? currentReloadState.get().lastValue : 1.0f) : 1.0f;
        void v1 = chargeLast;
        GL11.glTranslatef((float)(defaultPos.x + offsetPosition.x + Math.abs((float)(v1 + (chargeCurrent - v1) * smoothing)) * (model.config.extra.chargeHandleDistance * model.config.extra.modelScale)), (float)0.0f, (float)0.0f);
        GL11.glTranslatef((float)0.0f, (float)(defaultPos.y + offsetPosition.y), (float)0.0f);
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)(defaultPos.z + offsetPosition.z));
        Vector3f offsetRotation = NumberHelper.multiplyVector(NumberHelper.subtractVector(reloadRot, defaultRot), 1.0f);
        if (leftHand) {
            GL11.glTranslatef((float)0.225f, (float)0.75f, (float)0.0f);
            Vector3f vector3f = defaultRot;
            GL11.glRotatef((float)(vector3f.x + offsetRotation.x), (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)(vector3f.y + offsetRotation.y), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)(vector3f.z + offsetRotation.z), (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glTranslatef((float)-0.225f, (float)-0.75f, (float)0.0f);
            return;
        }
        GL11.glTranslatef((float)-0.225f, (float)0.75f, (float)0.0f);
        Vector3f vector3f = defaultRot;
        GL11.glRotatef((float)(vector3f.x + offsetRotation.x), (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)(vector3f.y + offsetRotation.y), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)(vector3f.z + offsetRotation.z), (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glTranslatef((float)0.225f, (float)-0.75f, (float)0.0f);
    }
}

