/*
 * Decompiled with CFR 0.152.
 */
package com.modularwarfare.common.backpacks;

import com.modularwarfare.ModularWarfare;
import com.modularwarfare.client.config.BackpackRenderConfig;
import com.modularwarfare.client.model.ModelBackpack;
import com.modularwarfare.common.type.BaseType;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;

public class BackpackType
extends BaseType {
    public int size;
    public boolean allowSmallerBackpackStorage;
    public Integer maxWeaponStorage;

    @Override
    public void reloadModel() {
        BackpackType backpackType = this;
        this.model = new ModelBackpack(ModularWarfare.getRenderConfig(this, BackpackRenderConfig.class), this);
    }

    @Override
    public void loadExtraValues() {
        if (this.maxStackSize == null) {
            this.maxStackSize = 1;
        }
        this.loadBaseValues();
    }

    public BackpackType() {
        BackpackType backpackType = this;
        this.size = 16;
        backpackType.allowSmallerBackpackStorage = false;
        backpackType.maxWeaponStorage = null;
    }

    @Override
    public String getAssetDir() {
        return "backpacks";
    }

    public static class Provider
    implements ICapabilitySerializable<NBTBase> {
        final IItemHandlerModifiable items;

        public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
            if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
                return true;
            }
            return false;
        }

        @Nullable
        public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
            if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
                return (T)this.items;
            }
            return null;
        }

        public NBTBase serializeNBT() {
            return CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.writeNBT((Object)this.items, null);
        }

        public void deserializeNBT(NBTBase nbt) {
            CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.readNBT((Object)this.items, null, nbt);
        }

        /*
         * WARNING - void declaration
         */
        public Provider(BackpackType backpackType) {
            void type;
            Provider provider = this;
            provider.items = new ItemStackHandler(type.size);
        }
    }
}

