/*
 * Decompiled with CFR 0.152.
 */
package com.modularwarfare.common.capability.extraslots;

import com.modularwarfare.ModConfig;
import com.modularwarfare.ModularWarfare;
import com.modularwarfare.common.capability.extraslots.ExtraContainer;
import com.modularwarfare.common.capability.extraslots.ExtraContainerProvider;
import com.modularwarfare.common.capability.extraslots.IExtraItemHandler;
import com.modularwarfare.common.network.PacketSyncExtraSlot;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.player.PlayerDropsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber(modid="modularwarfare")
public class CapabilityExtra {
    @CapabilityInject(value=IExtraItemHandler.class)
    public static final Capability<IExtraItemHandler> CAPABILITY = null;

    @SubscribeEvent
    public static void onPlayerJoin(EntityJoinWorldEvent event) {
        if (event.getWorld().field_72995_K || !(event.getEntity() instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer entityPlayer = (EntityPlayer)event.getEntity();
        CapabilityExtra.sync(entityPlayer, Collections.singletonList(entityPlayer));
    }

    @SubscribeEvent
    public static void onStartTracking(PlayerEvent.StartTracking event) {
        if (event.getTarget().field_70170_p.field_72995_K || !(event.getTarget() instanceof EntityPlayer)) {
            return;
        }
        CapabilityExtra.sync((EntityPlayer)event.getTarget(), Collections.singletonList(event.getEntityPlayer()));
    }

    @SubscribeEvent
    public static void attachCapabilities(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof EntityPlayer) {
            event.addCapability(new ResourceLocation("modularwarfare", "extraslots"), (ICapabilityProvider)new ExtraContainerProvider(new ExtraContainer((EntityPlayer)event.getObject())));
        }
    }

    /*
     * WARNING - void declaration
     */
    @SubscribeEvent
    public static void playerDeath(PlayerDropsEvent event) {
        int i;
        EntityPlayer player = event.getEntityPlayer();
        World world = player.field_70170_p;
        if (world.field_72995_K || world.func_82736_K().func_82766_b("keepInventory") || !ModConfig.INSTANCE.dropExtraSlotsOnDeath) {
            return;
        }
        int n = i = 0;
        while (n < ((IExtraItemHandler)player.getCapability(CAPABILITY, (EnumFacing)null)).getSlots()) {
            void item;
            ItemStack extra = ((IExtraItemHandler)player.getCapability(CAPABILITY, (EnumFacing)null)).getStackInSlot(i);
            if (extra.func_190926_b()) {
                return;
            }
            EntityItem entityItem = new EntityItem(world, player.field_70165_t, player.field_70163_u + (double)player.func_70047_e(), player.field_70161_v, extra);
            void v1 = item;
            World world2 = world;
            item.func_174867_a(40);
            float f1 = world2.field_73012_v.nextFloat() * 0.5f;
            float f2 = world2.field_73012_v.nextFloat() * (float)Math.PI * 2.0f;
            item.field_70159_w = -MathHelper.func_76126_a((float)f2) * f1;
            v1.field_70179_y = MathHelper.func_76134_b((float)f2) * f1;
            v1.field_70181_x = 0.2f;
            event.getDrops().add(item);
            ((IExtraItemHandler)player.getCapability(CAPABILITY, (EnumFacing)null)).setStackInSlot(i++, ItemStack.field_190927_a);
            n = i;
        }
    }

    public static void sync(EntityPlayer entity, Collection<? extends EntityPlayer> receivers) {
        int i;
        int n = i = 0;
        while (n < ((IExtraItemHandler)entity.getCapability(CAPABILITY, (EnumFacing)null)).getSlots()) {
            EntityPlayer entityPlayer = entity;
            PacketSyncExtraSlot msg = new PacketSyncExtraSlot(entityPlayer, i, ((IExtraItemHandler)entityPlayer.getCapability(CAPABILITY, (EnumFacing)null)).getStackInSlot(i));
            receivers.forEach(p -> ModularWarfare.NETWORK.sendTo(msg, (EntityPlayerMP)p));
            n = ++i;
        }
    }

    public static class Storage
    implements Capability.IStorage<IExtraItemHandler> {
        public void readNBT(Capability<IExtraItemHandler> capability, IExtraItemHandler instance, EnumFacing side, NBTBase nbt) {
        }

        @Nullable
        public NBTBase writeNBT(Capability<IExtraItemHandler> capability, IExtraItemHandler instance, EnumFacing side) {
            return null;
        }
    }
}

