/*
 * Decompiled with CFR 0.152.
 */
package com.modularwarfare.common.guns;

import com.modularwarfare.ModularWarfare;
import com.modularwarfare.client.ClientProxy;
import com.modularwarfare.client.config.GunRenderConfig;
import com.modularwarfare.client.model.ModelGun;
import com.modularwarfare.common.guns.AttachmentEnum;
import com.modularwarfare.common.guns.ItemGun;
import com.modularwarfare.common.guns.WeaponFireMode;
import com.modularwarfare.common.guns.WeaponScopeType;
import com.modularwarfare.common.guns.WeaponSoundType;
import com.modularwarfare.common.guns.WeaponType;
import com.modularwarfare.common.network.PacketPlaySound;
import com.modularwarfare.common.type.BaseType;
import com.modularwarfare.objects.SoundEntry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class GunType
extends BaseType {
    public float recoilPitch;
    public boolean dynamicAmmo;
    public float gunDamageHeadshotBonus;
    public boolean dropBulletCasing;
    public Vec3d shellEjectOffsetAiming;
    public WeaponType weaponType;
    public float gunDamage;
    public boolean allowSprintFiring;
    public int reloadTime;
    public transient int fireTickDelay;
    public WeaponScopeType scopeType;
    public float moveSpeedModifier;
    @SideOnly(value=Side.CLIENT)
    public ModelBiped.ArmPose armPose;
    public float bulletSpread;
    public WeaponFireMode[] fireModes;
    @SideOnly(value=Side.CLIENT)
    public ModelBiped.ArmPose armPoseAiming;
    private SoundEntry[] weaponSounds;
    public String[] acceptedAmmo;
    public int weaponEffectiveRange;
    public boolean allowDefaultSounds;
    public int numBullets;
    public int weaponMaxRange;
    public float randomRecoilYaw;
    public float recoilAimReducer;
    public HashMap<WeaponSoundType, ArrayList<SoundEntry>> weaponSoundMap;
    public Vec3d shellEjectOffsetNormal;
    public float accuracySneakFactor;
    public int numBurstRounds;
    public float randomRecoilPitch;
    public HashMap<AttachmentEnum, ArrayList<String>> acceptedAttachments;
    public float recoilYaw;
    public int roundsPerMin;
    public boolean isEnergyGun;
    public String[] acceptedBullets;
    public float emptyPitch;
    public Integer offhandReloadTime;
    public Integer internalAmmoStorage;

    public void playClientSound(EntityPlayer player, WeaponSoundType weaponSoundType) {
        if (this.weaponSoundMap.containsKey((Object)weaponSoundType)) {
            Iterator<SoundEntry> iterator;
            Iterator<SoundEntry> iterator2 = iterator = this.weaponSoundMap.get((Object)weaponSoundType).iterator();
            while (iterator2.hasNext()) {
                SoundEntry soundEntry = iterator.next();
                EntityPlayer entityPlayer = player;
                Minecraft.func_71410_x().field_71441_e.func_184133_a(entityPlayer, entityPlayer.func_180425_c(), ClientProxy.modSounds.get(soundEntry.soundName), SoundCategory.PLAYERS, 1.0f, 1.0f);
                iterator2 = iterator;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void loadExtraValues() {
        if (this.maxStackSize == null) {
            this.maxStackSize = 1;
        }
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            GunType gunType = this;
            gunType.armPose = ModelBiped.ArmPose.BLOCK;
            gunType.armPoseAiming = ModelBiped.ArmPose.BOW_AND_ARROW;
        }
        this.loadBaseValues();
        this.fireTickDelay = 1200 / this.roundsPerMin;
        try {
            Iterator<ArrayList<SoundEntry>> iterator = this.weaponSoundMap.values().iterator();
            while (iterator.hasNext()) {
                for (SoundEntry soundEntry : iterator.next()) {
                    if (soundEntry.soundName != null) {
                        ModularWarfare.PROXY.registerSound(soundEntry.soundName);
                        if (soundEntry.soundNameDistant == null) continue;
                        ModularWarfare.PROXY.registerSound(soundEntry.soundNameDistant);
                        continue;
                    }
                    Object[] objectArray = new Object[2];
                    objectArray[0] = soundEntry.soundEvent;
                    objectArray[1] = this.internalName;
                    ModularWarfare.LOGGER.error(String.format("Sound entry event '%s' has null soundName for type '%s'", objectArray));
                }
            }
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void removeAttachment(ItemStack heldStack, AttachmentEnum type) {
        if (heldStack.func_77978_p() != null) {
            void nbtTagCompound;
            NBTTagCompound nBTTagCompound = heldStack.func_77978_p();
            nbtTagCompound.func_82580_o("attachment_" + type.typeName);
        }
    }

    public void playSound(EntityLivingBase entityPlayer, WeaponSoundType weaponSoundType, ItemStack gunStack) {
        this.playSound(entityPlayer, weaponSoundType, gunStack, null);
    }

    public GunType() {
        GunType gunType = this;
        GunType gunType2 = this;
        GunType gunType3 = this;
        GunType gunType4 = this;
        GunType gunType5 = this;
        GunType gunType6 = this;
        GunType gunType7 = this;
        GunType gunType8 = this;
        this.scopeType = WeaponScopeType.DEFAULT;
        this.gunDamage = 0.0f;
        gunType8.moveSpeedModifier = 1.0f;
        gunType8.gunDamageHeadshotBonus = 0.0f;
        gunType7.weaponMaxRange = 200;
        gunType7.weaponEffectiveRange = 50;
        gunType6.numBullets = 1;
        gunType6.roundsPerMin = 1;
        gunType5.fireTickDelay = 0;
        gunType5.numBurstRounds = 3;
        gunType4.isEnergyGun = false;
        gunType4.recoilPitch = 10.0f;
        gunType3.recoilYaw = 1.0f;
        gunType3.accuracySneakFactor = 0.75f;
        gunType2.randomRecoilPitch = 0.5f;
        gunType2.randomRecoilYaw = 0.5f;
        gunType.recoilAimReducer = 0.8f;
        WeaponFireMode[] weaponFireModeArray = new WeaponFireMode[1];
        weaponFireModeArray[0] = WeaponFireMode.SEMI;
        gunType.fireModes = weaponFireModeArray;
        GunType gunType9 = this;
        GunType gunType10 = this;
        GunType gunType11 = this;
        this.reloadTime = 40;
        gunType11.dropBulletCasing = true;
        gunType11.dynamicAmmo = false;
        gunType10.allowSprintFiring = true;
        gunType10.allowDefaultSounds = true;
        GunType gunType12 = this;
        gunType9.shellEjectOffsetNormal = new Vec3d(-1.0, 0.0, 1.0);
        GunType gunType13 = this;
        gunType9.shellEjectOffsetAiming = new Vec3d(0.0, (double)0.12f, 1.0);
        gunType9.emptyPitch = 0.05f;
    }

    @Override
    public String getAssetDir() {
        return "guns";
    }

    public void playSoundPos(BlockPos pos, World world, WeaponSoundType weaponSoundType) {
        this.playSoundPos(pos, world, weaponSoundType, null, 1.0f);
    }

    public static boolean isPackAPunched(ItemStack heldStack) {
        if (heldStack.func_77978_p() != null) {
            NBTTagCompound nbtTagCompound = heldStack.func_77978_p();
            if (nbtTagCompound.func_74764_b("punched")) {
                return nbtTagCompound.func_74767_n("punched");
            }
            return false;
        }
        return false;
    }

    public void playSoundPos(BlockPos pos, World world, WeaponSoundType weaponSoundType, EntityPlayer excluded, float volume) {
        block3: {
            block4: {
                if (weaponSoundType == null) break block3;
                if (!this.weaponSoundMap.containsKey((Object)weaponSoundType)) break block4;
                Random random = new Random();
                for (SoundEntry soundEntry : this.weaponSoundMap.get((Object)weaponSoundType)) {
                    int soundRange = soundEntry.soundRange != null ? soundEntry.soundRange : weaponSoundType.defaultRange;
                    for (EntityPlayer hearingPlayer : world.func_175644_a(EntityPlayer.class, e -> {
                        if (e.func_180425_c().func_185332_f(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()) <= (double)soundRange) {
                            return true;
                        }
                        return false;
                    })) {
                        if (hearingPlayer.equals((Object)excluded)) continue;
                        ModularWarfare.NETWORK.sendTo(new PacketPlaySound(pos, soundEntry.soundName, (float)(soundRange / 16) * soundEntry.soundVolumeMultiplier * volume, random.nextFloat() / soundEntry.soundRandomPitch + soundEntry.soundPitch), (EntityPlayerMP)hearingPlayer);
                    }
                }
                break block3;
            }
            if (!this.allowDefaultSounds || weaponSoundType.defaultSound == null) break block3;
            Random random = new Random();
            WeaponSoundType weaponSoundType2 = weaponSoundType;
            String soundName = weaponSoundType2.defaultSound;
            float soundRange = weaponSoundType2.defaultRange.intValue();
            for (EntityPlayer hearingPlayer : world.func_175644_a(EntityPlayer.class, e -> {
                if (e.func_180425_c().func_185332_f(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()) <= (double)soundRange) {
                    return true;
                }
                return false;
            })) {
                if (hearingPlayer.equals((Object)excluded)) continue;
                ModularWarfare.NETWORK.sendTo(new PacketPlaySound(pos, soundName, soundRange / 16.0f * 1.0f, random.nextFloat() / 5.0f + 1.0f), (EntityPlayerMP)hearingPlayer);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void addAttachment(ItemStack heldStack, AttachmentEnum type, ItemStack attachment) {
        if (heldStack.func_77978_p() != null) {
            void nbtTagCompound;
            NBTTagCompound nBTTagCompound = heldStack.func_77978_p();
            nbtTagCompound.func_74782_a("attachment_" + type.typeName, (NBTBase)attachment.func_77955_b(new NBTTagCompound()));
        }
    }

    public void playSound(EntityLivingBase entityPlayer, WeaponSoundType weaponSoundType, ItemStack gunStack, @Nullable EntityPlayer excluded) {
        block9: {
            Iterator iterator;
            block10: {
                if (weaponSoundType == null) break block9;
                if (!this.weaponSoundMap.containsKey((Object)weaponSoundType)) break block10;
                EntityLivingBase entityLivingBase = entityPlayer;
                BlockPos originPos = entityLivingBase.func_180425_c();
                World world = entityLivingBase.field_70170_p;
                Random random = new Random();
                for (SoundEntry soundEntry : this.weaponSoundMap.get((Object)weaponSoundType)) {
                    int soundRange = soundEntry.soundRange != null ? soundEntry.soundRange : weaponSoundType.defaultRange;
                    if (soundEntry.soundNameDistant != null && soundEntry.soundMaxRange != null) {
                        int maxSoundRange = soundEntry.soundMaxRange;
                        for (EntityPlayer hearingPlayer : world.func_175644_a(EntityPlayer.class, e -> {
                            if (e.func_180425_c().func_185332_f(originPos.func_177958_n(), originPos.func_177956_o(), originPos.func_177952_p()) <= (double)maxSoundRange) {
                                return true;
                            }
                            return false;
                        })) {
                            Random random2;
                            double d;
                            boolean bl;
                            if (hearingPlayer.equals((Object)excluded)) continue;
                            double distance = hearingPlayer.func_180425_c().func_185332_f(originPos.func_177958_n(), originPos.func_177956_o(), originPos.func_177952_p());
                            float volume = 0.0f;
                            String soundName = "";
                            if (distance > (double)soundRange) {
                                bl = true;
                                d = distance;
                            } else {
                                bl = false;
                                d = distance;
                            }
                            boolean bl2 = d <= (double)maxSoundRange;
                            SoundEntry soundEntry2 = soundEntry;
                            if (bl & bl2) {
                                soundName = soundEntry2.soundNameDistant;
                                volume = (float)((distance + (double)(maxSoundRange / 6)) / 16.0 * (double)soundEntry.soundFarVolumeMultiplier);
                                random2 = random;
                            } else {
                                soundName = soundEntry2.soundName;
                                volume = (float)((distance + (double)(maxSoundRange / 6)) / 16.0 * (double)soundEntry.soundVolumeMultiplier);
                                random2 = random;
                            }
                            float customPitch = random2.nextFloat() / soundEntry.soundRandomPitch + soundEntry.soundPitch;
                            float modifyPitch = ItemGun.getMagazineBullets(gunStack) <= 5 && this.emptyPitch != 0.0f ? 0.3f - this.emptyPitch * (float)ItemGun.getMagazineBullets(gunStack) : 0.0f;
                            ModularWarfare.NETWORK.sendTo(new PacketPlaySound(originPos, soundName, volume, customPitch += modifyPitch), (EntityPlayerMP)hearingPlayer);
                        }
                        continue;
                    }
                    for (EntityPlayer hearingPlayer : world.func_175644_a(EntityPlayer.class, e -> {
                        if (e.func_180425_c().func_185332_f(originPos.func_177958_n(), originPos.func_177956_o(), originPos.func_177952_p()) <= (double)soundRange) {
                            return true;
                        }
                        return false;
                    })) {
                        if (hearingPlayer.equals((Object)excluded)) continue;
                        ModularWarfare.NETWORK.sendTo(new PacketPlaySound(originPos, soundEntry.soundName, (float)(soundRange / 16) * soundEntry.soundVolumeMultiplier, random.nextFloat() / soundEntry.soundRandomPitch + soundEntry.soundPitch), (EntityPlayerMP)hearingPlayer);
                    }
                }
                break block9;
            }
            if (!this.allowDefaultSounds || weaponSoundType.defaultSound == null) break block9;
            EntityLivingBase entityLivingBase = entityPlayer;
            BlockPos originPos = entityLivingBase.func_180425_c();
            World world = entityLivingBase.field_70170_p;
            Random random = new Random();
            WeaponSoundType weaponSoundType2 = weaponSoundType;
            String soundName = weaponSoundType2.defaultSound;
            float soundRange = weaponSoundType2.defaultRange.intValue();
            Iterator iterator2 = iterator = world.func_175644_a(EntityPlayer.class, e -> {
                if (e.func_180425_c().func_185332_f(originPos.func_177958_n(), originPos.func_177956_o(), originPos.func_177952_p()) <= (double)soundRange) {
                    return true;
                }
                return false;
            }).iterator();
            while (iterator2.hasNext()) {
                EntityPlayer hearingPlayer = (EntityPlayer)iterator.next();
                ModularWarfare.NETWORK.sendTo(new PacketPlaySound(originPos, soundName, soundRange / 16.0f * 1.0f, random.nextFloat() / 5.0f + 1.0f), (EntityPlayerMP)hearingPlayer);
                iterator2 = iterator;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public static ItemStack getAttachment(ItemStack heldStack, AttachmentEnum type) {
        if (heldStack.func_77978_p() != null) {
            void nbtTagCompound;
            NBTTagCompound nBTTagCompound = heldStack.func_77978_p();
            if (nbtTagCompound.func_74764_b("attachment_" + type.typeName)) {
                return new ItemStack(nbtTagCompound.func_74775_l("attachment_" + type.typeName));
            }
            return null;
        }
        return null;
    }

    public static WeaponFireMode getFireMode(ItemStack heldStack) {
        if (heldStack.func_77978_p() != null) {
            NBTTagCompound nbtTagCompound = heldStack.func_77978_p();
            if (nbtTagCompound.func_74764_b("firemode")) {
                return WeaponFireMode.fromString(nbtTagCompound.func_74779_i("firemode"));
            }
            return null;
        }
        return null;
    }

    public static void setFireMode(ItemStack heldStack, WeaponFireMode fireMode) {
        if (heldStack.func_77978_p() != null) {
            ItemStack itemStack = heldStack;
            NBTTagCompound nBTTagCompound = itemStack.func_77978_p();
            nBTTagCompound.func_74778_a("firemode", fireMode.name().toLowerCase());
            itemStack.func_77982_d(nBTTagCompound);
        }
    }

    public static void setPackAPunched(ItemStack heldStack, boolean bool) {
        if (heldStack.func_77978_p() != null) {
            ItemStack itemStack = heldStack;
            NBTTagCompound nBTTagCompound = itemStack.func_77978_p();
            nBTTagCompound.func_74757_a("punched", bool);
            itemStack.func_77982_d(nBTTagCompound);
        }
    }

    public boolean hasFireMode(WeaponFireMode fireMode) {
        if (this.fireModes != null) {
            int i;
            int n = i = 0;
            while (n < this.fireModes.length) {
                if (this.fireModes[i] == fireMode) {
                    return true;
                }
                n = ++i;
            }
        }
        return false;
    }

    @Override
    public void reloadModel() {
        GunType gunType = this;
        this.model = new ModelGun(ModularWarfare.getRenderConfig(this, GunRenderConfig.class), this);
    }
}

