/*
 * Decompiled with CFR 0.152.
 */
package com.modularwarfare.common.guns;

import com.modularwarfare.ModularWarfare;
import com.modularwarfare.common.guns.AmmoType;
import com.modularwarfare.common.guns.GunType;
import com.modularwarfare.common.guns.ItemBullet;
import com.modularwarfare.common.guns.ItemGun;
import com.modularwarfare.common.network.PacketGunReload;
import com.modularwarfare.common.type.BaseItem;
import com.modularwarfare.common.type.BaseType;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemAmmo
extends BaseItem {
    public AmmoType type;
    public static final Function<AmmoType, ItemAmmo> factory = type -> new ItemAmmo((AmmoType)type);

    public boolean func_77651_p() {
        return true;
    }

    public static ItemBullet getUsedBullet(ItemStack gunStack) {
        if (ItemGun.hasAmmoLoaded(gunStack)) {
            ItemStack ammoStack = new ItemStack(gunStack.func_77978_p().func_74775_l("ammo"));
            if (ammoStack.func_77942_o() && ammoStack.func_77978_p().func_74764_b("bullet")) {
                ItemStack usedBullet = new ItemStack(ammoStack.func_77978_p().func_74775_l("bullet"));
                return (ItemBullet)usedBullet.func_77973_b();
            }
            GunType gunType = ((ItemGun)gunStack.func_77973_b()).type;
            if (gunType.acceptedAmmo != null && ((ItemAmmo)ammoStack.func_77973_b()).type.subAmmo != null) {
                return ModularWarfare.bulletTypes.get(((ItemAmmo)ammoStack.func_77973_b()).type.subAmmo[0]);
            }
        }
        return null;
    }

    public static boolean hasAmmo(ItemStack ammoStack) {
        if (ammoStack.func_77978_p() != null) {
            NBTTagCompound nbtTagCompound = ammoStack.func_77978_p();
            if (nbtTagCompound.func_74764_b("magcount")) {
                int i;
                ItemAmmo itemAmmo = (ItemAmmo)ammoStack.func_77973_b();
                int n = i = 0;
                while (n < itemAmmo.type.magazineCount) {
                    if (nbtTagCompound.func_74762_e("ammocount" + i) > 0) {
                        return true;
                    }
                    n = ++i;
                }
            } else {
                if (nbtTagCompound.func_74762_e("ammocount") > 0) {
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack ammoStack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        ItemStack itemStack;
        if (this.type.magazineCount == 1) {
            List<String> list;
            int currentAmmoCount = 0;
            if (ammoStack.func_77978_p() != null) {
                NBTTagCompound tag = ammoStack.func_77978_p();
                currentAmmoCount = tag.func_74764_b("ammocount") ? tag.func_74762_e("ammocount") : 0;
                list = tooltip;
            } else {
                currentAmmoCount = this.type.ammoCapacity;
                list = tooltip;
            }
            list.add(this.generateLoreLineAlt("Ammo", Integer.toString(currentAmmoCount), Integer.toString(this.type.ammoCapacity)));
            itemStack = ammoStack;
        } else {
            if (ammoStack.func_77978_p() != null) {
                int i;
                String baseDisplayLine = "%bMag Ammo %s: %g%s%dg/%g%s";
                baseDisplayLine = "%bMag Ammo %s: %g%s%dg/%g%s".replaceAll("%b", TextFormatting.BLUE.toString());
                baseDisplayLine = baseDisplayLine.replaceAll("%g", TextFormatting.GRAY.toString());
                baseDisplayLine = baseDisplayLine.replaceAll("%dg", TextFormatting.DARK_GRAY.toString());
                int n = i = 1;
                while (true) {
                    if (n >= this.type.magazineCount + 1) break;
                    NBTTagCompound tag = ammoStack.func_77978_p();
                    Object[] objectArray = new Object[3];
                    objectArray[0] = i;
                    objectArray[1] = tag.func_74762_e("ammocount" + i);
                    objectArray[2] = this.type.ammoCapacity;
                    tooltip.add(String.format(baseDisplayLine, objectArray));
                    n = ++i;
                }
            }
            itemStack = ammoStack;
        }
        if (itemStack.func_77978_p() != null && ammoStack.func_77978_p().func_74764_b("bullet")) {
            ItemStack usedBullet = new ItemStack(ammoStack.func_77978_p().func_74775_l("bullet"));
            ItemBullet usedBulletItem = (ItemBullet)usedBullet.func_77973_b();
            tooltip.add(this.generateLoreLine("Bullet", usedBulletItem.type.displayName));
        }
        tooltip.add(new StringBuilder().insert(0, "").append(TextFormatting.BLUE.toString()).append("Accepted bullets:").toString());
        if (((ItemAmmo)ammoStack.func_77973_b()).type.subAmmo != null && ((ItemAmmo)ammoStack.func_77973_b()).type.subAmmo.length > 0) {
            int n;
            String[] stringArray = ((ItemAmmo)ammoStack.func_77973_b()).type.subAmmo;
            int n2 = ((ItemAmmo)ammoStack.func_77973_b()).type.subAmmo.length;
            int n3 = n = 0;
            while (n3 < n2) {
                String bulletName;
                String internalName = stringArray[n];
                if (ModularWarfare.bulletTypes.containsKey(internalName) && (bulletName = ModularWarfare.bulletTypes.get((Object)internalName).type.displayName) != null) {
                    tooltip.add("- " + bulletName);
                }
                n3 = ++n;
            }
        }
        tooltip.add("\u00a7e[R] to reload");
    }

    /*
     * WARNING - void declaration
     */
    public ItemAmmo(AmmoType ammoType) {
        void type;
        ItemAmmo itemAmmo = this;
        void v1 = type;
        super((BaseType)v1);
        itemAmmo.type = v1;
        itemAmmo.field_77777_bU = ammoType.subAmmo != null ? 1 : type.maxStackSize;
        this.render3d = false;
        this.func_77656_e(type.ammoCapacity);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        if (((ItemAmmo)stack.func_77973_b()).type.subAmmo != null) {
            ModularWarfare.NETWORK.sendToServer(new PacketGunReload());
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)stack);
    }

    @Override
    public void setType(BaseType type) {
        this.type = (AmmoType)type;
    }

    /*
     * WARNING - void declaration
     */
    public void func_77663_a(ItemStack heldStack, World world, Entity holdingEntity, int intI, boolean flag) {
        if (heldStack.func_77978_p() == null && !world.field_72995_K) {
            void nbtTagCompound;
            ItemAmmo itemAmmo = (ItemAmmo)heldStack.func_77973_b();
            NBTTagCompound nBTTagCompound = new NBTTagCompound();
            ItemAmmo itemAmmo2 = itemAmmo;
            void v1 = nbtTagCompound;
            v1.func_74768_a("ammocount", itemAmmo.type.ammoCapacity);
            v1.func_74768_a("skinId", 0);
            this.func_77656_e(itemAmmo2.type.ammoCapacity);
            if (itemAmmo2.type.magazineCount > 1) {
                int i;
                nbtTagCompound.func_74768_a("magcount", 1);
                int n = i = 1;
                while (true) {
                    if (n >= itemAmmo.type.magazineCount + 1) break;
                    String string = "ammocount" + i;
                    nbtTagCompound.func_74768_a(string, itemAmmo.type.ammoCapacity);
                    n = ++i;
                }
            }
            if (itemAmmo.type.subAmmo != null) {
                if (itemAmmo.type.subAmmo[0] != null) {
                    ItemBullet bullet = ModularWarfare.bulletTypes.get(itemAmmo.type.subAmmo[0]);
                    if (bullet != null) {
                        ItemStack bulletStack = new ItemStack((Item)bullet);
                        nbtTagCompound.func_74782_a("bullet", (NBTBase)bulletStack.func_77955_b(new NBTTagCompound()));
                    }
                }
            }
            heldStack.func_77982_d((NBTTagCompound)nbtTagCompound);
        }
    }
}

