/*
 * Decompiled with CFR 0.152.
 */
package com.modularwarfare.common.hitbox.maths;

import com.modularwarfare.common.vector.Matrix4f;
import com.modularwarfare.common.vector.Vector3f;

public class RotatedAxes {
    private Matrix4f rotationMatrix;
    private float rotationYaw;
    private float rotationPitch;
    private float rotationRoll;

    public Matrix4f getMatrix() {
        return this.rotationMatrix;
    }

    public RotatedAxes(Matrix4f matrix4f) {
        RotatedAxes rotatedAxes = this;
        rotatedAxes.rotationMatrix = matrix4f;
        rotatedAxes.convertMatrixToAngles();
    }

    public RotatedAxes() {
        RotatedAxes rotatedAxes = this;
        rotatedAxes.rotationMatrix = new Matrix4f();
    }

    public boolean isValid() {
        if (this.rotationMatrix.determinant() == 0.0f) {
            return false;
        }
        if (Float.isNaN(this.rotationMatrix.determinant())) {
            return false;
        }
        return true;
    }

    public RotatedAxes rotateGlobalPitchInRads(float f) {
        RotatedAxes rotatedAxes = this;
        this.rotationMatrix.rotate(f, new Vector3f(0.0f, 0.0f, 1.0f));
        rotatedAxes.convertMatrixToAngles();
        return rotatedAxes;
    }

    public Vector3f findGlobalVectorLocally(Vector3f in) {
        Matrix4f mat = new Matrix4f();
        Vector3f vector3f = in;
        mat.m00 = in.x;
        mat.m10 = vector3f.y;
        mat.m20 = vector3f.z;
        mat.rotate(-this.rotationYaw * (float)Math.PI / 180.0f, new Vector3f(0.0f, 1.0f, 0.0f));
        mat.rotate(-this.rotationPitch * (float)Math.PI / 180.0f, new Vector3f(0.0f, 0.0f, 1.0f));
        mat.rotate(-this.rotationRoll * (float)Math.PI / 180.0f, new Vector3f(1.0f, 0.0f, 0.0f));
        Matrix4f matrix4f = mat;
        return new Vector3f(matrix4f.m00, matrix4f.m10, mat.m20);
    }

    /*
     * WARNING - void declaration
     */
    public RotatedAxes clone() {
        void newAxes;
        RotatedAxes rotatedAxes = new RotatedAxes();
        void v0 = newAxes;
        rotatedAxes.rotationMatrix.load(this.getMatrix());
        super.convertMatrixToAngles();
        return v0;
    }

    public void rotateLocal(float rotateBy, Vector3f rotateAround) {
        this.rotationMatrix.rotate(rotateBy * (float)Math.PI / 180.0f, this.findLocalVectorGlobally(rotateAround));
        this.convertMatrixToAngles();
    }

    public RotatedAxes rotateGlobalPitch(float f) {
        RotatedAxes rotatedAxes = this;
        this.rotationMatrix.rotate(f * (float)Math.PI / 180.0f, new Vector3f(0.0f, 0.0f, 1.0f));
        rotatedAxes.convertMatrixToAngles();
        return rotatedAxes;
    }

    public RotatedAxes rotateGlobalRoll(float f) {
        RotatedAxes rotatedAxes = this;
        this.rotationMatrix.rotate(f * (float)Math.PI / 180.0f, new Vector3f(1.0f, 0.0f, 0.0f));
        rotatedAxes.convertMatrixToAngles();
        return rotatedAxes;
    }

    /*
     * WARNING - void declaration
     */
    public void setAngles(float f, float f2, float f3) {
        void pitch;
        void yaw;
        this.rotationYaw = yaw;
        this.rotationPitch = pitch;
        this.rotationRoll = f3;
        this.convertAnglesToMatrix();
    }

    public RotatedAxes rotateGlobalYawInRads(float f) {
        RotatedAxes rotatedAxes = this;
        this.rotationMatrix.rotate(f, new Vector3f(0.0f, 1.0f, 0.0f));
        rotatedAxes.convertMatrixToAngles();
        return rotatedAxes;
    }

    public void rotateGlobal(float rotateBy, Vector3f rotateAround) {
        this.rotationMatrix.rotate(rotateBy * (float)Math.PI / 180.0f, rotateAround);
        this.convertMatrixToAngles();
    }

    public float getYaw() {
        return this.rotationYaw;
    }

    public void rotateLocalPitch(float rotateBy) {
        this.rotationMatrix.rotate(rotateBy * (float)Math.PI / 180.0f, this.getZAxis().normalise(null));
        this.convertMatrixToAngles();
    }

    public Vector3f findLocalVectorGlobally(Vector3f in) {
        Matrix4f mat = new Matrix4f();
        Vector3f vector3f = in;
        mat.m00 = in.x;
        mat.m10 = vector3f.y;
        mat.m20 = vector3f.z;
        mat.rotate(this.rotationRoll * (float)Math.PI / 180.0f, new Vector3f(1.0f, 0.0f, 0.0f));
        mat.rotate(this.rotationPitch * (float)Math.PI / 180.0f, new Vector3f(0.0f, 0.0f, 1.0f));
        mat.rotate(this.rotationYaw * (float)Math.PI / 180.0f, new Vector3f(0.0f, 1.0f, 0.0f));
        Matrix4f matrix4f = mat;
        return new Vector3f(matrix4f.m00, matrix4f.m10, mat.m20);
    }

    public float getRoll() {
        return this.rotationRoll;
    }

    private /* synthetic */ void convertAnglesToMatrix() {
        this.rotationMatrix = new Matrix4f();
        this.rotationMatrix.rotate(this.rotationRoll * (float)Math.PI / 180.0f, new Vector3f(1.0f, 0.0f, 0.0f));
        RotatedAxes rotatedAxes = this;
        rotatedAxes.rotationMatrix.rotate(rotatedAxes.rotationPitch * (float)Math.PI / 180.0f, new Vector3f(0.0f, 0.0f, 1.0f));
        RotatedAxes rotatedAxes2 = this;
        rotatedAxes2.rotationMatrix.rotate(rotatedAxes2.rotationYaw * (float)Math.PI / 180.0f, new Vector3f(0.0f, 1.0f, 0.0f));
        this.convertMatrixToAngles();
    }

    /*
     * WARNING - void declaration
     */
    public RotatedAxes(float f, float f2, float f3) {
        void roll;
        void pitch;
        RotatedAxes rotatedAxes = this;
        rotatedAxes.setAngles(f, (float)pitch, (float)roll);
    }

    public RotatedAxes rotateGlobalRollInRads(float f) {
        RotatedAxes rotatedAxes = this;
        this.rotationMatrix.rotate(f, new Vector3f(1.0f, 0.0f, 0.0f));
        rotatedAxes.convertMatrixToAngles();
        return rotatedAxes;
    }

    public Vector3f getYAxis() {
        return new Vector3f(this.rotationMatrix.m01, this.rotationMatrix.m11, this.rotationMatrix.m21);
    }

    public RotatedAxes rotateGlobalYaw(float f) {
        RotatedAxes rotatedAxes = this;
        this.rotationMatrix.rotate(f * (float)Math.PI / 180.0f, new Vector3f(0.0f, 1.0f, 0.0f));
        rotatedAxes.convertMatrixToAngles();
        return rotatedAxes;
    }

    public float getPitch() {
        return this.rotationPitch;
    }

    public void rotateLocalRoll(float rotateBy) {
        this.rotationMatrix.rotate(rotateBy * (float)Math.PI / 180.0f, this.getXAxis().normalise(null));
        this.convertMatrixToAngles();
    }

    private /* synthetic */ void convertMatrixToAngles() {
        RotatedAxes rotatedAxes = this;
        this.rotationYaw = (float)Math.atan2(rotatedAxes.rotationMatrix.m20, this.rotationMatrix.m00) * 180.0f / (float)Math.PI;
        rotatedAxes.rotationPitch = (float)Math.atan2(-rotatedAxes.rotationMatrix.m10, Math.sqrt(this.rotationMatrix.m12 * this.rotationMatrix.m12 + this.rotationMatrix.m11 * this.rotationMatrix.m11)) * 180.0f / (float)Math.PI;
        rotatedAxes.rotationRoll = (float)Math.atan2(rotatedAxes.rotationMatrix.m12, this.rotationMatrix.m11) * 180.0f / (float)Math.PI;
    }

    public RotatedAxes findLocalAxesGlobally(RotatedAxes in) {
        Matrix4f mat = new Matrix4f();
        mat.load(in.getMatrix());
        mat.rotate(this.rotationRoll * (float)Math.PI / 180.0f, new Vector3f(1.0f, 0.0f, 0.0f));
        mat.rotate(this.rotationPitch * (float)Math.PI / 180.0f, new Vector3f(0.0f, 0.0f, 1.0f));
        mat.rotate(this.rotationYaw * (float)Math.PI / 180.0f, new Vector3f(0.0f, 1.0f, 0.0f));
        return new RotatedAxes(mat);
    }

    public String toString() {
        return new StringBuilder().insert(0, "RotatedAxes[Yaw = ").append(this.getYaw()).append(", Pitch = ").append(this.getPitch()).append(", Roll = ").append(this.getRoll()).append("]").toString();
    }

    public void rotateLocalYaw(float rotateBy) {
        this.rotationMatrix.rotate(rotateBy * (float)Math.PI / 180.0f, this.getYAxis().normalise(null));
        this.convertMatrixToAngles();
    }

    public Vector3f getZAxis() {
        return new Vector3f(-this.rotationMatrix.m02, -this.rotationMatrix.m12, -this.rotationMatrix.m22);
    }

    public Vector3f getXAxis() {
        return new Vector3f(this.rotationMatrix.m00, this.rotationMatrix.m10, this.rotationMatrix.m20);
    }
}

