/*
 * Decompiled with CFR 0.152.
 */
package com.modularwarfare.common.network;

import com.modularwarfare.ModularWarfare;
import com.modularwarfare.common.network.PacketAimingReponse;
import com.modularwarfare.common.network.PacketAimingRequest;
import com.modularwarfare.common.network.PacketBase;
import com.modularwarfare.common.network.PacketBulletSnap;
import com.modularwarfare.common.network.PacketClientAnimation;
import com.modularwarfare.common.network.PacketDecal;
import com.modularwarfare.common.network.PacketGunAddAttachment;
import com.modularwarfare.common.network.PacketGunFire;
import com.modularwarfare.common.network.PacketGunReload;
import com.modularwarfare.common.network.PacketGunReloadSound;
import com.modularwarfare.common.network.PacketGunSwitchMode;
import com.modularwarfare.common.network.PacketGunTrail;
import com.modularwarfare.common.network.PacketGunUnloadAttachment;
import com.modularwarfare.common.network.PacketOpenExtraArmorInventory;
import com.modularwarfare.common.network.PacketOpenGui;
import com.modularwarfare.common.network.PacketOpenNormalInventory;
import com.modularwarfare.common.network.PacketPlayHitmarker;
import com.modularwarfare.common.network.PacketPlaySound;
import com.modularwarfare.common.network.PacketSyncBackWeapons;
import com.modularwarfare.common.network.PacketSyncExtraSlot;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageCodec;
import io.netty.util.AttributeKey;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.INetHandler;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.network.Packet;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.FMLEmbeddedChannel;
import net.minecraftforge.fml.common.network.FMLOutboundHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.internal.FMLProxyPacket;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@ChannelHandler.Sharable
public class NetworkHandler
extends MessageToMessageCodec<FMLProxyPacket, PacketBase> {
    private LinkedList<Class<? extends PacketBase>> packets;
    private ConcurrentLinkedQueue<PacketBase> receivedPacketsClient;
    private boolean modInitialised;
    private EnumMap<Side, FMLEmbeddedChannel> channels;
    private HashMap<String, ConcurrentLinkedQueue<PacketBase>> receivedPacketsServer;

    public void handleClientPackets() {
        PacketBase packet;
        PacketBase packetBase = packet = this.receivedPacketsClient.poll();
        while (packetBase != null) {
            NetworkHandler networkHandler = this;
            packet.handleClientSide(networkHandler.getClientPlayer());
            packetBase = networkHandler.receivedPacketsClient.poll();
        }
    }

    public void handleServerPackets() {
        for (String playerName : this.receivedPacketsServer.keySet()) {
            ConcurrentLinkedQueue<PacketBase> receivedPacketsFromPlayer = this.receivedPacketsServer.get(playerName);
            EntityPlayerMP player = FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_152612_a(playerName);
            PacketBase packetBase = receivedPacketsFromPlayer.poll();
            while (packetBase != null) {
                PacketBase packet;
                packet.handleServerSide(player);
                packetBase = receivedPacketsFromPlayer.poll();
            }
        }
    }

    public void initialise() {
        ChannelHandler[] channelHandlerArray = new ChannelHandler[1];
        channelHandlerArray[0] = this;
        this.channels = NetworkRegistry.INSTANCE.newChannel("ModularWarfare", channelHandlerArray);
        this.registerPacket(PacketGunFire.class);
        this.registerPacket(PacketPlaySound.class);
        this.registerPacket(PacketPlayHitmarker.class);
        this.registerPacket(PacketGunSwitchMode.class);
        this.registerPacket(PacketGunReload.class);
        this.registerPacket(PacketGunReloadSound.class);
        this.registerPacket(PacketGunAddAttachment.class);
        this.registerPacket(PacketGunUnloadAttachment.class);
        this.registerPacket(PacketClientAnimation.class);
        this.registerPacket(PacketGunTrail.class);
        this.registerPacket(PacketAimingRequest.class);
        this.registerPacket(PacketAimingReponse.class);
        this.registerPacket(PacketDecal.class);
        this.registerPacket(PacketOpenNormalInventory.class);
        this.registerPacket(PacketOpenExtraArmorInventory.class);
        this.registerPacket(PacketSyncBackWeapons.class);
        this.registerPacket(PacketBulletSnap.class);
        this.registerPacket(PacketSyncExtraSlot.class);
        this.registerPacket(PacketOpenGui.class);
    }

    public NetworkHandler() {
        NetworkHandler networkHandler = this;
        this.packets = new LinkedList();
        this.modInitialised = false;
        NetworkHandler networkHandler2 = this;
        this.receivedPacketsClient = new ConcurrentLinkedQueue();
        NetworkHandler networkHandler3 = this;
        networkHandler2.receivedPacketsServer = new HashMap();
    }

    public void sendToServer(Packet packet) {
        Minecraft.func_71410_x().field_71439_g.field_71174_a.func_147297_a(packet);
    }

    public void sendToAllAround(Packet packet, NetworkRegistry.TargetPoint point) {
        FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_148543_a(null, point.x, point.y, point.z, point.range, point.dimension, packet);
    }

    protected void encode(ChannelHandlerContext ctx, PacketBase msg, List<Object> out) throws Exception {
        try {
            ByteBuf encodedData = Unpooled.buffer();
            Class<?> cl = msg.getClass();
            if (!this.packets.contains(cl)) {
                throw new NullPointerException(new StringBuilder().insert(0, "Packet not registered : ").append(cl.getCanonicalName()).toString());
            }
            byte discriminator = (byte)this.packets.indexOf(cl);
            encodedData.writeByte((int)discriminator);
            msg.encodeInto(ctx, encodedData);
            FMLProxyPacket proxyPacket = new FMLProxyPacket(new PacketBuffer(encodedData.copy()), (String)ctx.channel().attr(NetworkRegistry.FML_CHANNEL).get());
            out.add(proxyPacket);
            return;
        }
        catch (Exception e) {
            ModularWarfare.LOGGER.error("ERROR encoding packet");
            ModularWarfare.LOGGER.throwing((Throwable)e);
            return;
        }
    }

    public void sendTo(Packet packet, EntityPlayerMP player) {
        player.field_71135_a.func_147359_a(packet);
    }

    public void sendToServer(PacketBase packet) {
        this.channels.get(Side.CLIENT).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.TOSERVER);
        this.channels.get(Side.CLIENT).writeAndFlush((Object)packet);
    }

    public void sendToAllTracking(PacketBase packet, Entity entity) {
        this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.TRACKING_ENTITY);
        this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)entity);
        this.channels.get(Side.SERVER).writeAndFlush((Object)packet);
    }

    public void sendTo(PacketBase packet, EntityPlayerMP player) {
        this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.PLAYER);
        this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)player);
        this.channels.get(Side.SERVER).writeAndFlush((Object)packet);
    }

    public void sendToAllAround(PacketBase packet, double x, double y, double z, float range, int dimension) {
        this.sendToAllAround(packet, new NetworkRegistry.TargetPoint(dimension, x, y, z, (double)range));
    }

    public void postInitialise() {
        if (this.modInitialised) {
            return;
        }
        this.modInitialised = true;
        Collections.sort(this.packets, new Comparator<Class<? extends PacketBase>>(){

            @Override
            public int compare(Class<? extends PacketBase> c1, Class<? extends PacketBase> c2) {
                int com = String.CASE_INSENSITIVE_ORDER.compare(c1.getCanonicalName(), c2.getCanonicalName());
                if (com == 0) {
                    com = c1.getCanonicalName().compareTo(c2.getCanonicalName());
                }
                return com;
            }
        });
    }

    public void sendToDimension(PacketBase packet, int dimensionID) {
        this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.DIMENSION);
        this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)dimensionID);
        this.channels.get(Side.SERVER).writeAndFlush((Object)packet);
    }

    public void sendToAll(PacketBase packet) {
        this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.ALL);
        this.channels.get(Side.SERVER).writeAndFlush((Object)packet);
    }

    public boolean registerPacket(Class<? extends PacketBase> cl) {
        if (this.packets.size() > 256) {
            ModularWarfare.LOGGER.warn(new StringBuilder().insert(0, "Packet limit exceeded in Modular Warfare packet handler by packet ").append(cl.getCanonicalName()).append(".").toString());
            return false;
        }
        if (this.packets.contains(cl)) {
            ModularWarfare.LOGGER.warn(new StringBuilder().insert(0, "Tried to register ").append(cl.getCanonicalName()).append(" packet class twice.").toString());
            return false;
        }
        if (this.modInitialised) {
            ModularWarfare.LOGGER.warn(new StringBuilder().insert(0, "Tried to register packet ").append(cl.getCanonicalName()).append(" after mod initialisation.").toString());
            return false;
        }
        this.packets.add(cl);
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    private /* synthetic */ EntityPlayer getClientPlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }

    public void sendToAllAround(PacketBase packet, NetworkRegistry.TargetPoint point) {
        this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.ALLAROUNDPOINT);
        this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)point);
        this.channels.get(Side.SERVER).writeAndFlush((Object)packet);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void decode(ChannelHandlerContext ctx, FMLProxyPacket msg, List<Object> out) throws Exception {
        PacketBase packet;
        try {
            void encodedData;
            ByteBuf byteBuf = msg.payload();
            byte discriminator = encodedData.readByte();
            Class<? extends PacketBase> cl = this.packets.get(discriminator);
            if (cl == null) {
                throw new NullPointerException(new StringBuilder().insert(0, "Packet not registered for discriminator : ").append(discriminator).toString());
            }
            packet = cl.newInstance();
            packet.decodeInto(ctx, encodedData.slice());
            switch (FMLCommonHandler.instance().getEffectiveSide()) {
                case CLIENT: {
                    this.receivedPacketsClient.offer(packet);
                    return;
                }
                case SERVER: {
                    break;
                }
                default: {
                    return;
                }
            }
        }
        catch (Exception e) {
            ModularWarfare.LOGGER.error("ERROR decoding packet");
            ModularWarfare.LOGGER.throwing((Throwable)e);
            return;
        }
        {
            EntityPlayerMP player = ((NetHandlerPlayServer)((INetHandler)ctx.channel().attr((AttributeKey)NetworkRegistry.NET_HANDLER).get())).field_147369_b;
            if (!this.receivedPacketsServer.containsKey(player.func_70005_c_())) {
                this.receivedPacketsServer.put(player.func_70005_c_(), new ConcurrentLinkedQueue());
            }
            this.receivedPacketsServer.get(player.func_70005_c_()).offer(packet);
            return;
        }
    }

    public void sendToDimension(Packet packet, int dimensionID) {
        FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_148537_a(packet, dimensionID);
    }

    public void sendToAll(Packet packet) {
        FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_148540_a(packet);
    }
}

