/*
 * Decompiled with CFR 0.152.
 */
package com.modularwarfare.common.vector;

import com.modularwarfare.common.vector.Matrix;
import com.modularwarfare.common.vector.Vector2f;
import com.modularwarfare.common.vector.Vector3f;
import com.modularwarfare.common.vector.Vector4f;
import java.io.Serializable;
import java.nio.FloatBuffer;

public class Matrix4f
extends Matrix
implements Serializable {
    public float m21;
    public float m00;
    public float m01;
    public float m03;
    public float m13;
    public float m23;
    private static final long serialVersionUID = 1L;
    public float m30;
    public float m33;
    public float m12;
    public float m20;
    public float m32;
    public float m31;
    public float m02;
    public float m11;
    public float m10;
    public float m22;

    public static Matrix4f transpose(Matrix4f src, Matrix4f dest) {
        if (dest == null) {
            dest = new Matrix4f();
        }
        Matrix4f matrix4f = src;
        float m00 = matrix4f.m00;
        float m01 = matrix4f.m10;
        float m02 = matrix4f.m20;
        float m03 = matrix4f.m30;
        float m10 = matrix4f.m01;
        float m11 = matrix4f.m11;
        float m12 = matrix4f.m21;
        float m13 = matrix4f.m31;
        float m20 = matrix4f.m02;
        float m21 = matrix4f.m12;
        float m22 = matrix4f.m22;
        float m23 = matrix4f.m32;
        float m30 = matrix4f.m03;
        float m31 = matrix4f.m13;
        float m32 = matrix4f.m23;
        Matrix4f matrix4f2 = dest;
        Matrix4f matrix4f3 = dest;
        Matrix4f matrix4f4 = dest;
        Matrix4f matrix4f5 = dest;
        Matrix4f matrix4f6 = dest;
        Matrix4f matrix4f7 = dest;
        Matrix4f matrix4f8 = dest;
        matrix4f8.m00 = m00;
        matrix4f8.m01 = m01;
        matrix4f7.m02 = m02;
        matrix4f7.m03 = m03;
        matrix4f6.m10 = m10;
        matrix4f6.m11 = m11;
        matrix4f5.m12 = m12;
        matrix4f5.m13 = m13;
        matrix4f4.m20 = m20;
        matrix4f4.m21 = m21;
        matrix4f3.m22 = m22;
        matrix4f3.m23 = m23;
        matrix4f2.m30 = m30;
        matrix4f2.m31 = m31;
        dest.m32 = m32;
        dest.m33 = matrix4f.m33;
        return dest;
    }

    /*
     * WARNING - void declaration
     */
    public static Matrix4f rotate(float angle, Vector3f axis, Matrix4f src, Matrix4f dest) {
        void oneminusc;
        if (dest == null) {
            dest = new Matrix4f();
        }
        float c = (float)Math.cos(angle);
        float s = (float)Math.sin(angle);
        float f = 1.0f - c;
        Vector3f vector3f = axis;
        Vector3f vector3f2 = axis;
        float xy = vector3f.x * vector3f2.y;
        float yz = vector3f.y * axis.z;
        float xz = vector3f2.x * axis.z;
        float xs = vector3f.x * s;
        float ys = vector3f.y * s;
        float zs = vector3f.z * s;
        float f00 = vector3f.x * axis.x * oneminusc + c;
        float f01 = xy * oneminusc + zs;
        float f02 = xz * oneminusc - ys;
        float f10 = xy * oneminusc - zs;
        float f11 = vector3f.y * axis.y * oneminusc + c;
        float f12 = yz * oneminusc + xs;
        float f20 = xz * oneminusc + ys;
        float f21 = yz * oneminusc - xs;
        float f22 = vector3f.z * axis.z * oneminusc + c;
        Matrix4f matrix4f = src;
        Matrix4f matrix4f2 = src;
        float t00 = matrix4f.m00 * f00 + matrix4f2.m10 * f01 + src.m20 * f02;
        float t01 = matrix4f.m01 * f00 + src.m11 * f01 + src.m21 * f02;
        float t02 = matrix4f2.m02 * f00 + src.m12 * f01 + src.m22 * f02;
        float t03 = matrix4f.m03 * f00 + src.m13 * f01 + src.m23 * f02;
        float t10 = matrix4f.m00 * f10 + src.m10 * f11 + src.m20 * f12;
        float t11 = matrix4f.m01 * f10 + src.m11 * f11 + src.m21 * f12;
        float t12 = matrix4f.m02 * f10 + src.m12 * f11 + src.m22 * f12;
        Matrix4f matrix4f3 = dest;
        Matrix4f matrix4f4 = dest;
        Matrix4f matrix4f5 = dest;
        Matrix4f matrix4f6 = dest;
        Matrix4f matrix4f7 = dest;
        Matrix4f matrix4f8 = src;
        matrix4f7.m20 = src.m00 * f20 + matrix4f8.m10 * f21 + src.m20 * f22;
        Matrix4f matrix4f9 = src;
        matrix4f7.m21 = matrix4f8.m01 * f20 + matrix4f9.m11 * f21 + src.m21 * f22;
        matrix4f6.m22 = matrix4f9.m02 * f20 + src.m12 * f21 + src.m22 * f22;
        matrix4f6.m23 = src.m03 * f20 + src.m13 * f21 + src.m23 * f22;
        matrix4f5.m00 = t00;
        matrix4f5.m01 = t01;
        matrix4f4.m02 = t02;
        matrix4f4.m03 = t03;
        matrix4f3.m10 = t10;
        matrix4f3.m11 = t11;
        dest.m12 = t12;
        dest.m13 = src.m03 * f10 + src.m13 * f11 + src.m23 * f12;
        return dest;
    }

    public Matrix4f negate(Matrix4f dest) {
        return Matrix4f.negate(this, dest);
    }

    public Matrix4f translate(Vector2f vector2f) {
        Matrix4f matrix4f = this;
        return matrix4f.translate(vector2f, matrix4f);
    }

    public Matrix4f load(Matrix4f src) {
        return Matrix4f.load(src, this);
    }

    @Override
    public Matrix setIdentity() {
        return Matrix4f.setIdentity(this);
    }

    @Override
    public Matrix invert() {
        Matrix4f matrix4f = this;
        return Matrix4f.invert(matrix4f, matrix4f);
    }

    public Matrix4f() {
        Matrix4f matrix4f = this;
        matrix4f.setIdentity();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Matrix load(FloatBuffer floatBuffer) {
        void buf;
        void v0 = buf;
        Matrix4f matrix4f = this;
        void v2 = buf;
        Matrix4f matrix4f2 = this;
        void v4 = buf;
        Matrix4f matrix4f3 = this;
        void v6 = buf;
        Matrix4f matrix4f4 = this;
        void v8 = buf;
        this.m00 = buf.get();
        this.m01 = v8.get();
        matrix4f4.m02 = v8.get();
        matrix4f4.m03 = buf.get();
        this.m10 = v6.get();
        matrix4f3.m11 = v6.get();
        matrix4f3.m12 = buf.get();
        this.m13 = v4.get();
        matrix4f2.m20 = v4.get();
        matrix4f2.m21 = buf.get();
        this.m22 = v2.get();
        matrix4f.m23 = v2.get();
        matrix4f.m30 = buf.get();
        this.m31 = v0.get();
        this.m32 = v0.get();
        this.m33 = floatBuffer.get();
        return this;
    }

    public static Matrix4f sub(Matrix4f left, Matrix4f right, Matrix4f dest) {
        if (dest == null) {
            dest = new Matrix4f();
        }
        Matrix4f matrix4f = dest;
        Matrix4f matrix4f2 = left;
        Matrix4f matrix4f3 = dest;
        Matrix4f matrix4f4 = left;
        Matrix4f matrix4f5 = dest;
        Matrix4f matrix4f6 = left;
        Matrix4f matrix4f7 = dest;
        Matrix4f matrix4f8 = left;
        Matrix4f matrix4f9 = dest;
        Matrix4f matrix4f10 = left;
        dest.m00 = left.m00 - right.m00;
        dest.m01 = matrix4f10.m01 - right.m01;
        matrix4f9.m02 = matrix4f10.m02 - right.m02;
        matrix4f9.m03 = left.m03 - right.m03;
        dest.m10 = matrix4f8.m10 - right.m10;
        matrix4f7.m11 = matrix4f8.m11 - right.m11;
        matrix4f7.m12 = left.m12 - right.m12;
        dest.m13 = matrix4f6.m13 - right.m13;
        matrix4f5.m20 = matrix4f6.m20 - right.m20;
        matrix4f5.m21 = left.m21 - right.m21;
        dest.m22 = matrix4f4.m22 - right.m22;
        matrix4f3.m23 = matrix4f4.m23 - right.m23;
        matrix4f3.m30 = left.m30 - right.m30;
        dest.m31 = matrix4f2.m31 - right.m31;
        matrix4f.m32 = matrix4f2.m32 - right.m32;
        matrix4f.m33 = left.m33 - right.m33;
        return dest;
    }

    /*
     * WARNING - void declaration
     */
    public static Matrix4f invert(Matrix4f src, Matrix4f dest) {
        float determinant = src.determinant();
        if (determinant != 0.0f) {
            void t33;
            if (dest == null) {
                dest = new Matrix4f();
            }
            float determinant_inv = 1.0f / determinant;
            Matrix4f matrix4f = src;
            Matrix4f matrix4f2 = src;
            Matrix4f matrix4f3 = src;
            Matrix4f matrix4f4 = src;
            Matrix4f matrix4f5 = src;
            float t00 = Matrix4f.determinant3x3(matrix4f.m11, matrix4f2.m12, matrix4f3.m13, matrix4f3.m21, matrix4f4.m22, matrix4f4.m23, matrix4f5.m31, matrix4f5.m32, src.m33);
            Matrix4f matrix4f6 = src;
            Matrix4f matrix4f7 = src;
            Matrix4f matrix4f8 = src;
            Matrix4f matrix4f9 = src;
            float t01 = -Matrix4f.determinant3x3(matrix4f.m10, matrix4f6.m12, matrix4f6.m13, matrix4f7.m20, matrix4f7.m22, matrix4f8.m23, matrix4f8.m30, matrix4f9.m32, matrix4f9.m33);
            Matrix4f matrix4f10 = src;
            Matrix4f matrix4f11 = src;
            Matrix4f matrix4f12 = src;
            Matrix4f matrix4f13 = src;
            float t02 = Matrix4f.determinant3x3(matrix4f2.m10, matrix4f10.m11, matrix4f10.m13, matrix4f11.m20, matrix4f11.m21, matrix4f12.m23, matrix4f12.m30, matrix4f13.m31, matrix4f13.m33);
            Matrix4f matrix4f14 = src;
            Matrix4f matrix4f15 = src;
            Matrix4f matrix4f16 = src;
            Matrix4f matrix4f17 = src;
            float t03 = -Matrix4f.determinant3x3(matrix4f.m10, matrix4f14.m11, matrix4f14.m12, matrix4f15.m20, matrix4f15.m21, matrix4f16.m22, matrix4f16.m30, matrix4f17.m31, matrix4f17.m32);
            Matrix4f matrix4f18 = src;
            Matrix4f matrix4f19 = src;
            Matrix4f matrix4f20 = src;
            Matrix4f matrix4f21 = src;
            float t10 = -Matrix4f.determinant3x3(matrix4f.m01, matrix4f18.m02, matrix4f18.m03, matrix4f19.m21, matrix4f19.m22, matrix4f20.m23, matrix4f20.m31, matrix4f21.m32, matrix4f21.m33);
            Matrix4f matrix4f22 = src;
            Matrix4f matrix4f23 = src;
            Matrix4f matrix4f24 = src;
            Matrix4f matrix4f25 = src;
            float t11 = Matrix4f.determinant3x3(matrix4f.m00, matrix4f22.m02, matrix4f22.m03, matrix4f23.m20, matrix4f23.m22, matrix4f24.m23, matrix4f24.m30, matrix4f25.m32, matrix4f25.m33);
            Matrix4f matrix4f26 = src;
            Matrix4f matrix4f27 = src;
            Matrix4f matrix4f28 = src;
            Matrix4f matrix4f29 = src;
            float t12 = -Matrix4f.determinant3x3(matrix4f.m00, matrix4f26.m01, matrix4f26.m03, matrix4f27.m20, matrix4f27.m21, matrix4f28.m23, matrix4f28.m30, matrix4f29.m31, matrix4f29.m33);
            Matrix4f matrix4f30 = src;
            Matrix4f matrix4f31 = src;
            Matrix4f matrix4f32 = src;
            Matrix4f matrix4f33 = src;
            float t13 = Matrix4f.determinant3x3(matrix4f.m00, matrix4f30.m01, matrix4f30.m02, matrix4f31.m20, matrix4f31.m21, matrix4f32.m22, matrix4f32.m30, matrix4f33.m31, matrix4f33.m32);
            Matrix4f matrix4f34 = src;
            Matrix4f matrix4f35 = src;
            Matrix4f matrix4f36 = src;
            Matrix4f matrix4f37 = src;
            float t20 = Matrix4f.determinant3x3(matrix4f.m01, matrix4f34.m02, matrix4f34.m03, matrix4f35.m11, matrix4f35.m12, matrix4f36.m13, matrix4f36.m31, matrix4f37.m32, matrix4f37.m33);
            Matrix4f matrix4f38 = src;
            Matrix4f matrix4f39 = src;
            Matrix4f matrix4f40 = src;
            Matrix4f matrix4f41 = src;
            float t21 = -Matrix4f.determinant3x3(matrix4f.m00, matrix4f38.m02, matrix4f38.m03, matrix4f39.m10, matrix4f39.m12, matrix4f40.m13, matrix4f40.m30, matrix4f41.m32, matrix4f41.m33);
            Matrix4f matrix4f42 = src;
            Matrix4f matrix4f43 = src;
            Matrix4f matrix4f44 = src;
            Matrix4f matrix4f45 = src;
            float t22 = Matrix4f.determinant3x3(matrix4f.m00, matrix4f42.m01, matrix4f42.m03, matrix4f43.m10, matrix4f43.m11, matrix4f44.m13, matrix4f44.m30, matrix4f45.m31, matrix4f45.m33);
            Matrix4f matrix4f46 = src;
            Matrix4f matrix4f47 = src;
            Matrix4f matrix4f48 = src;
            Matrix4f matrix4f49 = src;
            float t23 = -Matrix4f.determinant3x3(matrix4f.m00, matrix4f46.m01, matrix4f46.m02, matrix4f47.m10, matrix4f47.m11, matrix4f48.m12, matrix4f48.m30, matrix4f49.m31, matrix4f49.m32);
            Matrix4f matrix4f50 = src;
            Matrix4f matrix4f51 = src;
            Matrix4f matrix4f52 = src;
            Matrix4f matrix4f53 = src;
            float t30 = -Matrix4f.determinant3x3(matrix4f.m01, matrix4f50.m02, matrix4f50.m03, matrix4f51.m11, matrix4f51.m12, matrix4f52.m13, matrix4f52.m21, matrix4f53.m22, matrix4f53.m23);
            Matrix4f matrix4f54 = src;
            Matrix4f matrix4f55 = src;
            Matrix4f matrix4f56 = src;
            Matrix4f matrix4f57 = src;
            float t31 = Matrix4f.determinant3x3(matrix4f.m00, matrix4f54.m02, matrix4f54.m03, matrix4f55.m10, matrix4f55.m12, matrix4f56.m13, matrix4f56.m20, matrix4f57.m22, matrix4f57.m23);
            Matrix4f matrix4f58 = src;
            Matrix4f matrix4f59 = src;
            Matrix4f matrix4f60 = src;
            Matrix4f matrix4f61 = src;
            float t32 = -Matrix4f.determinant3x3(matrix4f.m00, matrix4f58.m01, matrix4f58.m03, matrix4f59.m10, matrix4f59.m11, matrix4f60.m13, matrix4f60.m20, matrix4f61.m21, matrix4f61.m23);
            Matrix4f matrix4f62 = src;
            Matrix4f matrix4f63 = src;
            Matrix4f matrix4f64 = src;
            Matrix4f matrix4f65 = src;
            float f = Matrix4f.determinant3x3(matrix4f.m00, matrix4f62.m01, matrix4f62.m02, matrix4f63.m10, matrix4f63.m11, matrix4f64.m12, matrix4f64.m20, matrix4f65.m21, matrix4f65.m22);
            Matrix4f matrix4f66 = dest;
            Matrix4f matrix4f67 = dest;
            Matrix4f matrix4f68 = dest;
            Matrix4f matrix4f69 = dest;
            Matrix4f matrix4f70 = dest;
            Matrix4f matrix4f71 = dest;
            Matrix4f matrix4f72 = dest;
            matrix4f72.m00 = t00 * determinant_inv;
            matrix4f72.m11 = t11 * determinant_inv;
            matrix4f71.m22 = t22 * determinant_inv;
            matrix4f71.m33 = t33 * determinant_inv;
            matrix4f70.m01 = t10 * determinant_inv;
            matrix4f70.m10 = t01 * determinant_inv;
            matrix4f69.m20 = t02 * determinant_inv;
            matrix4f69.m02 = t20 * determinant_inv;
            matrix4f68.m12 = t21 * determinant_inv;
            matrix4f68.m21 = t12 * determinant_inv;
            matrix4f67.m03 = t30 * determinant_inv;
            matrix4f67.m30 = t03 * determinant_inv;
            matrix4f66.m13 = t31 * determinant_inv;
            matrix4f66.m31 = t13 * determinant_inv;
            dest.m32 = t23 * determinant_inv;
            dest.m23 = t32 * determinant_inv;
            return dest;
        }
        return null;
    }

    public Matrix4f transpose(Matrix4f dest) {
        return Matrix4f.transpose(this, dest);
    }

    public static Matrix4f negate(Matrix4f src, Matrix4f dest) {
        if (dest == null) {
            dest = new Matrix4f();
        }
        Matrix4f matrix4f = dest;
        Matrix4f matrix4f2 = src;
        Matrix4f matrix4f3 = dest;
        Matrix4f matrix4f4 = src;
        Matrix4f matrix4f5 = dest;
        Matrix4f matrix4f6 = src;
        Matrix4f matrix4f7 = dest;
        Matrix4f matrix4f8 = src;
        Matrix4f matrix4f9 = dest;
        Matrix4f matrix4f10 = src;
        dest.m00 = -src.m00;
        dest.m01 = -matrix4f10.m01;
        matrix4f9.m02 = -matrix4f10.m02;
        matrix4f9.m03 = -src.m03;
        dest.m10 = -matrix4f8.m10;
        matrix4f7.m11 = -matrix4f8.m11;
        matrix4f7.m12 = -src.m12;
        dest.m13 = -matrix4f6.m13;
        matrix4f5.m20 = -matrix4f6.m20;
        matrix4f5.m21 = -src.m21;
        dest.m22 = -matrix4f4.m22;
        matrix4f3.m23 = -matrix4f4.m23;
        matrix4f3.m30 = -src.m30;
        dest.m31 = -matrix4f2.m31;
        matrix4f.m32 = -matrix4f2.m32;
        matrix4f.m33 = -src.m33;
        return dest;
    }

    /*
     * WARNING - void declaration
     */
    public Matrix4f rotate(float f, Vector3f vector3f) {
        void axis;
        Matrix4f matrix4f = this;
        return matrix4f.rotate(f, (Vector3f)axis, matrix4f);
    }

    public static Matrix4f translate(Vector3f vec, Matrix4f src, Matrix4f dest) {
        if (dest == null) {
            dest = new Matrix4f();
        }
        Matrix4f matrix4f = dest;
        matrix4f.m30 += src.m00 * vec.x + src.m10 * vec.y + src.m20 * vec.z;
        matrix4f.m31 += src.m01 * vec.x + src.m11 * vec.y + src.m21 * vec.z;
        matrix4f.m32 += src.m02 * vec.x + src.m12 * vec.y + src.m22 * vec.z;
        matrix4f.m33 += src.m03 * vec.x + src.m13 * vec.y + src.m23 * vec.z;
        return matrix4f;
    }

    @Override
    public Matrix setZero() {
        return Matrix4f.setZero(this);
    }

    public Matrix4f scale(Vector3f vec) {
        Matrix4f matrix4f = this;
        return Matrix4f.scale(vec, matrix4f, matrix4f);
    }

    public Matrix4f rotate(float angle, Vector3f axis, Matrix4f dest) {
        return Matrix4f.rotate(angle, axis, this, dest);
    }

    private static /* synthetic */ float determinant3x3(float t00, float t01, float t02, float t10, float t11, float t12, float t20, float t21, float t22) {
        return t00 * (t11 * t22 - t12 * t21) + t01 * (t12 * t20 - t10 * t22) + t02 * (t10 * t21 - t11 * t20);
    }

    @Override
    public Matrix negate() {
        Matrix4f matrix4f = this;
        return matrix4f.negate(matrix4f);
    }

    public static Matrix4f mul(Matrix4f left, Matrix4f right, Matrix4f dest) {
        if (dest == null) {
            dest = new Matrix4f();
        }
        Matrix4f matrix4f = left;
        Matrix4f matrix4f2 = left;
        float m00 = matrix4f.m00 * right.m00 + matrix4f2.m10 * right.m01 + left.m20 * right.m02 + left.m30 * right.m03;
        float m01 = matrix4f.m01 * right.m00 + left.m11 * right.m01 + left.m21 * right.m02 + left.m31 * right.m03;
        float m02 = matrix4f2.m02 * right.m00 + left.m12 * right.m01 + left.m22 * right.m02 + left.m32 * right.m03;
        float m03 = matrix4f.m03 * right.m00 + left.m13 * right.m01 + left.m23 * right.m02 + left.m33 * right.m03;
        float m10 = matrix4f.m00 * right.m10 + left.m10 * right.m11 + left.m20 * right.m12 + left.m30 * right.m13;
        float m11 = matrix4f.m01 * right.m10 + left.m11 * right.m11 + left.m21 * right.m12 + left.m31 * right.m13;
        float m12 = matrix4f.m02 * right.m10 + left.m12 * right.m11 + left.m22 * right.m12 + left.m32 * right.m13;
        float m13 = matrix4f.m03 * right.m10 + left.m13 * right.m11 + left.m23 * right.m12 + left.m33 * right.m13;
        float m20 = matrix4f.m00 * right.m20 + left.m10 * right.m21 + left.m20 * right.m22 + left.m30 * right.m23;
        float m21 = matrix4f.m01 * right.m20 + left.m11 * right.m21 + left.m21 * right.m22 + left.m31 * right.m23;
        float m22 = matrix4f.m02 * right.m20 + left.m12 * right.m21 + left.m22 * right.m22 + left.m32 * right.m23;
        float m23 = matrix4f.m03 * right.m20 + left.m13 * right.m21 + left.m23 * right.m22 + left.m33 * right.m23;
        float m30 = matrix4f.m00 * right.m30 + left.m10 * right.m31 + left.m20 * right.m32 + left.m30 * right.m33;
        float m31 = matrix4f.m01 * right.m30 + left.m11 * right.m31 + left.m21 * right.m32 + left.m31 * right.m33;
        float m32 = matrix4f.m02 * right.m30 + left.m12 * right.m31 + left.m22 * right.m32 + left.m32 * right.m33;
        Matrix4f matrix4f3 = dest;
        Matrix4f matrix4f4 = dest;
        Matrix4f matrix4f5 = dest;
        Matrix4f matrix4f6 = dest;
        Matrix4f matrix4f7 = dest;
        Matrix4f matrix4f8 = dest;
        Matrix4f matrix4f9 = dest;
        matrix4f9.m00 = m00;
        matrix4f9.m01 = m01;
        matrix4f8.m02 = m02;
        matrix4f8.m03 = m03;
        matrix4f7.m10 = m10;
        matrix4f7.m11 = m11;
        matrix4f6.m12 = m12;
        matrix4f6.m13 = m13;
        matrix4f5.m20 = m20;
        matrix4f5.m21 = m21;
        matrix4f4.m22 = m22;
        matrix4f4.m23 = m23;
        matrix4f3.m30 = m30;
        matrix4f3.m31 = m31;
        dest.m32 = m32;
        dest.m33 = matrix4f.m03 * right.m30 + left.m13 * right.m31 + left.m23 * right.m32 + left.m33 * right.m33;
        return dest;
    }

    public static Matrix4f translate(Vector2f vec, Matrix4f src, Matrix4f dest) {
        if (dest == null) {
            dest = new Matrix4f();
        }
        Matrix4f matrix4f = dest;
        matrix4f.m30 += src.m00 * vec.x + src.m10 * vec.y;
        matrix4f.m31 += src.m01 * vec.x + src.m11 * vec.y;
        matrix4f.m32 += src.m02 * vec.x + src.m12 * vec.y;
        matrix4f.m33 += src.m03 * vec.x + src.m13 * vec.y;
        return matrix4f;
    }

    public static Vector4f transform(Matrix4f left, Vector4f right, Vector4f dest) {
        if (dest == null) {
            dest = new Vector4f();
        }
        Matrix4f matrix4f = left;
        Matrix4f matrix4f2 = left;
        float x = matrix4f.m00 * right.x + matrix4f2.m10 * right.y + left.m20 * right.z + left.m30 * right.w;
        float y = matrix4f.m01 * right.x + left.m11 * right.y + left.m21 * right.z + left.m31 * right.w;
        float z = matrix4f2.m02 * right.x + left.m12 * right.y + left.m22 * right.z + left.m32 * right.w;
        Vector4f vector4f = dest;
        vector4f.x = x;
        vector4f.y = y;
        dest.z = z;
        dest.w = matrix4f.m03 * right.x + left.m13 * right.y + left.m23 * right.z + left.m33 * right.w;
        return dest;
    }

    public String toString() {
        return new StringBuilder().insert(0, String.valueOf(this.m00)).append(' ').append(this.m10).append(' ').append(this.m20).append(' ').append(this.m30).append('\n').append(this.m01).append(' ').append(this.m11).append(' ').append(this.m21).append(' ').append(this.m31).append('\n').append(this.m02).append(' ').append(this.m12).append(' ').append(this.m22).append(' ').append(this.m32).append('\n').append(this.m03).append(' ').append(this.m13).append(' ').append(this.m23).append(' ').append(this.m33).append('\n').toString();
    }

    public Matrix4f translate(Vector3f vector3f) {
        Matrix4f matrix4f = this;
        return matrix4f.translate(vector3f, matrix4f);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Matrix loadTranspose(FloatBuffer floatBuffer) {
        void buf;
        void v0 = buf;
        Matrix4f matrix4f = this;
        void v2 = buf;
        Matrix4f matrix4f2 = this;
        void v4 = buf;
        Matrix4f matrix4f3 = this;
        void v6 = buf;
        Matrix4f matrix4f4 = this;
        void v8 = buf;
        this.m00 = buf.get();
        this.m10 = v8.get();
        matrix4f4.m20 = v8.get();
        matrix4f4.m30 = buf.get();
        this.m01 = v6.get();
        matrix4f3.m11 = v6.get();
        matrix4f3.m21 = buf.get();
        this.m31 = v4.get();
        matrix4f2.m02 = v4.get();
        matrix4f2.m12 = buf.get();
        this.m22 = v2.get();
        matrix4f.m32 = v2.get();
        matrix4f.m03 = buf.get();
        this.m13 = v0.get();
        this.m23 = v0.get();
        this.m33 = floatBuffer.get();
        return this;
    }

    public static Matrix4f setIdentity(Matrix4f matrix4f) {
        Matrix4f m;
        Matrix4f matrix4f2 = m;
        Matrix4f matrix4f3 = m;
        Matrix4f matrix4f4 = m;
        Matrix4f matrix4f5 = m;
        Matrix4f matrix4f6 = m;
        Matrix4f matrix4f7 = m;
        Matrix4f matrix4f8 = m;
        matrix4f8.m00 = 1.0f;
        matrix4f8.m01 = 0.0f;
        matrix4f7.m02 = 0.0f;
        matrix4f7.m03 = 0.0f;
        matrix4f6.m10 = 0.0f;
        matrix4f6.m11 = 1.0f;
        matrix4f5.m12 = 0.0f;
        matrix4f5.m13 = 0.0f;
        matrix4f4.m20 = 0.0f;
        matrix4f4.m21 = 0.0f;
        matrix4f3.m22 = 1.0f;
        matrix4f3.m23 = 0.0f;
        matrix4f2.m30 = 0.0f;
        matrix4f2.m31 = 0.0f;
        m.m32 = 0.0f;
        m.m33 = 1.0f;
        return m;
    }

    public Matrix store3f(FloatBuffer buf) {
        Matrix4f matrix4f = this;
        buf.put(this.m00);
        buf.put(matrix4f.m01);
        buf.put(this.m02);
        buf.put(this.m10);
        buf.put(this.m11);
        buf.put(this.m12);
        buf.put(this.m20);
        buf.put(this.m21);
        buf.put(this.m22);
        return matrix4f;
    }

    public static Matrix4f scale(Vector3f vec, Matrix4f src, Matrix4f dest) {
        if (dest == null) {
            dest = new Matrix4f();
        }
        Matrix4f matrix4f = dest;
        Matrix4f matrix4f2 = src;
        Matrix4f matrix4f3 = dest;
        Matrix4f matrix4f4 = src;
        Matrix4f matrix4f5 = dest;
        Matrix4f matrix4f6 = src;
        Matrix4f matrix4f7 = dest;
        Matrix4f matrix4f8 = src;
        dest.m00 = matrix4f8.m00 * vec.x;
        matrix4f7.m01 = matrix4f8.m01 * vec.x;
        matrix4f7.m02 = src.m02 * vec.x;
        dest.m03 = matrix4f6.m03 * vec.x;
        matrix4f5.m10 = matrix4f6.m10 * vec.y;
        matrix4f5.m11 = src.m11 * vec.y;
        dest.m12 = matrix4f4.m12 * vec.y;
        matrix4f3.m13 = matrix4f4.m13 * vec.y;
        matrix4f3.m20 = src.m20 * vec.z;
        dest.m21 = matrix4f2.m21 * vec.z;
        matrix4f.m22 = matrix4f2.m22 * vec.z;
        matrix4f.m23 = src.m23 * vec.z;
        return dest;
    }

    @Override
    public Matrix store(FloatBuffer buf) {
        Matrix4f matrix4f = this;
        buf.put(this.m00);
        buf.put(matrix4f.m01);
        buf.put(this.m02);
        buf.put(this.m03);
        buf.put(this.m10);
        buf.put(this.m11);
        buf.put(this.m12);
        buf.put(this.m13);
        buf.put(this.m20);
        buf.put(this.m21);
        buf.put(this.m22);
        buf.put(this.m23);
        buf.put(this.m30);
        buf.put(this.m31);
        buf.put(this.m32);
        buf.put(this.m33);
        return matrix4f;
    }

    public static Matrix4f load(Matrix4f src, Matrix4f dest) {
        if (dest == null) {
            dest = new Matrix4f();
        }
        Matrix4f matrix4f = dest;
        Matrix4f matrix4f2 = src;
        Matrix4f matrix4f3 = dest;
        Matrix4f matrix4f4 = src;
        Matrix4f matrix4f5 = dest;
        Matrix4f matrix4f6 = src;
        Matrix4f matrix4f7 = dest;
        Matrix4f matrix4f8 = src;
        Matrix4f matrix4f9 = dest;
        Matrix4f matrix4f10 = src;
        dest.m00 = src.m00;
        dest.m01 = matrix4f10.m01;
        matrix4f9.m02 = matrix4f10.m02;
        matrix4f9.m03 = src.m03;
        dest.m10 = matrix4f8.m10;
        matrix4f7.m11 = matrix4f8.m11;
        matrix4f7.m12 = src.m12;
        dest.m13 = matrix4f6.m13;
        matrix4f5.m20 = matrix4f6.m20;
        matrix4f5.m21 = src.m21;
        dest.m22 = matrix4f4.m22;
        matrix4f3.m23 = matrix4f4.m23;
        matrix4f3.m30 = src.m30;
        dest.m31 = matrix4f2.m31;
        matrix4f.m32 = matrix4f2.m32;
        matrix4f.m33 = src.m33;
        return dest;
    }

    public Matrix4f translate(Vector2f vec, Matrix4f dest) {
        return Matrix4f.translate(vec, this, dest);
    }

    public static Matrix4f setZero(Matrix4f matrix4f) {
        Matrix4f m;
        Matrix4f matrix4f2 = m;
        Matrix4f matrix4f3 = m;
        Matrix4f matrix4f4 = m;
        Matrix4f matrix4f5 = m;
        Matrix4f matrix4f6 = m;
        Matrix4f matrix4f7 = m;
        Matrix4f matrix4f8 = m;
        matrix4f8.m00 = 0.0f;
        matrix4f8.m01 = 0.0f;
        matrix4f7.m02 = 0.0f;
        matrix4f7.m03 = 0.0f;
        matrix4f6.m10 = 0.0f;
        matrix4f6.m11 = 0.0f;
        matrix4f5.m12 = 0.0f;
        matrix4f5.m13 = 0.0f;
        matrix4f4.m20 = 0.0f;
        matrix4f4.m21 = 0.0f;
        matrix4f3.m22 = 0.0f;
        matrix4f3.m23 = 0.0f;
        matrix4f2.m30 = 0.0f;
        matrix4f2.m31 = 0.0f;
        m.m32 = 0.0f;
        m.m33 = 0.0f;
        return m;
    }

    public Matrix4f translate(Vector3f vec, Matrix4f dest) {
        return Matrix4f.translate(vec, this, dest);
    }

    @Override
    public Matrix transpose() {
        Matrix4f matrix4f = this;
        return matrix4f.transpose(matrix4f);
    }

    public static Matrix4f add(Matrix4f left, Matrix4f right, Matrix4f dest) {
        if (dest == null) {
            dest = new Matrix4f();
        }
        Matrix4f matrix4f = dest;
        Matrix4f matrix4f2 = left;
        Matrix4f matrix4f3 = dest;
        Matrix4f matrix4f4 = left;
        Matrix4f matrix4f5 = dest;
        Matrix4f matrix4f6 = left;
        Matrix4f matrix4f7 = dest;
        Matrix4f matrix4f8 = left;
        Matrix4f matrix4f9 = dest;
        Matrix4f matrix4f10 = left;
        dest.m00 = left.m00 + right.m00;
        dest.m01 = matrix4f10.m01 + right.m01;
        matrix4f9.m02 = matrix4f10.m02 + right.m02;
        matrix4f9.m03 = left.m03 + right.m03;
        dest.m10 = matrix4f8.m10 + right.m10;
        matrix4f7.m11 = matrix4f8.m11 + right.m11;
        matrix4f7.m12 = left.m12 + right.m12;
        dest.m13 = matrix4f6.m13 + right.m13;
        matrix4f5.m20 = matrix4f6.m20 + right.m20;
        matrix4f5.m21 = left.m21 + right.m21;
        dest.m22 = matrix4f4.m22 + right.m22;
        matrix4f3.m23 = matrix4f4.m23 + right.m23;
        matrix4f3.m30 = left.m30 + right.m30;
        dest.m31 = matrix4f2.m31 + right.m31;
        matrix4f.m32 = matrix4f2.m32 + right.m32;
        matrix4f.m33 = left.m33 + right.m33;
        return dest;
    }

    @Override
    public float determinant() {
        Matrix4f matrix4f = this;
        Matrix4f matrix4f2 = this;
        Matrix4f matrix4f3 = this;
        Matrix4f matrix4f4 = this;
        Matrix4f matrix4f5 = this;
        Matrix4f matrix4f6 = this;
        float f = matrix4f.m00 * (matrix4f.m11 * this.m22 * this.m33 + matrix4f2.m12 * matrix4f2.m23 * this.m31 + matrix4f3.m13 * matrix4f3.m21 * this.m32 - matrix4f4.m13 * matrix4f4.m22 * this.m31 - matrix4f5.m11 * matrix4f5.m23 * this.m32 - matrix4f6.m12 * matrix4f6.m21 * this.m33);
        Matrix4f matrix4f7 = this;
        Matrix4f matrix4f8 = this;
        Matrix4f matrix4f9 = this;
        Matrix4f matrix4f10 = this;
        Matrix4f matrix4f11 = this;
        Matrix4f matrix4f12 = this;
        f -= matrix4f7.m01 * (matrix4f7.m10 * this.m22 * this.m33 + matrix4f8.m12 * matrix4f8.m23 * this.m30 + matrix4f9.m13 * matrix4f9.m20 * this.m32 - matrix4f10.m13 * matrix4f10.m22 * this.m30 - matrix4f11.m10 * matrix4f11.m23 * this.m32 - matrix4f12.m12 * matrix4f12.m20 * this.m33);
        Matrix4f matrix4f13 = this;
        Matrix4f matrix4f14 = this;
        Matrix4f matrix4f15 = this;
        Matrix4f matrix4f16 = this;
        Matrix4f matrix4f17 = this;
        Matrix4f matrix4f18 = this;
        f += matrix4f13.m02 * (matrix4f13.m10 * this.m21 * this.m33 + matrix4f14.m11 * matrix4f14.m23 * this.m30 + matrix4f15.m13 * matrix4f15.m20 * this.m31 - matrix4f16.m13 * matrix4f16.m21 * this.m30 - matrix4f17.m10 * matrix4f17.m23 * this.m31 - matrix4f18.m11 * matrix4f18.m20 * this.m33);
        Matrix4f matrix4f19 = this;
        Matrix4f matrix4f20 = this;
        Matrix4f matrix4f21 = this;
        Matrix4f matrix4f22 = this;
        Matrix4f matrix4f23 = this;
        Matrix4f matrix4f24 = this;
        return f -= matrix4f19.m03 * (matrix4f19.m10 * this.m21 * this.m32 + matrix4f20.m11 * matrix4f20.m22 * this.m30 + matrix4f21.m12 * matrix4f21.m20 * this.m31 - matrix4f22.m12 * matrix4f22.m21 * this.m30 - matrix4f23.m10 * matrix4f23.m22 * this.m31 - matrix4f24.m11 * matrix4f24.m20 * this.m32);
    }

    @Override
    public Matrix storeTranspose(FloatBuffer buf) {
        Matrix4f matrix4f = this;
        buf.put(this.m00);
        buf.put(matrix4f.m10);
        buf.put(this.m20);
        buf.put(this.m30);
        buf.put(this.m01);
        buf.put(this.m11);
        buf.put(this.m21);
        buf.put(this.m31);
        buf.put(this.m02);
        buf.put(this.m12);
        buf.put(this.m22);
        buf.put(this.m32);
        buf.put(this.m03);
        buf.put(this.m13);
        buf.put(this.m23);
        buf.put(this.m33);
        return matrix4f;
    }

    public Matrix4f(Matrix4f matrix4f) {
        Matrix4f matrix4f2 = this;
        matrix4f2.load(matrix4f);
    }
}

