/*
 * Decompiled with CFR 0.152.
 */
package com.modularwarfare.common.vector;

import com.modularwarfare.common.vector.ReadableVector2f;
import com.modularwarfare.common.vector.Vector;
import com.modularwarfare.common.vector.WritableVector2f;
import java.io.Serializable;
import java.nio.FloatBuffer;

public class Vector2f
extends Vector
implements Serializable,
ReadableVector2f,
WritableVector2f {
    private static final long serialVersionUID = 1L;
    public float x;
    public float y;

    public static float dot(Vector2f left, Vector2f right) {
        return left.x * right.x + left.y * right.y;
    }

    public static Vector2f add(Vector2f left, Vector2f right, Vector2f dest) {
        if (dest == null) {
            return new Vector2f(left.x + right.x, left.y + right.y);
        }
        Vector2f vector2f = dest;
        vector2f.set(left.x + right.x, left.y + right.y);
        return vector2f;
    }

    @Override
    public float lengthSquared() {
        Vector2f vector2f = this;
        Vector2f vector2f2 = this;
        return vector2f.x * vector2f.x + vector2f2.y * vector2f2.y;
    }

    @Override
    public final float getX() {
        return this.x;
    }

    public Vector2f() {
    }

    public Vector2f translate(float x, float y) {
        Vector2f vector2f = this;
        vector2f.x += x;
        vector2f.y += y;
        return vector2f;
    }

    @Override
    public Vector scale(float scale) {
        Vector2f vector2f = this;
        vector2f.x *= scale;
        vector2f.y *= scale;
        return vector2f;
    }

    public String toString() {
        return new StringBuilder().insert(0, "Vector2f[").append(this.x).append(", ").append(this.y).append(']').toString();
    }

    /*
     * WARNING - void declaration
     */
    public Vector2f set(ReadableVector2f readableVector2f) {
        void src;
        this.x = src.getX();
        this.y = readableVector2f.getY();
        return this;
    }

    public Vector2f normalise(Vector2f vector2f) {
        Vector2f dest;
        float l = this.length();
        if (vector2f == null) {
            dest = new Vector2f(this.x / l, this.y / l);
            return dest;
        }
        void v0 = dest;
        v0.set(this.x / l, this.y / l);
        return v0;
    }

    @Override
    public final void setY(float y) {
        this.y = y;
    }

    @Override
    public final void setX(float x) {
        this.x = x;
    }

    public static Vector2f sub(Vector2f left, Vector2f right, Vector2f dest) {
        if (dest == null) {
            return new Vector2f(left.x - right.x, left.y - right.y);
        }
        Vector2f vector2f = dest;
        vector2f.set(left.x - right.x, left.y - right.y);
        return vector2f;
    }

    public Vector2f negate(Vector2f dest) {
        if (dest == null) {
            dest = new Vector2f();
        }
        Vector2f vector2f = dest;
        vector2f.x = -this.x;
        vector2f.y = -this.y;
        return dest;
    }

    @Override
    public final float getY() {
        return this.y;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Vector load(FloatBuffer floatBuffer) {
        void buf;
        this.x = buf.get();
        this.y = floatBuffer.get();
        return this;
    }

    public static float angle(Vector2f a, Vector2f b) {
        float f;
        float f2;
        float dls = Vector2f.dot(a, b) / (a.length() * b.length());
        if (f2 < -1.0f) {
            f = dls = -1.0f;
        } else {
            if (dls > 1.0f) {
                dls = 1.0f;
            }
            f = dls;
        }
        return (float)Math.acos(f);
    }

    @Override
    public Vector negate() {
        Vector2f vector2f = this;
        vector2f.x = -vector2f.x;
        vector2f.y = -vector2f.y;
        return vector2f;
    }

    /*
     * WARNING - void declaration
     */
    public Vector2f(float f, float f2) {
        void y;
        Vector2f vector2f = this;
        vector2f.set(f, (float)y);
    }

    @Override
    public Vector store(FloatBuffer buf) {
        Vector2f vector2f = this;
        buf.put(this.x);
        buf.put(vector2f.y);
        return vector2f;
    }

    public Vector2f(ReadableVector2f readableVector2f) {
        Vector2f vector2f = this;
        vector2f.set(readableVector2f);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void set(float f, float f2) {
        void x;
        Vector2f vector2f = this;
        vector2f.x = x;
        vector2f.y = f2;
    }
}

