/*
 * Decompiled with CFR 0.152.
 */
package com.modularwarfare.common.vector;

import com.modularwarfare.common.vector.ReadableVector3f;
import com.modularwarfare.common.vector.Vector;
import com.modularwarfare.common.vector.WritableVector3f;
import io.netty.buffer.ByteBuf;
import java.io.Serializable;
import java.nio.FloatBuffer;
import net.minecraft.util.math.Vec3d;

public class Vector3f
extends Vector
implements Serializable,
ReadableVector3f,
WritableVector3f {
    public float x;
    private static final long serialVersionUID = 1L;
    public float z;
    public float y;

    @Override
    public final float getY() {
        return this.y;
    }

    public Vector3f(Vec3d vec) {
        this((float)vec.field_72450_a, (float)vec.field_72448_b, (float)vec.field_72449_c);
    }

    @Override
    public Vector negate() {
        Vector3f vector3f = this;
        vector3f.x = -vector3f.x;
        vector3f.y = -vector3f.y;
        vector3f.z = -vector3f.z;
        return vector3f;
    }

    @Override
    public final void setY(float y) {
        this.y = y;
    }

    public static Vector3f cross(Vector3f left, Vector3f right, Vector3f dest) {
        if (dest == null) {
            dest = new Vector3f();
        }
        Vector3f vector3f = dest;
        vector3f.set(left.y * right.z - left.z * right.y, right.x * left.z - right.z * left.x, left.x * right.y - left.y * right.x);
        return vector3f;
    }

    public Vector3f(double x, double y, double z) {
        this((float)x, (float)y, (float)z);
    }

    public String toString() {
        return new StringBuilder().insert(0, "Vector3f[").append(this.x).append(", ").append(this.y).append(", ").append(this.z).append(']').toString();
    }

    public Vec3d toVec3() {
        return new Vec3d((double)this.x, (double)this.y, (double)this.z);
    }

    @Override
    public void setZ(float z) {
        this.z = z;
    }

    /*
     * WARNING - void declaration
     */
    public Vector3f(String string, String string2) {
        void input;
        void v0 = input;
        String[] split = v0.substring(1, v0.length() - 1).split(",");
        if (split.length == 3) {
            Vector3f vector3f = this;
            this.x = Float.parseFloat(split[0]);
            vector3f.y = Float.parseFloat(split[1]);
            vector3f.z = Float.parseFloat(split[2]);
        }
    }

    public void writeToBuffer(ByteBuf data) {
        data.writeFloat(this.x);
        data.writeFloat(this.y);
        data.writeFloat(this.z);
    }

    @Override
    public final void setX(float x) {
        this.x = x;
    }

    @Override
    public Vector scale(float scale) {
        Vector3f vector3f = this;
        vector3f.x *= scale;
        vector3f.y *= scale;
        vector3f.z *= scale;
        return vector3f;
    }

    /*
     * WARNING - void declaration
     */
    public Vector3f set(ReadableVector3f readableVector3f) {
        void src;
        void v0 = src;
        this.x = v0.getX();
        this.y = v0.getY();
        this.z = readableVector3f.getZ();
        return this;
    }

    public Vector3f normalise(Vector3f vector3f) {
        Vector3f dest;
        float l = this.length();
        if (vector3f == null) {
            dest = new Vector3f(this.x / l, this.y / l, this.z / l);
            return dest;
        }
        void v0 = dest;
        v0.set(this.x / l, this.y / l, this.z / l);
        return v0;
    }

    @Override
    public final float getX() {
        return this.x;
    }

    public Vector3f(ReadableVector3f readableVector3f) {
        Vector3f vector3f = this;
        vector3f.set(readableVector3f);
    }

    @Override
    public float getZ() {
        return this.z;
    }

    @Override
    public float lengthSquared() {
        Vector3f vector3f = this;
        Vector3f vector3f2 = this;
        Vector3f vector3f3 = this;
        return vector3f.x * vector3f.x + vector3f2.y * vector3f2.y + vector3f3.z * vector3f3.z;
    }

    public static Vector3f add(Vector3f left, Vector3f right, Vector3f dest) {
        if (dest == null) {
            return new Vector3f(left.x + right.x, left.y + right.y, left.z + right.z);
        }
        Vector3f vector3f = dest;
        vector3f.set(left.x + right.x, left.y + right.y, left.z + right.z);
        return vector3f;
    }

    public static float dot(Vector3f left, Vector3f right) {
        return left.x * right.x + left.y * right.y + left.z * right.z;
    }

    public static Vector3f sub(Vector3f left, Vector3f right, Vector3f dest) {
        if (dest == null) {
            return new Vector3f(left.x - right.x, left.y - right.y, left.z - right.z);
        }
        Vector3f vector3f = dest;
        vector3f.set(left.x - right.x, left.y - right.y, left.z - right.z);
        return vector3f;
    }

    /*
     * WARNING - void declaration
     */
    public Vector3f(float f, float f2, float f3) {
        void z;
        void y;
        Vector3f vector3f = this;
        vector3f.set(f, (float)y, (float)z);
    }

    public Vector3f translate(float x, float y, float z) {
        Vector3f vector3f = this;
        vector3f.x += x;
        vector3f.y += y;
        vector3f.z += z;
        return vector3f;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void set(float f, float f2, float f3) {
        void y;
        void x;
        Vector3f vector3f = this;
        this.x = x;
        vector3f.y = y;
        vector3f.z = f3;
    }

    public Vector3f() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Vector load(FloatBuffer floatBuffer) {
        void buf;
        void v0 = buf;
        this.x = v0.get();
        this.y = v0.get();
        this.z = floatBuffer.get();
        return this;
    }

    @Override
    public Vector store(FloatBuffer buf) {
        Vector3f vector3f = this;
        buf.put(this.x);
        buf.put(vector3f.y);
        buf.put(this.z);
        return vector3f;
    }

    public static Vector3f readFromBuffer(ByteBuf data) {
        return new Vector3f(data.readFloat(), data.readFloat(), data.readFloat());
    }

    public Vector3f negate(Vector3f dest) {
        if (dest == null) {
            dest = new Vector3f();
        }
        Vector3f vector3f = dest;
        Vector3f vector3f2 = this;
        dest.x = -vector3f2.x;
        vector3f.y = -vector3f2.y;
        vector3f.z = -this.z;
        return dest;
    }

    public static float angle(Vector3f a, Vector3f b) {
        float f;
        float f2;
        float dls = Vector3f.dot(a, b) / (a.length() * b.length());
        if (f2 < -1.0f) {
            f = dls = -1.0f;
        } else {
            if (dls > 1.0f) {
                dls = 1.0f;
            }
            f = dls;
        }
        return (float)Math.acos(f);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void set(float f, float f2) {
        void x;
        Vector3f vector3f = this;
        vector3f.x = x;
        vector3f.y = f2;
    }
}

