/*
 * Decompiled with CFR 0.152.
 */
package com.modularwarfare.common.vector;

import com.modularwarfare.common.vector.Vector;
import java.nio.FloatBuffer;
import net.minecraft.util.math.Vec3d;

public class Vector3i
extends Vector {
    public int z;
    private static final long serialVersionUID = 1L;
    public int y;
    public int x;

    public Vector3i translate(int x, int y, int z) {
        Vector3i vector3i = this;
        vector3i.x += x;
        vector3i.y += y;
        vector3i.z += z;
        return vector3i;
    }

    public Vector3i negate(Vector3i dest) {
        if (dest == null) {
            dest = new Vector3i();
        }
        Vector3i vector3i = dest;
        Vector3i vector3i2 = this;
        dest.x = -vector3i2.x;
        vector3i.y = -vector3i2.y;
        vector3i.z = -this.z;
        return dest;
    }

    public static float dot(Vector3i left, Vector3i right) {
        return left.x * right.x + left.y * right.y + left.z * right.z;
    }

    @Override
    public Vector negate() {
        Vector3i vector3i = this;
        vector3i.x = -vector3i.x;
        vector3i.y = -vector3i.y;
        vector3i.z = -vector3i.z;
        return vector3i;
    }

    /*
     * WARNING - void declaration
     */
    public void set(int n, int n2, int n3) {
        void y;
        void x;
        Vector3i vector3i = this;
        this.x = x;
        vector3i.y = y;
        vector3i.z = n3;
    }

    public static Vector3i sub(Vector3i left, Vector3i right, Vector3i dest) {
        if (dest == null) {
            return new Vector3i(left.x - right.x, left.y - right.y, left.z - right.z);
        }
        Vector3i vector3i = dest;
        vector3i.set(left.x - right.x, left.y - right.y, left.z - right.z);
        return vector3i;
    }

    @Override
    public Vector store(FloatBuffer buf) {
        Vector3i vector3i = this;
        buf.put(this.x);
        buf.put(vector3i.y);
        buf.put(this.z);
        return vector3i;
    }

    @Override
    public float lengthSquared() {
        Vector3i vector3i = this;
        Vector3i vector3i2 = this;
        Vector3i vector3i3 = this;
        return vector3i.x * vector3i.x + vector3i2.y * vector3i2.y + vector3i3.z * vector3i3.z;
    }

    public int getZ() {
        return this.z;
    }

    public Vector3i(Vector3i v) {
        Vector3i vector3i = v;
        this(vector3i.x, vector3i.y, v.z);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Vector load(FloatBuffer floatBuffer) {
        void buf;
        void v0 = buf;
        this.x = (int)v0.get();
        this.y = (int)v0.get();
        this.z = (int)floatBuffer.get();
        return this;
    }

    public final void setY(int y) {
        this.y = y;
    }

    public final int getX() {
        return this.x;
    }

    public Vector3i(Vec3d vec) {
        this((int)vec.field_72450_a, (int)vec.field_72448_b, (int)vec.field_72449_c);
    }

    public Vector3i() {
    }

    @Override
    public Vector scale(float scale) {
        Vector3i vector3i = this;
        vector3i.x = (int)((float)vector3i.x * scale);
        vector3i.y = (int)((float)vector3i.y * scale);
        vector3i.z = (int)((float)vector3i.z * scale);
        return vector3i;
    }

    public static Vector3i add(Vector3i left, Vector3i right, Vector3i dest) {
        if (dest == null) {
            return new Vector3i(left.x + right.x, left.y + right.y, left.z + right.z);
        }
        Vector3i vector3i = dest;
        vector3i.set(left.x + right.x, left.y + right.y, left.z + right.z);
        return vector3i;
    }

    /*
     * WARNING - void declaration
     */
    public Vector3i(int n, int n2, int n3) {
        void z;
        void y;
        Vector3i vector3i = this;
        vector3i.set(n, (int)y, (int)z);
    }

    public static float angle(Vector3i a, Vector3i b) {
        float f;
        float f2;
        float dls = Vector3i.dot(a, b) / (a.length() * b.length());
        if (f2 < -1.0f) {
            f = dls = -1.0f;
        } else {
            if (dls > 1.0f) {
                dls = 1.0f;
            }
            f = dls;
        }
        return (float)Math.acos(f);
    }

    public static Vector3i cross(Vector3i left, Vector3i right, Vector3i dest) {
        if (dest == null) {
            dest = new Vector3i();
        }
        Vector3i vector3i = dest;
        vector3i.set(left.y * right.z - left.z * right.y, right.x * left.z - right.z * left.x, left.x * right.y - left.y * right.x);
        return vector3i;
    }

    public Vec3d toVec3() {
        return new Vec3d((double)this.x, (double)this.y, (double)this.z);
    }

    public Vector3i(double x, double y, double z) {
        this((int)x, (int)y, (int)z);
    }

    public Vector3i normalise(Vector3i vector3i) {
        Vector3i dest;
        float l = this.length();
        if (vector3i == null) {
            dest = new Vector3i((float)this.x / l, (float)this.y / l, (float)this.z / l);
            return dest;
        }
        void v0 = dest;
        v0.set((int)((float)this.x / l), (int)((float)this.y / l), (int)((float)this.z / l));
        return v0;
    }

    public String toString() {
        return new StringBuilder().insert(0, "Vector3i[").append(this.x).append(", ").append(this.y).append(", ").append(this.z).append(']').toString();
    }

    public final void setX(int x) {
        this.x = x;
    }

    public void setZ(int z) {
        this.z = z;
    }

    public final int getY() {
        return this.y;
    }
}

