/*
 * Decompiled with CFR 0.152.
 */
package com.modularwarfare.common.vector;

import com.modularwarfare.common.vector.ReadableVector4f;
import com.modularwarfare.common.vector.Vector;
import com.modularwarfare.common.vector.WritableVector4f;
import java.io.Serializable;
import java.nio.FloatBuffer;

public class Vector4f
extends Vector
implements Serializable,
ReadableVector4f,
WritableVector4f {
    public float x;
    public float w;
    private static final long serialVersionUID = 1L;
    public float y;
    public float z;

    public Vector4f negate(Vector4f dest) {
        if (dest == null) {
            dest = new Vector4f();
        }
        Vector4f vector4f = dest;
        Vector4f vector4f2 = this;
        dest.x = -this.x;
        dest.y = -vector4f2.y;
        vector4f.z = -vector4f2.z;
        vector4f.w = -this.w;
        return dest;
    }

    public static float angle(Vector4f a, Vector4f b) {
        float f;
        float f2;
        float dls = Vector4f.dot(a, b) / (a.length() * b.length());
        if (f2 < -1.0f) {
            f = dls = -1.0f;
        } else {
            if (dls > 1.0f) {
                dls = 1.0f;
            }
            f = dls;
        }
        return (float)Math.acos(f);
    }

    public static Vector4f add(Vector4f left, Vector4f right, Vector4f dest) {
        if (dest == null) {
            return new Vector4f(left.x + right.x, left.y + right.y, left.z + right.z, left.w + right.w);
        }
        Vector4f vector4f = dest;
        vector4f.set(left.x + right.x, left.y + right.y, left.z + right.z, left.w + right.w);
        return vector4f;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void set(float f, float f2, float f3, float f4) {
        void z;
        void y;
        void x;
        Vector4f vector4f = this;
        Vector4f vector4f2 = this;
        vector4f2.x = x;
        vector4f2.y = y;
        vector4f.z = z;
        vector4f.w = f4;
    }

    @Override
    public float getZ() {
        return this.z;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void set(float f, float f2, float f3) {
        void y;
        void x;
        Vector4f vector4f = this;
        this.x = x;
        vector4f.y = y;
        vector4f.z = f3;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void set(float f, float f2) {
        void x;
        Vector4f vector4f = this;
        vector4f.x = x;
        vector4f.y = f2;
    }

    public Vector4f(ReadableVector4f readableVector4f) {
        Vector4f vector4f = this;
        vector4f.set(readableVector4f);
    }

    public Vector4f() {
    }

    @Override
    public Vector negate() {
        Vector4f vector4f = this;
        vector4f.x = -vector4f.x;
        vector4f.y = -vector4f.y;
        vector4f.z = -vector4f.z;
        vector4f.w = -vector4f.w;
        return vector4f;
    }

    public Vector4f normalise(Vector4f vector4f) {
        Vector4f dest;
        float l = this.length();
        if (vector4f == null) {
            dest = new Vector4f(this.x / l, this.y / l, this.z / l, this.w / l);
            return dest;
        }
        void v0 = dest;
        v0.set(this.x / l, this.y / l, this.z / l, this.w / l);
        return v0;
    }

    public static Vector4f sub(Vector4f left, Vector4f right, Vector4f dest) {
        if (dest == null) {
            return new Vector4f(left.x - right.x, left.y - right.y, left.z - right.z, left.w - right.w);
        }
        Vector4f vector4f = dest;
        vector4f.set(left.x - right.x, left.y - right.y, left.z - right.z, left.w - right.w);
        return vector4f;
    }

    /*
     * WARNING - void declaration
     */
    public Vector4f(float f, float f2, float f3, float f4) {
        void w;
        void z;
        void y;
        Vector4f vector4f = this;
        vector4f.set(f, (float)y, (float)z, (float)w);
    }

    @Override
    public final float getY() {
        return this.y;
    }

    public String toString() {
        return new StringBuilder().insert(0, "Vector4f: ").append(this.x).append(" ").append(this.y).append(" ").append(this.z).append(" ").append(this.w).toString();
    }

    @Override
    public final float getX() {
        return this.x;
    }

    public static float dot(Vector4f left, Vector4f right) {
        return left.x * right.x + left.y * right.y + left.z * right.z + left.w * right.w;
    }

    @Override
    public final void setX(float x) {
        this.x = x;
    }

    @Override
    public final void setY(float y) {
        this.y = y;
    }

    public Vector4f translate(float x, float y, float z, float w) {
        Vector4f vector4f = this;
        vector4f.x += x;
        vector4f.y += y;
        vector4f.z += z;
        vector4f.w += w;
        return vector4f;
    }

    @Override
    public float lengthSquared() {
        Vector4f vector4f = this;
        Vector4f vector4f2 = this;
        Vector4f vector4f3 = this;
        Vector4f vector4f4 = this;
        return vector4f.x * vector4f.x + vector4f2.y * vector4f2.y + vector4f3.z * vector4f3.z + vector4f4.w * vector4f4.w;
    }

    @Override
    public void setZ(float z) {
        this.z = z;
    }

    @Override
    public Vector store(FloatBuffer buf) {
        Vector4f vector4f = this;
        buf.put(this.x);
        buf.put(vector4f.y);
        buf.put(this.z);
        buf.put(this.w);
        return vector4f;
    }

    @Override
    public float getW() {
        return this.w;
    }

    @Override
    public void setW(float w) {
        this.w = w;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Vector load(FloatBuffer floatBuffer) {
        void buf;
        void v0 = buf;
        this.x = buf.get();
        this.y = v0.get();
        this.z = v0.get();
        this.w = floatBuffer.get();
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public Vector4f set(ReadableVector4f readableVector4f) {
        void src;
        void v0 = src;
        this.x = src.getX();
        this.y = v0.getY();
        this.z = v0.getZ();
        this.w = readableVector4f.getW();
        return this;
    }

    @Override
    public Vector scale(float scale) {
        Vector4f vector4f = this;
        vector4f.x *= scale;
        vector4f.y *= scale;
        vector4f.z *= scale;
        vector4f.w *= scale;
        return vector4f;
    }
}

