/*
 * Decompiled with CFR 0.152.
 */
package com.modularwarfare.loader;

import com.modularwarfare.ModularWarfare;
import com.modularwarfare.loader.api.model.AbstractObjModel;
import com.modularwarfare.loader.api.model.ObjModelRenderer;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ObjModel
extends AbstractObjModel {
    private List<ObjModelRenderer> duplications;
    public float modelScale;
    public List<ObjModelRenderer> parts;

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderAllExcept(float scale, ObjModelRenderer ... excludedPartsIn) {
        ObjModel objModel = this;
        objModel.checkForNoDuplications();
        for (ObjModelRenderer part : objModel.parts) {
            if (this.isExcepted(part, excludedPartsIn)) continue;
            part.render(scale);
        }
    }

    private /* synthetic */ boolean isExcepted(ObjModelRenderer part, ObjModelRenderer[] excludedList) {
        int n;
        ObjModelRenderer[] objModelRendererArray = excludedList;
        int n2 = excludedList.length;
        int n3 = n = 0;
        while (n3 < n2) {
            ObjModelRenderer excludedPart = objModelRendererArray[n];
            if (part.equals(excludedPart)) {
                return true;
            }
            n3 = ++n;
        }
        return false;
    }

    void setParts(List<ObjModelRenderer> renderers) {
        this.parts = renderers;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderPart(float scale, ObjModelRenderer partIn) {
        ObjModel objModel = this;
        objModel.checkForNoDuplications();
        for (ObjModelRenderer part : objModel.parts) {
            if (!part.equals(partIn)) continue;
            part.render(scale);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderOnly(float scale, ObjModelRenderer ... partsIn) {
        ObjModel objModel = this;
        objModel.checkForNoDuplications();
        for (ObjModelRenderer part : objModel.parts) {
            int n;
            ObjModelRenderer[] objModelRendererArray = partsIn;
            int n2 = partsIn.length;
            int n3 = n = 0;
            while (n3 < n2) {
                ObjModelRenderer partIn = objModelRendererArray[n];
                if (part.equals(partIn)) {
                    part.render(scale);
                }
                n3 = ++n;
            }
        }
    }

    public ObjModel(List<ObjModelRenderer> list) {
        ObjModel objModel = this;
        ObjModel objModel2 = this;
        objModel2.duplications = new ArrayList<ObjModelRenderer>();
        objModel.modelScale = 1.0f;
        objModel.parts = list;
    }

    @Override
    public List<ObjModelRenderer> getParts() {
        return this.parts;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderPart(float scale, String partName) {
        ObjModel objModel = this;
        objModel.checkForNoDuplications();
        for (ObjModelRenderer part : objModel.parts) {
            if (!partName.equalsIgnoreCase(part.getName())) continue;
            part.render(scale);
        }
    }

    @Override
    public boolean hasDuplications() {
        if (!this.duplications.isEmpty()) {
            return true;
        }
        return false;
    }

    private /* synthetic */ String[] formDuplicationList() {
        int i;
        String[] list = new String[this.duplications.size()];
        int n = i = 0;
        while (n < this.duplications.size()) {
            int n2 = i++;
            list[n2] = this.duplications.get(n2).getName();
            n = i;
        }
        return list;
    }

    @Override
    public ObjModelRenderer getPart(String name) {
        for (ObjModelRenderer part : this.parts) {
            if (!name.equalsIgnoreCase(part.getName())) continue;
            return part;
        }
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderAll(float scale) {
        Iterator<ObjModelRenderer> iterator;
        ObjModel objModel = this;
        objModel.checkForNoDuplications();
        Iterator<ObjModelRenderer> iterator2 = iterator = objModel.parts.iterator();
        while (iterator2.hasNext()) {
            iterator.next().render(scale);
            iterator2 = iterator;
        }
    }

    public ObjModel() {
        ObjModel objModel = this;
        this.duplications = new ArrayList<ObjModelRenderer>();
        this.modelScale = 1.0f;
    }

    @Override
    public void clearDuplications() throws ConcurrentModificationException {
        try {
            for (ObjModelRenderer renderer : this.duplications) {
                this.parts.remove(renderer);
            }
        }
        catch (ConcurrentModificationException e) {
            throw new ConcurrentModificationException(new StringBuilder().insert(0, "You must clear duplications ONLY AFTER passing ObjModelRaw#parts!!!\n").append(e.getMessage()).toString());
        }
        this.duplications.clear();
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void checkForNoDuplications() {
        if (this.hasDuplications()) {
            int n;
            ModularWarfare.LOGGER.error("=============================================================");
            ModularWarfare.LOGGER.error("Duplications were found! You must call method ObjModelRaw#clearDuplications() after adding children to renders.");
            ModularWarfare.LOGGER.error("Duplications:");
            String[] stringArray = this.formDuplicationList();
            int n2 = stringArray.length;
            int n3 = n = 0;
            while (n3 < n2) {
                void str;
                String string = stringArray[n];
                ModularWarfare.LOGGER.error((String)str);
                n3 = ++n;
            }
            ModularWarfare.LOGGER.error("=============================================================");
        }
    }

    @Override
    public void addDuplication(ObjModelRenderer renderer) {
        this.duplications.add(renderer);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderOnly(float scale, String ... groupNames) {
        ObjModel objModel = this;
        objModel.checkForNoDuplications();
        for (ObjModelRenderer part : objModel.parts) {
            int n;
            String[] stringArray = groupNames;
            int n2 = groupNames.length;
            int n3 = n = 0;
            while (n3 < n2) {
                if (stringArray[n].equalsIgnoreCase(part.getName())) {
                    part.render(scale);
                }
                n3 = ++n;
            }
        }
    }
}

